/******************************************************************************\
 gnofin/plugin.c   $Revision: 1.2 $
 Copyright (C) 2000 Ryan Boren

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

/*
 * This plugin hooks up the CBB import code as an import filter.
 *
 * Author:
 *   Ryan Boren (rboren@bigfoot.com)
 */
 
#include "common.h"
#include "dialogs.h"
#include "plugin.h"
#include "gnofin-api.h"
#include "file-filter.h"
#include "cbb-import.h"

static void
free_plugin (PluginData *pd)
{
  trace ("");
  g_free (pd->private_data);
}

gint
init_plugin (PluginData *pd)
{
  FileFilter *filt;
  guint maj, min;

  trace ("libcbb");

  /* Verify gnofin API version */
  gnofin_api_version_get (&maj, &min);
  //if ((maj != GNOFIN_API_VERSION_MAJOR) || (min  < GNOFIN_API_VERSION_MINOR))
  //  return PLUGIN_ERROR_INVALID_API;

  /* initialize PluginData structure */
  pd->free_plugin = free_plugin;
  pd->description = _("CBB import plugin");
  pd->author = "Ryan Boren";

  /* register file importer */
  filt = g_new0 (FileFilter, 1);
  filt->label = _("Check Book Balancer (CBB)");
  filt->import = cbb_import;
  file_filter_register (filt);

  /* remember our importer structure */
  pd->private_data = (gpointer) filt;

  return PLUGIN_OK;
}

