/******************************************************************************\
 gnofin/date-preferences-page.c   $Revision: 1.4 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

//#define ENABLE_DEBUG_TRACE

#include "common.h"
#include <libgnomeui/gnome-uidefs.h>
#include <gtk/gtksignal.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkcheckbutton.h>
#include <ctype.h>
#include "preferences.h"
#include "preferences-pages.h"
#include "money.h"
#include "dialogs.h"
#include "ui-menubar.h"

typedef struct {
  gpointer         key;
  GtkToggleButton *spawn_new_ui;
  GtkToggleButton *load_lastfile;
  GtkToggleButton *new_acc_on_open;
} PageContext;

static void
on_check_button_toggled (GtkToggleButton *button, PageContext *page)
{
  preferences_page_changed (page->key);
}

static GtkWidget *
make_page (PageContext *page)
{
  GtkWidget *vbox;
  //GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *button;

  trace ("");

  vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  /* Page description
   */
   /*
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  label = gtk_label_new (_("Basic menu options"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  */

  /* Spawn new ui check button
   */
  button = gtk_check_button_new_with_label (_("New files are opened into an empty window."));
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  page->spawn_new_ui = GTK_TOGGLE_BUTTON (button);

  gtk_signal_connect (GTK_OBJECT (button), "toggled",
  		      GTK_SIGNAL_FUNC (on_check_button_toggled), page);

  /* Auto account insert check button
   */
  button = gtk_check_button_new ();
  label = gtk_label_new (_("When opening a new window, automatically\nprompt the user to insert an account."));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.0);
  gtk_container_add (GTK_CONTAINER (button), label);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  page->new_acc_on_open = GTK_TOGGLE_BUTTON (button);
  gtk_signal_connect (GTK_OBJECT (button), "toggled",
  		      GTK_SIGNAL_FUNC (on_check_button_toggled), page);


  /* Auto open the last file
   */
  button = gtk_check_button_new_with_label (_("Auto open the last file."));
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  page->load_lastfile = GTK_TOGGLE_BUTTON (button);

  gtk_signal_connect (GTK_OBJECT (button), "toggled",
  		      GTK_SIGNAL_FUNC (on_check_button_toggled), page);

  return vbox;
}

static void
init_page (PageContext *page)
{
  gboolean f1, f2, f3;

  trace ("");

  ui_menubar_get_behavior (&f1, &f2, &f3);
  gtk_toggle_button_set_active (page->spawn_new_ui, f1);
  gtk_toggle_button_set_active (page->new_acc_on_open, f2);
  gtk_toggle_button_set_active (page->load_lastfile, f3);
}

static gboolean
apply_page (GtkWindow *parent, PageContext *page)
{
  gboolean f1, f2, f3;

  trace ("");

  f1 = gtk_toggle_button_get_active (page->spawn_new_ui);
  f2 = gtk_toggle_button_get_active (page->new_acc_on_open);
  f3 = gtk_toggle_button_get_active (page->load_lastfile);
  ui_menubar_set_behavior (f1, f2, f3);
  return TRUE;
}

void
preferences_page_menubar_init (void)
{
  PreferencesPage page = {0};
  PageContext *context;

  trace ("");

  context = g_new0 (PageContext, 1);

  page.category = _("Behavior");
  page.label = _("Opening");
  page.make = (PreferencesPageMakeFunc) make_page;
  page.init = (PreferencesPageInitFunc) init_page;
  page.apply = (PreferencesPageApplyFunc) apply_page;
  page.user_data = context;
  
  context->key = preferences_page_register (&page);
}
