/******************************************************************************\
 gnofin/date-preferences-page.c   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

//#define ENABLE_DEBUG_TRACE

#include "common.h"
#include <libgnomeui/gnome-uidefs.h>
#include <gtk/gtksignal.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtktable.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkeventbox.h>
#include <gtk/gtktooltips.h>
#include <ctype.h>
#include "preferences.h"
#include "preferences-pages.h"
#include "money.h"
#include "dialogs.h"

typedef struct {
  gpointer  key;
  GtkEntry *decimal_sep;
  GtkEntry *thousands_sep;
  GtkEntry *sample;
} PageContext;

static void
refresh_sample_string (PageContext *page)
{
  money_t sample = 1025060;
  gchar buf[512], *text;
  gchar ds, ts;

  trace ("");

  text = gtk_entry_get_text (page->decimal_sep);
  ds = text[0];

  text = gtk_entry_get_text (page->thousands_sep);
  ts = text[0];

  money_stringize_f (buf, sizeof buf, sample, ds, ts);
  gtk_entry_set_text (page->sample, buf);
}

static void
on_value_changed (GtkEntry *entry, PageContext *page)
{
  refresh_sample_string (page);
  preferences_page_changed (page->key);
}

static GtkWidget *
make_page (PageContext *page)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *entry;

  trace ("");

  vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  /* Page description
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  label = gtk_label_new (_("Select the format that Gnofin should use when\ndisplaying monetary values."));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  /* Packing table
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  table = gtk_table_new (3, 2, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);
  gtk_box_pack_start (GTK_BOX (hbox), table, FALSE, FALSE, 0);

  /* Decimal separator entry
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), hbox, 0, 1, 0, 1);

  label = gtk_label_new (_("Decimal separator character:"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 20);

  entry = gtk_entry_new_with_max_length (1);
  gtk_widget_set_usize (entry, 100, -1);
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 0, 1);

  page->decimal_sep = GTK_ENTRY (entry);
  gtk_signal_connect (GTK_OBJECT (entry), "changed",
  		      GTK_SIGNAL_FUNC (on_value_changed), page);

  /* Thousands separator entry
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), hbox, 0, 1, 1, 2);

  label = gtk_label_new (_("Thousands separator character:"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 20);

  entry = gtk_entry_new_with_max_length (1);
  gtk_widget_set_usize (entry, 100, -1);
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 1, 2);

  page->thousands_sep = GTK_ENTRY (entry);
  gtk_signal_connect (GTK_OBJECT (entry), "changed",
  		      GTK_SIGNAL_FUNC (on_value_changed), page);

  /* Date previewer
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), hbox, 0, 1, 2, 3);

  label = gtk_label_new (_("Sample money value:"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 20);

  entry = gtk_entry_new ();
  gtk_widget_set_usize (entry, 100, -1);
  gtk_entry_set_editable (GTK_ENTRY (entry), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 2, 3);

  page->sample = GTK_ENTRY (entry);

  return vbox;
}

static void
init_page (PageContext *page)
{
  gchar b[2];

  trace ("");

  b[1] = '\0';

  b[0] = money_get_decimal_sep ();
  gtk_entry_set_text (page->decimal_sep, b); 

  b[0] = money_get_thousands_sep ();
  gtk_entry_set_text (page->thousands_sep, b);

  refresh_sample_string (page);
}

static gboolean
apply_page (GtkWindow *parent, PageContext *page)
{
  gchar dsep, tsep;

  trace ("");

  dsep = *gtk_entry_get_text (page->decimal_sep);
  tsep = *gtk_entry_get_text (page->thousands_sep);

  if (dsep && isdigit (dsep))
  {
    dialog_error (parent, _("You must specify a valid decimal separator!")); 
    return FALSE;
  }
  if (tsep && isdigit (tsep))
  {
    dialog_error (parent, _("You must specify a valid thousands separator!"));
    return FALSE;
  }

  money_set_format (dsep, tsep);
  return TRUE;
}

void
preferences_page_money_format_init (void)
{
  PreferencesPage page = {0};
  PageContext *context;

  trace ("");

  context = g_new0 (PageContext, 1);

  page.category = _("Appearance");
  page.label = _("Money Format");
  page.make = (PreferencesPageMakeFunc) make_page;
  page.init = (PreferencesPageInitFunc) init_page;
  page.apply = (PreferencesPageApplyFunc) apply_page;
  page.user_data = context;
  
  context->key = preferences_page_register (&page);
}
