/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt package details class
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#include <libgnome/gnome-config.h>

#include "details.h"

static gint
delete_event_handler(GtkWidget* window,
                     GdkEvent* event,
                     gpointer data)
{
  Details* d = static_cast<Details*>(data);
  
  d->hide();

  return TRUE; // prevent destroy
}

Details::Details (void) {
	GtkWidget *box, *check;

	window_ = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_default_size (GTK_WINDOW (window_), 320, 300);
	gtk_window_set_title (GTK_WINDOW (window_), _("Package Details"));
	g_signal_connect (G_OBJECT (window_), "delete_event", G_CALLBACK (delete_event_handler), this);
	gnome_apt_setup_dialog (window_);

	box = gtk_vbox_new (FALSE, GAPT_PAD);
	gtk_container_set_border_width (GTK_CONTAINER (box), GAPT_PAD);
	gtk_container_add (GTK_CONTAINER (window_), box);

	gtk_box_pack_start (GTK_BOX (box), info_.widget(), TRUE, TRUE, 0);

	gtk_widget_show_all (box);
}

Details::~Details()
{
  if (window_) gtk_widget_destroy(window_);
}

static void
gapt_details_save_state (bool state) {
	gnome_config_set_bool ("/gnome-apt/preferences/info_hidden", state);
	gnome_config_sync();
}

void
Details::show (void) {
	gapt_details_save_state (FALSE);

	if (!GTK_WIDGET_VISIBLE (window_)) {
		gtk_widget_show (window_);
	} else {
      gdk_window_show(window_->window);
      gdk_window_raise(window_->window);
    }
}

void
Details::hide (void) {
	gapt_details_save_state (TRUE);
	gtk_widget_hide (window_);
}
