/**
 * vim: sw=4:ts=4:
 *
 * Gnome-Apt pixbuf loader
 *
 * 	(C) 2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef _GAPT_PIXBUF_H
#define _GAPT_PIXBUF_H

#include <gdk-pixbuf/gdk-pixbuf.h>

G_BEGIN_DECLS

typedef enum {
	GAPT_PIXBUF_SECTION,
	GAPT_PIXBUF_PACKAGE,
	GAPT_PIXBUF_DEPENDS,
	GAPT_PIXBUF_RECOMMENDS,
	GAPT_PIXBUF_SUGGESTS,
	GAPT_PIXBUF_REPLACES,
	GAPT_PIXBUF_CONFLICTS,
	GAPT_PIXBUF_UNKNOWN
} GAptPixbufType;

#define GAPT_PIXBUF_TYPE	(gapt_pixbuf_get_type())
#define GAPT_PIXBUF(obj)	(G_TYPE_CHECK_INSTANCE_CAST ((obj), GAPT_PIXBUF_TYPE, GAptPixbuf))
#define GAPT_PIXBUF_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GAPT_PIXBUF_TYPE, GAptPixbufClass))
#define IS_GAPT_PIXBUF(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAPT_PIXBUF_TYPE))
#define IS_GAPT_PIXBUF_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GAPT_PIXBUF_TYPE))

typedef struct _GAptPixbuf GAptPixbuf;
typedef struct _GAptPixbufClass GAptPixbufClass;

struct _GAptPixbuf {
	GObject pb;
};

struct _GAptPixbufClass {
	GObjectClass parent_class;
};

GType gapt_pixbuf_get_type (void);
GdkPixbuf* gapt_pixbuf_new (GAptPixbufType);

G_END_DECLS
#endif
