/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt search class
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2003, 2004 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_SEARCH_H
#define GNOME_APT_SEARCH_H

#include <vector>
#include <map>
#include <gtk/gtk.h>

class GAptCacheFile;

class SearchPattern {
public:
  SearchPattern() : case_sensitive_(false) {}
  ~SearchPattern() {}

  typedef enum {
    Package,
    Maintainer,
    Conffiles,
    ShortDescription,
    LongDescription,
    // more later...
    TextFieldTypeEnd
  } TextFieldType;

  void set_textfield(TextFieldType tft, bool state) {
    textfields_[tft] = state;
  }

  bool get_textfield(TextFieldType tft) {
    map<TextFieldType,bool>::iterator i = textfields_.find(tft);
    if (i != textfields_.end()) 
      return i->second;
    else 
      return true;  // default to true
  }

  void set_case_sensitive(bool state) { case_sensitive_ = state; }
  bool get_case_sensitive() { return case_sensitive_; }

	void set_regexp (string& re) {
		regexps_.erase (regexps_.begin(), regexps_.end());
	   	regexps_.push_back (re);
	}
	void search (GAptCacheFile*, vector<pkgCache::Package*>&);

private:
  bool case_sensitive_;
  vector<string> regexps_;
  map<TextFieldType,bool> textfields_;

  // more stuff to come
};

#define GAPT_SEARCH_TYPE	(gapt_search_get_type())
#define GAPT_SEARCH(obj)	(G_TYPE_CHECK_INSTANCE_CAST ((obj), GAPT_SEARCH_TYPE, GAptSearch))
#define GAPT_SEARCH_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GAPT_SEARCH_TYPE, GAptSearchClass))
#define IS_GAPT_SEARCH(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAPT_SEARCH_TYPE))
#define IS_GAPT_SEARCH_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GAPT_SEARCH_TYPE))

typedef struct _GAptSearch GAptSearch;
typedef struct _GAptSearchClass GAptSearchClass;

struct _GAptSearch {
	GtkTable tbl;

	GtkWidget* entry_;
	GtkWidget* case_sensitive_toggle_;
	GtkWidget* package_toggle_;
	GtkWidget* maintainer_toggle_;
	GtkWidget* conffiles_toggle_;
	GtkWidget* short_toggle_;
	GtkWidget* long_toggle_;

	SearchPattern* s_needle;
	bool s_ran;
	vector<pkgCache::Package*> s_hits;
	GAptCacheFile* cachefile;

/*public*/
	void run (void);
	bool filter_package (pkgCache::Package*);
};

struct _GAptSearchClass {
	GtkTableClass parent_class;

	void (*filter_changed) (GAptSearch*);
};

GType gapt_search_get_type (void);
GtkWidget* gapt_search_new (GAptCacheFile*);

#endif
