/* chess-move.c generated by valac 0.36.0.2-c0ff, the Vala compiler
 * generated from chess-move.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2016 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ChessMovePrivate ChessMovePrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHECK_STATE (check_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_COLOR (color_get_type ())

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessMove {
	GObject parent_instance;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GObjectClass parent_class;
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GObject parent_instance;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;


static gpointer chess_move_parent_class = NULL;

GType chess_move_get_type (void) G_GNUC_CONST;
GType chess_piece_get_type (void) G_GNUC_CONST;
GType check_state_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_MOVE_DUMMY_PROPERTY
};
gchar* chess_move_get_lan (ChessMove* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
gchar* chess_move_get_san (ChessMove* self);
static gchar* chess_move_make_san (ChessMove* self, gchar** piece_names, int piece_names_length1);
gchar* chess_move_get_fan (ChessMove* self);
GType color_get_type (void) G_GNUC_CONST;
Color chess_piece_get_color (ChessPiece* self);
gchar* chess_move_get_engine (ChessMove* self);
ChessMove* chess_move_copy (ChessMove* self);
ChessMove* chess_move_new (void);
ChessMove* chess_move_construct (GType object_type);
static void chess_move_finalize (GObject * obj);


gchar* chess_move_get_lan (ChessMove* self) {
	gchar* result = NULL;
	ChessPiece* _tmp0_;
	GString* builder;
	GString* _tmp5_;
	ChessPiece* _tmp6_;
#line 43 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	static const gchar promotion_symbols[] = {' ', 'R', 'N', 'B', 'Q', 'K'};
#line 146 "chess-move.c"
	ChessPiece* _tmp17_;
	CheckState _tmp22_;
	GString* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp0_ = self->moved_rook;
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	if (_tmp0_ != NULL) {
#line 158 "chess-move.c"
		gint _tmp1_;
		gint _tmp2_;
#line 31 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp1_ = self->f1;
#line 31 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp2_ = self->f0;
#line 31 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		if (_tmp1_ > _tmp2_) {
#line 167 "chess-move.c"
			gchar* _tmp3_;
#line 32 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			_tmp3_ = g_strdup ("O-O");
#line 32 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			result = _tmp3_;
#line 32 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			return result;
#line 175 "chess-move.c"
		} else {
			gchar* _tmp4_;
#line 34 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			_tmp4_ = g_strdup ("O-O-O");
#line 34 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			result = _tmp4_;
#line 34 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			return result;
#line 184 "chess-move.c"
		}
	}
#line 37 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp5_ = g_string_new ("");
#line 37 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	builder = _tmp5_;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp6_ = self->victim;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	if (_tmp6_ != NULL) {
#line 195 "chess-move.c"
		GString* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp7_ = builder;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp8_ = self->f0;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp9_ = self->r0;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp10_ = self->f1;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp11_ = self->r1;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		g_string_append_printf (_tmp7_, "%c%dx%c%d", 'a' + _tmp8_, _tmp9_ + 1, 'a' + _tmp10_, _tmp11_ + 1);
#line 213 "chess-move.c"
	} else {
		GString* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp12_ = builder;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp13_ = self->f0;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp14_ = self->r0;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp15_ = self->f1;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp16_ = self->r1;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		g_string_append_printf (_tmp12_, "%c%d-%c%d", 'a' + _tmp13_, _tmp14_ + 1, 'a' + _tmp15_, _tmp16_ + 1);
#line 232 "chess-move.c"
	}
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp17_ = self->promotion_piece;
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	if (_tmp17_ != NULL) {
#line 238 "chess-move.c"
		GString* _tmp18_;
		ChessPiece* _tmp19_;
		PieceType _tmp20_;
		gchar _tmp21_;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp18_ = builder;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp19_ = self->promotion_piece;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp20_ = _tmp19_->type;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp21_ = promotion_symbols[_tmp20_];
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		g_string_append_printf (_tmp18_, "=%c", (gint) _tmp21_);
#line 253 "chess-move.c"
	}
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp22_ = self->check_state;
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	switch (_tmp22_) {
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		case CHECK_STATE_CHECK:
#line 261 "chess-move.c"
		{
			GString* _tmp23_;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			_tmp23_ = builder;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			g_string_append_c (_tmp23_, '+');
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			break;
#line 270 "chess-move.c"
		}
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		case CHECK_STATE_CHECKMATE:
#line 274 "chess-move.c"
		{
			GString* _tmp24_;
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			_tmp24_ = builder;
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			g_string_append_c (_tmp24_, '#');
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			break;
#line 283 "chess-move.c"
		}
		default:
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		break;
#line 288 "chess-move.c"
	}
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp25_ = builder;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp26_ = _tmp25_->str;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp27_ = g_strdup (_tmp26_);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	result = _tmp27_;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_string_free0 (builder);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	return result;
#line 302 "chess-move.c"
}


gchar* chess_move_get_san (ChessMove* self) {
	gchar* result = NULL;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	static const gchar* piece_names[] = {"", "R", "N", "B", "Q", "K"};
#line 310 "chess-move.c"
	gchar* _tmp0_;
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp0_ = chess_move_make_san (self, (gchar**) piece_names, (G_N_ELEMENTS (piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	result = _tmp0_;
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	return result;
#line 320 "chess-move.c"
}


gchar* chess_move_get_fan (ChessMove* self) {
	gchar* result = NULL;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	static const gchar* white_piece_names[] = {"", "♖", "♘", "♗", "♕", "♔"};
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	static const gchar* black_piece_names[] = {"", "♜", "♞", "♝", "♛", "♚"};
#line 330 "chess-move.c"
	ChessPiece* _tmp0_;
	Color _tmp1_;
	Color _tmp2_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp0_ = self->piece;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp1_ = chess_piece_get_color (_tmp0_);
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp2_ = _tmp1_;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 344 "chess-move.c"
		gchar* _tmp3_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp3_ = chess_move_make_san (self, (gchar**) white_piece_names, (G_N_ELEMENTS (white_piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		result = _tmp3_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		return result;
#line 352 "chess-move.c"
	} else {
		gchar* _tmp4_;
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp4_ = chess_move_make_san (self, (gchar**) black_piece_names, (G_N_ELEMENTS (black_piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		result = _tmp4_;
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		return result;
#line 361 "chess-move.c"
	}
}


static gchar* chess_move_make_san (ChessMove* self, gchar** piece_names, int piece_names_length1) {
	gchar* result = NULL;
	ChessPiece* _tmp0_;
	GString* builder;
	GString* _tmp5_;
	GString* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ChessPiece* _tmp8_;
	PieceType _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp14_;
	ChessPiece* _tmp17_;
	GString* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	ChessPiece* _tmp22_;
	CheckState _tmp28_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
#line 76 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp0_ = self->moved_rook;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	if (_tmp0_ != NULL) {
#line 394 "chess-move.c"
		gint _tmp1_;
		gint _tmp2_;
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp1_ = self->f1;
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp2_ = self->f0;
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		if (_tmp1_ > _tmp2_) {
#line 403 "chess-move.c"
			gchar* _tmp3_;
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			_tmp3_ = g_strdup ("O-O");
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			result = _tmp3_;
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			return result;
#line 411 "chess-move.c"
		} else {
			gchar* _tmp4_;
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			_tmp4_ = g_strdup ("O-O-O");
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			result = _tmp4_;
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			return result;
#line 420 "chess-move.c"
		}
	}
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp5_ = g_string_new ("");
#line 86 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	builder = _tmp5_;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp6_ = builder;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp7_ = piece_names;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp7__length1 = piece_names_length1;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp8_ = self->piece;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp9_ = _tmp8_->type;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp10_ = _tmp7_[_tmp9_];
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	g_string_append (_tmp6_, _tmp10_);
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp11_ = self->ambiguous_file;
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	if (_tmp11_) {
#line 445 "chess-move.c"
		GString* _tmp12_;
		gint _tmp13_;
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp12_ = builder;
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp13_ = self->f0;
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		g_string_append_printf (_tmp12_, "%c", 'a' + _tmp13_);
#line 454 "chess-move.c"
	}
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp14_ = self->ambiguous_rank;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	if (_tmp14_) {
#line 460 "chess-move.c"
		GString* _tmp15_;
		gint _tmp16_;
#line 91 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp15_ = builder;
#line 91 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp16_ = self->r0;
#line 91 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		g_string_append_printf (_tmp15_, "%d", _tmp16_ + 1);
#line 469 "chess-move.c"
	}
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp17_ = self->victim;
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	if (_tmp17_ != NULL) {
#line 475 "chess-move.c"
		GString* _tmp18_;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp18_ = builder;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		g_string_append (_tmp18_, "x");
#line 481 "chess-move.c"
	}
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp19_ = builder;
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp20_ = self->f1;
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp21_ = self->r1;
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	g_string_append_printf (_tmp19_, "%c%d", 'a' + _tmp20_, _tmp21_ + 1);
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp22_ = self->promotion_piece;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	if (_tmp22_ != NULL) {
#line 495 "chess-move.c"
		GString* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		ChessPiece* _tmp25_;
		PieceType _tmp26_;
		const gchar* _tmp27_;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp23_ = builder;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp24_ = piece_names;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp24__length1 = piece_names_length1;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp25_ = self->promotion_piece;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp26_ = _tmp25_->type;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp27_ = _tmp24_[_tmp26_];
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		g_string_append_printf (_tmp23_, "=%s", _tmp27_);
#line 516 "chess-move.c"
	}
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp28_ = self->check_state;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	switch (_tmp28_) {
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		case CHECK_STATE_CHECK:
#line 524 "chess-move.c"
		{
			GString* _tmp29_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			_tmp29_ = builder;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			g_string_append_c (_tmp29_, '+');
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			break;
#line 533 "chess-move.c"
		}
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		case CHECK_STATE_CHECKMATE:
#line 537 "chess-move.c"
		{
			GString* _tmp30_;
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			_tmp30_ = builder;
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			g_string_append_c (_tmp30_, '#');
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
			break;
#line 546 "chess-move.c"
		}
		default:
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		break;
#line 551 "chess-move.c"
	}
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp31_ = builder;
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp32_ = _tmp31_->str;
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp33_ = g_strdup (_tmp32_);
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	result = _tmp33_;
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_string_free0 (builder);
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	return result;
#line 565 "chess-move.c"
}


gchar* chess_move_get_engine (ChessMove* self) {
	gchar* result = NULL;
	GString* builder;
	GString* _tmp0_;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	static const gchar promotion_symbols[] = {' ', 'r', 'n', 'b', 'q', ' '};
#line 575 "chess-move.c"
	ChessPiece* _tmp1_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp0_ = g_string_new ("");
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	builder = _tmp0_;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp1_ = self->promotion_piece;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	if (_tmp1_ != NULL) {
#line 590 "chess-move.c"
		GString* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		ChessPiece* _tmp7_;
		PieceType _tmp8_;
		gchar _tmp9_;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp2_ = builder;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp3_ = self->f0;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp4_ = self->r0;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp5_ = self->f1;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp6_ = self->r1;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp7_ = self->promotion_piece;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp8_ = _tmp7_->type;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp9_ = promotion_symbols[_tmp8_];
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		g_string_append_printf (_tmp2_, "%c%d%c%d%c", 'a' + _tmp3_, _tmp4_ + 1, 'a' + _tmp5_, _tmp6_ + 1, (gint) _tmp9_);
#line 617 "chess-move.c"
	} else {
		GString* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp10_ = builder;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp11_ = self->f0;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp12_ = self->r0;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp13_ = self->f1;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		_tmp14_ = self->r1;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
		g_string_append_printf (_tmp10_, "%c%d%c%d", 'a' + _tmp11_, _tmp12_ + 1, 'a' + _tmp13_, _tmp14_ + 1);
#line 636 "chess-move.c"
	}
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp15_ = builder;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp16_ = _tmp15_->str;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	result = _tmp17_;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_string_free0 (builder);
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	return result;
#line 650 "chess-move.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	return self ? g_object_ref (self) : NULL;
#line 657 "chess-move.c"
}


ChessMove* chess_move_copy (ChessMove* self) {
	ChessMove* result = NULL;
	ChessMove* move;
	ChessMove* _tmp0_;
	gint _tmp1_;
	ChessPiece* _tmp2_;
	ChessPiece* _tmp3_;
	ChessPiece* _tmp4_;
	ChessPiece* _tmp5_;
	ChessPiece* _tmp6_;
	ChessPiece* _tmp7_;
	ChessPiece* _tmp8_;
	ChessPiece* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	CheckState _tmp16_;
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp0_ = chess_move_new ();
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move = _tmp0_;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp1_ = self->number;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->number = _tmp1_;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp2_ = self->piece;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_object_unref0 (move->piece);
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->piece = _tmp3_;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp4_ = self->promotion_piece;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_object_unref0 (move->promotion_piece);
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->promotion_piece = _tmp5_;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp6_ = self->moved_rook;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_object_unref0 (move->moved_rook);
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->moved_rook = _tmp7_;
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp8_ = self->victim;
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_object_unref0 (move->victim);
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->victim = _tmp9_;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp10_ = self->r0;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->r0 = _tmp10_;
#line 133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp11_ = self->f0;
#line 133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->f0 = _tmp11_;
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp12_ = self->r1;
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->r1 = _tmp12_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp13_ = self->f1;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->f1 = _tmp13_;
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp14_ = self->ambiguous_rank;
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->ambiguous_rank = _tmp14_;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp15_ = self->ambiguous_file;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->ambiguous_file = _tmp15_;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_tmp16_ = self->check_state;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	move->check_state = _tmp16_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	result = move;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	return result;
#line 755 "chess-move.c"
}


ChessMove* chess_move_construct (GType object_type) {
	ChessMove * self = NULL;
#line 12 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	self = (ChessMove*) g_object_new (object_type, NULL);
#line 12 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	return self;
#line 765 "chess-move.c"
}


ChessMove* chess_move_new (void) {
#line 12 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	return chess_move_construct (TYPE_CHESS_MOVE);
#line 772 "chess-move.c"
}


static void chess_move_class_init (ChessMoveClass * klass) {
#line 12 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	chess_move_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_move_finalize;
#line 781 "chess-move.c"
}


static void chess_move_instance_init (ChessMove * self) {
}


static void chess_move_finalize (GObject * obj) {
	ChessMove * self;
#line 12 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_MOVE, ChessMove);
#line 15 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_object_unref0 (self->piece);
#line 16 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_object_unref0 (self->promotion_piece);
#line 17 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_object_unref0 (self->moved_rook);
#line 18 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	_g_object_unref0 (self->victim);
#line 12 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-move.vala"
	G_OBJECT_CLASS (chess_move_parent_class)->finalize (obj);
#line 803 "chess-move.c"
}


GType chess_move_get_type (void) {
	static volatile gsize chess_move_type_id__volatile = 0;
	if (g_once_init_enter (&chess_move_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessMoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_move_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessMove), 0, (GInstanceInitFunc) chess_move_instance_init, NULL };
		GType chess_move_type_id;
		chess_move_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessMove", &g_define_type_info, 0);
		g_once_init_leave (&chess_move_type_id__volatile, chess_move_type_id);
	}
	return chess_move_type_id__volatile;
}



