/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * compiz-tray-icon.c
 * Copyright (C) Nicolas Bruguier 2006 <gandalfn@club-internet.fr>
 * 
 * compiz-tray-icon is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * compiz-tray-icon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with compiz-tray-icon.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <config.h>

#include <gnome.h>
#include <libgnomeui/libgnomeui.h>
#include <libgnome/gnome-desktop-item.h>

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif


#include "gcm-tray-icon.h"

static GnomeClient * client;

static void
tray_icon_autostart(gboolean enable)
{
	gchar * autostart_path = g_build_filename(g_get_user_config_dir (),
											  "autostart", NULL);
	gchar * desktop_file = g_build_filename(autostart_path, 
                                            "compiz-tray-icon.desktop", NULL);
		
    g_mkdir_with_parents(autostart_path, S_IRWXU);
		
	if (!enable)
	{
		if (g_file_test(desktop_file, G_FILE_TEST_EXISTS))
			unlink(desktop_file);
	}
	else
	{
		GnomeDesktopItem * ditem = gnome_desktop_item_new();
		
		gnome_desktop_item_set_string(ditem, GNOME_DESKTOP_ITEM_EXEC, 
									  "compiz-tray-icon");
		gnome_desktop_item_save(ditem, desktop_file, TRUE, NULL);
		gnome_desktop_item_unref (ditem);
    }
	g_free(autostart_path);
	g_free(desktop_file);
}
	
static void session_die (GnomeClient *client, gpointer client_data)
{
	gtk_main_quit ();
}

static void on_tray_icon_stopped (GCMTrayIcon *icon)
{
	tray_icon_autostart(FALSE);
	gtk_main_quit ();
}

int
main (int argc, char *argv[])
{
 	GCMTrayIcon *tray;
	
#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gnome_program_init ("compiz-tray-icon", VERSION,
		      LIBGNOMEUI_MODULE, argc, argv,
		      GNOME_PARAM_NONE);
	
	if ((tray = gcm_tray_icon_new()) == NULL)
	{
		tray_icon_autostart(FALSE);
		return 0;
	}
	
	g_signal_connect (client, "save_yourself", G_CALLBACK (gtk_true), NULL);
	g_signal_connect (client, "die", G_CALLBACK (session_die), NULL);
	g_signal_connect (tray, "stopped", G_CALLBACK (on_tray_icon_stopped), NULL);

    gtk_main ();
	g_object_unref(tray);
	
	return 0;
}
