/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gcm-gl-desktop.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "gcm-gl-desktop.gob"

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <gnome.h>
#include <libgnome/gnome-desktop-item.h>

#include "gcm-application.h"
#include "gcm-gl-option-gconf.h"

#line 39 "gcm-gl-desktop.c"
/* self casting macros */
#define SELF(x) GCM_GL_DESKTOP(x)
#define SELF_CONST(x) GCM_GL_DESKTOP_CONST(x)
#define IS_SELF(x) GCM_IS_GL_DESKTOP(x)
#define TYPE_SELF GCM_TYPE_GL_DESKTOP
#define SELF_CLASS(x) GCM_GL_DESKTOP_CLASS(x)

#define SELF_GET_CLASS(x) GCM_GL_DESKTOP_GET_CLASS(x)

/* self typedefs */
typedef GCMGLDesktop Self;
typedef GCMGLDesktopClass SelfClass;

struct _GCMGLDesktopPrivate {
#line 47 "gcm-gl-desktop.gob"
	GCMXorg * xorg;
#line 58 "gcm-gl-desktop.gob"
	GSList * templates;
#line 75 "gcm-gl-desktop.gob"
	GHashTable * gl_desktop_plugins;
#line 77 "gcm-gl-desktop.gob"
	GCMGLOption * active_plugins;
#line 79 "gcm-gl-desktop.gob"
	GCMApplication * compiz;
#line 81 "gcm-gl-desktop.gob"
	guint version;
#line 91 "gcm-gl-desktop.gob"
	GCMApplication * gnome_window_decorator;
#line 93 "gcm-gl-desktop.gob"
	gboolean aiglx;
#line 70 "gcm-gl-desktop.c"
};
/* here are local prototypes */
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void gcm_gl_desktop_init (GCMGLDesktop * o) G_GNUC_UNUSED;
static void gcm_gl_desktop_class_init (GCMGLDesktopClass * c) G_GNUC_UNUSED;
static gint gcm_gl_desktop_compare_plugin (gchar * a, gchar * b, GCMGLDesktop * self) G_GNUC_UNUSED;
static gboolean gcm_gl_desktop_search_template (GCMGLDesktop * self) G_GNUC_UNUSED;
static void gcm_gl_desktop_create_session_launcher (GCMGLDesktop * self) G_GNUC_UNUSED;
static void gcm_gl_desktop_get_compiz_version (GCMGLDesktop * self) G_GNUC_UNUSED;
static gboolean gcm_gl_desktop_check_nvidia_aiglx (GCMGLDesktop * self) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_XORG,
	PROP_TEMPLATES,
	PROP_VERSION
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_xorg gcm_gl_desktop_get_xorg
#define self_get_templates gcm_gl_desktop_get_templates
#define self_get_version gcm_gl_desktop_get_version
#define self_new gcm_gl_desktop_new
#define self_start gcm_gl_desktop_start
#define self_stop gcm_gl_desktop_stop
#define self_enabled gcm_gl_desktop_enabled
#define self_session_startup_active gcm_gl_desktop_session_startup_active
#define self_activate_on_startup gcm_gl_desktop_activate_on_startup
#define self_desactivate_on_startup gcm_gl_desktop_desactivate_on_startup
#define self_register_and_enable_plugin gcm_gl_desktop_register_and_enable_plugin
#define self_register_plugin gcm_gl_desktop_register_plugin
#define self_enable_plugin gcm_gl_desktop_enable_plugin
#define self_disable_plugin gcm_gl_desktop_disable_plugin
#define self_plugin_is_active gcm_gl_desktop_plugin_is_active
#define self_get_plugin gcm_gl_desktop_get_plugin
#define self_window_decorator_autostart gcm_gl_desktop_window_decorator_autostart
#define self_get_option gcm_gl_desktop_get_option
#define self_get_gl_manager gcm_gl_desktop_get_gl_manager
#define self_compare_plugin gcm_gl_desktop_compare_plugin
#define self_search_template gcm_gl_desktop_search_template
#define self_create_session_launcher gcm_gl_desktop_create_session_launcher
#define self_get_compiz_version gcm_gl_desktop_get_compiz_version
#define self_check_nvidia_aiglx gcm_gl_desktop_check_nvidia_aiglx
GType
gcm_gl_desktop_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GCMGLDesktopClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gcm_gl_desktop_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GCMGLDesktop),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gcm_gl_desktop_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "GCMGLDesktop", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GCMGLDesktop *)g_object_new(gcm_gl_desktop_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GCMGLDesktop * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GCMGLDesktop *
GET_NEW_VARG (const char *first, ...)
{
	GCMGLDesktop *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GCMGLDesktop *)g_object_new_valist (gcm_gl_desktop_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::finalize"
	GCMGLDesktop *self G_GNUC_UNUSED = GCM_GL_DESKTOP (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 48 "gcm-gl-desktop.gob"
	if(self->_priv->xorg) { g_object_unref ((gpointer) self->_priv->xorg); self->_priv->xorg = NULL; }
#line 170 "gcm-gl-desktop.c"
#define templates (self->_priv->templates)
#define VAR templates
	{
#line 59 "gcm-gl-desktop.gob"
	
			if (templates)
			{
				g_slist_foreach(templates, (GFunc)g_object_unref, NULL);
				g_slist_free(templates);
			}
		}
#line 182 "gcm-gl-desktop.c"
	memset(&templates, 0, sizeof(templates));
#undef VAR
#undef templates
#line 76 "gcm-gl-desktop.gob"
	if(self->_priv->gl_desktop_plugins) { g_hash_table_destroy ((gpointer) self->_priv->gl_desktop_plugins); self->_priv->gl_desktop_plugins = NULL; }
#line 188 "gcm-gl-desktop.c"
#line 78 "gcm-gl-desktop.gob"
	if(self->_priv->active_plugins) { g_object_unref ((gpointer) self->_priv->active_plugins); self->_priv->active_plugins = NULL; }
#line 191 "gcm-gl-desktop.c"
#line 80 "gcm-gl-desktop.gob"
	if(self->_priv->compiz) { g_object_unref ((gpointer) self->_priv->compiz); self->_priv->compiz = NULL; }
#line 194 "gcm-gl-desktop.c"
#line 92 "gcm-gl-desktop.gob"
	if(self->_priv->gnome_window_decorator) { g_object_unref ((gpointer) self->_priv->gnome_window_decorator); self->_priv->gnome_window_decorator = NULL; }
#line 197 "gcm-gl-desktop.c"
}
#undef __GOB_FUNCTION__

static void 
gcm_gl_desktop_init (GCMGLDesktop * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,GCM_TYPE_GL_DESKTOP,GCMGLDesktopPrivate);
#line 72 "gcm-gl-desktop.gob"
	o->_priv->version = 0;
#line 208 "gcm-gl-desktop.c"
#line 88 "gcm-gl-desktop.gob"
	o->_priv->aiglx = FALSE;
#line 211 "gcm-gl-desktop.c"
}
#undef __GOB_FUNCTION__
static void 
gcm_gl_desktop_class_init (GCMGLDesktopClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(GCMGLDesktopPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("xorg" /* name */,
		 "Xorg" /* nick */,
		 "X server" /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_XORG,
		param_spec);
	param_spec = g_param_spec_pointer
		("templates" /* name */,
		 "XorgTemplates" /* nick */,
		 "Xorg config templates" /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_TEMPLATES,
		param_spec);
	param_spec = g_param_spec_uint
		("version" /* name */,
		 "Version" /* nick */,
		 "GL Desktop version" /* blurb */,
		 0 /* minimum */,
		 G_MAXUINT /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_VERSION,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "GCM:GL:Desktop::get_property"
{
	GCMGLDesktop *self G_GNUC_UNUSED;

	self = GCM_GL_DESKTOP (object);

	switch (property_id) {
	case PROP_XORG:
		{
#line 55 "gcm-gl-desktop.gob"

			g_value_set_pointer(VAL, selfp->xorg);
		
#line 278 "gcm-gl-desktop.c"
		}
		break;
	case PROP_TEMPLATES:
		{
#line 72 "gcm-gl-desktop.gob"

			g_value_set_pointer(VAL, selfp->templates);
		
#line 287 "gcm-gl-desktop.c"
		}
		break;
	case PROP_VERSION:
		{
#line 88 "gcm-gl-desktop.gob"

			g_value_set_uint(VAL, selfp->version);
		
#line 296 "gcm-gl-desktop.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 55 "gcm-gl-desktop.gob"
gpointer 
gcm_gl_desktop_get_xorg (GCMGLDesktop * self)
#line 316 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::get_xorg"
{
#line 49 "gcm-gl-desktop.gob"
		gpointer val; g_object_get (G_OBJECT (self), "xorg", &val, NULL); return val;
}}
#line 323 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

#line 72 "gcm-gl-desktop.gob"
gpointer 
gcm_gl_desktop_get_templates (GCMGLDesktop * self)
#line 329 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::get_templates"
{
#line 66 "gcm-gl-desktop.gob"
		gpointer val; g_object_get (G_OBJECT (self), "templates", &val, NULL); return val;
}}
#line 336 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

#line 88 "gcm-gl-desktop.gob"
guint 
gcm_gl_desktop_get_version (GCMGLDesktop * self)
#line 342 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::get_version"
{
#line 82 "gcm-gl-desktop.gob"
		guint val; g_object_get (G_OBJECT (self), "version", &val, NULL); return val;
}}
#line 349 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_new:
 *
 * Create GL Desktop object control
 *
 * Returns: #GCMGLDesktop
 **/
#line 102 "gcm-gl-desktop.gob"
GCMGLDesktop * 
gcm_gl_desktop_new (void)
#line 362 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::new"
{
#line 104 "gcm-gl-desktop.gob"
	
		GCMGLDesktop * self = GET_NEW;
		GSList * item, * active_plugins;
		GList * argv = NULL;
		
		/* Check if in Xgl */
		selfp->xorg = gcm_xorg_new();
		selfp->aiglx = !gcm_xorg_is_xgl(selfp->xorg);
		
		/* Get template */
		self_search_template(self);
		
		/* Create compiz launchers */
		if ((selfp->compiz = gcm_application_new("compiz", "compiz.real", NULL)) == NULL)
		{
			g_warning("Enabled to detect compiz binary !!");
			g_object_unref(self);
			return NULL;
		}
		/* Request compiz version */ 
		self_get_compiz_version(self);
		
		argv = g_list_append(NULL , g_strdup("--replace"));
		argv = g_list_append(NULL , g_strdup("--sync"));
		selfp->gnome_window_decorator = gcm_application_new(WINDOW_DECORATOR, 
															NULL,
															argv);
		/* Create plugin table */
		selfp->gl_desktop_plugins = g_hash_table_new_full(g_str_hash, g_str_equal,
														  NULL, g_object_unref);
		
		/* Active plugins list */
		selfp->active_plugins = self_get_option(self, "active_plugins", 
												GCM_GL_OPTION_SCREEN_ALL);
		
		self_register_and_enable_plugin(self, "gconf");
		self_register_and_enable_plugin(self, "decoration");
		
		/* Register plugin already loaded*/
		active_plugins = gcm_gl_option_get_string_list(selfp->active_plugins);
		for (item = active_plugins; item; item = item->next)
			self_register_plugin(self, item->data);
		g_slist_foreach(active_plugins, (GFunc)g_free, NULL);
		g_slist_free(active_plugins);
		
		/* if version > 0.3.0 set decoration window-decorator command */
		if (selfp->version > 3000)
		{
			GCMGLPlugin * decoration = self_get_plugin(self, "decoration");
			GCMGLOption * wd_command = gcm_gl_plugin_get_option(decoration,
												"command",
												GCM_GL_OPTION_SCREEN_ALL);
			gchar * cmd = g_strdup_printf("%s --sync", WINDOW_DECORATOR);
			
			gcm_gl_option_set_string(wd_command, cmd);
			g_free(cmd);
		}
					
		
		return self;
	}}
#line 428 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_start:
 * @self: #GCMGLDesktop
 *
 * Start GL Desktop
 *
 * Returns: FALSE when startup fail
 **/
#line 174 "gcm-gl-desktop.gob"
gboolean 
gcm_gl_desktop_start (GCMGLDesktop * self)
#line 442 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::start"
#line 174 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
#line 174 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (gboolean )FALSE);
#line 449 "gcm-gl-desktop.c"
{
#line 176 "gcm-gl-desktop.gob"
	
		if (selfp->compiz)
		{
			GList * argv = NULL;

#ifndef USE_GNOME_SESSION
			/* compiz args */
			if (selfp->aiglx)
			{
				if (!self_check_nvidia_aiglx(self) || selfp->version >= 3006 )
				{
					argv = g_list_append(argv, g_strdup("--indirect-rendering"));
					if (selfp->version < 3006)
						argv = g_list_append(argv, g_strdup("--strict-binding"));
				}
				if (selfp->version < 3006)
					argv = g_list_append(argv, g_strdup("--use-cow"));
			}
#endif
			argv = g_list_append(argv, g_strdup("--replace"));
			argv = g_list_append(argv, g_strdup("gconf"));
			gcm_application_set_argv(selfp->compiz, argv);

			/* If driver is nvidia beta and on aiglx set __GL_YIELD */
			if (self_check_nvidia_aiglx(self))
				g_setenv("__GL_YIELD", "NOTHING", TRUE);
			
			/* Start compiz */
			if (gcm_application_start(selfp->compiz))
			{
				/* window decorator if version <= 0.3.x */
				if (selfp->gnome_window_decorator)
					return gcm_application_start(selfp->gnome_window_decorator);
			}
		}
		
		return FALSE;
	}}
#line 490 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_stop:
 * @self: #GCMGLDesktop
 *
 * Stop GL Desktop
 **/
#line 221 "gcm-gl-desktop.gob"
void 
gcm_gl_desktop_stop (GCMGLDesktop * self)
#line 502 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::stop"
#line 221 "gcm-gl-desktop.gob"
	g_return_if_fail (self != NULL);
#line 221 "gcm-gl-desktop.gob"
	g_return_if_fail (GCM_IS_GL_DESKTOP (self));
#line 509 "gcm-gl-desktop.c"
{
#line 223 "gcm-gl-desktop.gob"
	
		/* If driver is nvidia beta and on aiglx unset __GL_YIELD */
		if (self_check_nvidia_aiglx(self))
			g_unsetenv("__GL_YIELD");
		/* Stop compiz */
		if (selfp->compiz) 
			gcm_application_stop(selfp->compiz);
		/* Window managers */
		if (selfp->gnome_window_decorator) 
			gcm_application_stop(selfp->gnome_window_decorator);
	}}
#line 523 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_enabled:
 * @self: #GCMGLDesktop
 *
 * Check if GL Desktop is started
 *
 * Returns: TRUE when GL Desktop is started
 **/
#line 243 "gcm-gl-desktop.gob"
gboolean 
gcm_gl_desktop_enabled (GCMGLDesktop * self)
#line 537 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::enabled"
#line 243 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
#line 243 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (gboolean )FALSE);
#line 544 "gcm-gl-desktop.c"
{
#line 245 "gcm-gl-desktop.gob"
	
		return selfp->compiz && gcm_application_get_pid(selfp->compiz) > 0;
	}}
#line 550 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_session_startup_active:
 * @self: #GCMGLDesktop
 *
 * Check if start GL Desktop on login is enable
 *
 * Returns: TRUE when is active
 **/
#line 257 "gcm-gl-desktop.gob"
gboolean 
gcm_gl_desktop_session_startup_active (GCMGLDesktop * self)
#line 564 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::session_startup_active"
#line 257 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
#line 257 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (gboolean )FALSE);
#line 571 "gcm-gl-desktop.c"
{
#line 259 "gcm-gl-desktop.gob"
	
		gchar * gnomerc = g_build_filename(g_get_home_dir(), ".gnomerc", NULL);
		gchar * buffer = NULL;
		gboolean result = FALSE;
		
		/* Check ~/.gnomerc file */
		if (g_file_test(gnomerc, G_FILE_TEST_EXISTS))
		{
			if (g_file_get_contents(gnomerc, &buffer, NULL, NULL) && buffer)
			{
				gchar ** lines = g_strsplit(buffer, "\n", -1);
				gint cpt;
				
				if (lines)
				{
					for (cpt = 0; lines[cpt]; cpt++)
					{
						g_strstrip(lines[cpt]);
						if (lines[cpt][0] != '#' && 
							g_strrstr(lines[cpt], "WINDOW_MANAGER=~/.gnome-compiz-manager/openbox"))
						{
							result = TRUE;
							break;
						}
					}
					g_strfreev(lines);
				}
			}
			if (buffer) g_free(buffer);
		}
		g_free(gnomerc);
							
		return result;
	}}
#line 608 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_activate_on_startup:
 * @self: #GCMGLDesktop
 *
 * Enable GL Desktop startup on login
 **/
#line 300 "gcm-gl-desktop.gob"
void 
gcm_gl_desktop_activate_on_startup (GCMGLDesktop * self)
#line 620 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::activate_on_startup"
#line 300 "gcm-gl-desktop.gob"
	g_return_if_fail (self != NULL);
#line 300 "gcm-gl-desktop.gob"
	g_return_if_fail (GCM_IS_GL_DESKTOP (self));
#line 627 "gcm-gl-desktop.c"
{
#line 302 "gcm-gl-desktop.gob"
	
		gchar * gnomerc;
		gchar * buffer = NULL, * tmp = NULL;
		
		if (self_session_startup_active(self))
			return;
		
		gnomerc = g_build_filename(g_get_home_dir(), ".gnomerc", NULL);
		
		if (!self_session_startup_active(self) &&
			g_file_test(gnomerc, G_FILE_TEST_EXISTS))
			g_file_get_contents(gnomerc, &tmp, NULL, NULL);
		
		buffer = g_strdup_printf("%s\nexport WINDOW_MANAGER=~/.gnome-compiz-manager/openbox\n", 
								 tmp ? tmp : " ");
		if (tmp) g_free(tmp);
		
		g_file_set_contents(gnomerc, buffer, -1, NULL);
		
		g_free(gnomerc);
		
		self_create_session_launcher(self);
	}}
#line 653 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_desactivate_on_startup:
 * @self: #GCMGLDesktop
 *
 * Disable GL Desktop startup on login
 **/
#line 332 "gcm-gl-desktop.gob"
void 
gcm_gl_desktop_desactivate_on_startup (GCMGLDesktop * self)
#line 665 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::desactivate_on_startup"
#line 332 "gcm-gl-desktop.gob"
	g_return_if_fail (self != NULL);
#line 332 "gcm-gl-desktop.gob"
	g_return_if_fail (GCM_IS_GL_DESKTOP (self));
#line 672 "gcm-gl-desktop.c"
{
#line 334 "gcm-gl-desktop.gob"
	
		
		if (self_session_startup_active(self))
		{
			gchar * gnomerc = g_build_filename(g_get_home_dir(), ".gnomerc", NULL);
			gchar * buffer = NULL;
			
			if (g_file_get_contents(gnomerc, &buffer, NULL, NULL) && buffer)
			{
				gchar ** lines = g_strsplit(buffer, "\n", -1);
				gint cpt;
				
				g_free(buffer);
				buffer = NULL;
				if (lines)
				{
					for (cpt = 0; lines[cpt]; cpt++)
					{
						g_strstrip(lines[cpt]);
						if (lines[cpt][0] != '#' && 
							!g_strrstr(lines[cpt], "WINDOW_MANAGER=~/.gnome-compiz-manager/openbox"))
						{
							gchar * tmp = buffer;
							buffer = g_strdup_printf("%s\n%s", tmp ? tmp : " ", lines[cpt]);
							g_free(tmp);
						}
					}
					g_strfreev(lines);
					if (buffer) 
					{
						g_file_set_contents(gnomerc, buffer, -1, NULL);
						g_free(buffer);
					}
				}
			}
			g_free(gnomerc);
		}
	}}
#line 713 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_register_and_enable_plugin:
 * @self: #GCMGLDesktop
 * @name: Name of GL Plugin
 *
 * Register and load #name GL Plugin
 *
 * Returns: TRUE when GL Plugin is active
 **/
#line 382 "gcm-gl-desktop.gob"
gboolean 
gcm_gl_desktop_register_and_enable_plugin (GCMGLDesktop * self, gchar * name)
#line 728 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::register_and_enable_plugin"
#line 382 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
#line 382 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (gboolean )FALSE);
#line 382 "gcm-gl-desktop.gob"
	g_return_val_if_fail (name != NULL, (gboolean )FALSE);
#line 737 "gcm-gl-desktop.c"
{
#line 384 "gcm-gl-desktop.gob"
	
		if (self_register_plugin(self, name))
			return self_enable_plugin(self, name);
		
		return FALSE;
	}}
#line 746 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_register_plugin:
 * @self: #GCMGLDesktop
 * @name: Name of GL Plugin
 *
 * Register #name GL Plugin
 *
 * Returns: TRUE when GL Plugin is registered
 **/
#line 400 "gcm-gl-desktop.gob"
gboolean 
gcm_gl_desktop_register_plugin (GCMGLDesktop * self, gchar * name)
#line 761 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::register_plugin"
#line 400 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
#line 400 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (gboolean )FALSE);
#line 400 "gcm-gl-desktop.gob"
	g_return_val_if_fail (name != NULL, (gboolean )FALSE);
#line 770 "gcm-gl-desktop.c"
{
#line 402 "gcm-gl-desktop.gob"
	
		if (!g_hash_table_lookup(selfp->gl_desktop_plugins, name))
		{
			GCMGLPlugin * plugin = gcm_gl_plugin_new(name);
		
			if (!plugin)
				return FALSE;
			
			g_hash_table_insert(selfp->gl_desktop_plugins, name, plugin);
		}
		
		return TRUE;
	}}
#line 786 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_enable_plugin:
 * @self: #GCMGLDesktop
 * @name: Name of GL Plugin
 *
 * Load #name GL Plugin
 *
 * Returns: TRUE when GL Plugin is loaded
 **/
#line 425 "gcm-gl-desktop.gob"
gboolean 
gcm_gl_desktop_enable_plugin (GCMGLDesktop * self, gchar * name)
#line 801 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::enable_plugin"
#line 425 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
#line 425 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (gboolean )FALSE);
#line 425 "gcm-gl-desktop.gob"
	g_return_val_if_fail (name != NULL, (gboolean )FALSE);
#line 810 "gcm-gl-desktop.c"
{
#line 427 "gcm-gl-desktop.gob"
	
		GSList * plugins = gcm_gl_option_get_string_list(selfp->active_plugins);
		GCMGLPlugin * plugin = g_hash_table_lookup(selfp->gl_desktop_plugins, name);
		
		if (!plugin)
			return FALSE;
		
		if (g_slist_find_custom(plugins, 
								name, 
								(GCompareFunc)g_ascii_strcasecmp) == NULL)
		{	
			GSList * item;
			
			for (item = plugin->requires; item; item = item->next)
			{
				if (!g_slist_find_custom(plugins, 
					 					 item->data, 
										 (GCompareFunc)g_ascii_strcasecmp))
					plugins = g_slist_insert_sorted_with_data(plugins, 
										g_strdup(item->data),
										(GCompareDataFunc) self_compare_plugin,
										self);
			}
			plugins = g_slist_insert_sorted_with_data(plugins, g_strdup(name),
										(GCompareDataFunc) self_compare_plugin,
										self);
			gcm_gl_option_set_string_list(selfp->active_plugins,
										  plugins);
			g_slist_foreach(plugins, (GFunc)g_free, NULL);
			g_slist_free(plugins);
			
			return TRUE;
		}
		
		return FALSE;
	}}
#line 849 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_disable_plugin:
 * @self: #GCMGLDesktop
 * @name: Name of GL Plugin
 *
 * Unload #name GL Plugin
 *
 * Returns: TRUE when GL Plugin is unloaded
 **/
#line 473 "gcm-gl-desktop.gob"
void 
gcm_gl_desktop_disable_plugin (GCMGLDesktop * self, gchar * name)
#line 864 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::disable_plugin"
#line 473 "gcm-gl-desktop.gob"
	g_return_if_fail (self != NULL);
#line 473 "gcm-gl-desktop.gob"
	g_return_if_fail (GCM_IS_GL_DESKTOP (self));
#line 473 "gcm-gl-desktop.gob"
	g_return_if_fail (name != NULL);
#line 873 "gcm-gl-desktop.c"
{
#line 475 "gcm-gl-desktop.gob"
	
		GSList * plugins = gcm_gl_option_get_string_list(selfp->active_plugins);
		GSList * item;
		
		if ((item = g_slist_find_custom(plugins, 
										name, 
										(GCompareFunc)g_ascii_strcasecmp)) != NULL)
		{
			plugins = g_slist_remove(plugins, item->data);
			gcm_gl_option_set_string_list(selfp->active_plugins,
										  plugins);
			g_slist_foreach(plugins, (GFunc)g_free, NULL);
			g_slist_free(plugins);
		}
	}}
#line 891 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_plugin_is_active:
 * @self: #GCMGLDesktop
 * @name: Name of GL Plugin
 *
 * Check if #name GL Plugin is loaded
 *
 * Returns: TRUE when GL Plugin is loaded
 **/
#line 500 "gcm-gl-desktop.gob"
gboolean 
gcm_gl_desktop_plugin_is_active (GCMGLDesktop * self, gchar * name)
#line 906 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::plugin_is_active"
#line 500 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
#line 500 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (gboolean )FALSE);
#line 500 "gcm-gl-desktop.gob"
	g_return_val_if_fail (name != NULL, (gboolean )FALSE);
#line 915 "gcm-gl-desktop.c"
{
#line 502 "gcm-gl-desktop.gob"
	
		GSList * plugins = gcm_gl_option_get_string_list(selfp->active_plugins);
		gboolean result = FALSE;
		
		if (g_slist_find_custom(plugins, 
								name, 
								(GCompareFunc)g_ascii_strcasecmp) != NULL)
			result = TRUE;
		
		g_slist_foreach(plugins, (GFunc)g_free, NULL);
		g_slist_free(plugins);
		
		return result;
	}}
#line 932 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_get_plugin:
 * @self: #GCMGLDesktop
 * @name: Name of GL Plugin
 *
 * Get a register #GCMGLPlugin
 *
 * Returns: #GCMGLPlugin
 **/
#line 526 "gcm-gl-desktop.gob"
GCMGLPlugin * 
gcm_gl_desktop_get_plugin (GCMGLDesktop * self, gchar * name)
#line 947 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::get_plugin"
#line 526 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (GCMGLPlugin * )NULL);
#line 526 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (GCMGLPlugin * )NULL);
#line 526 "gcm-gl-desktop.gob"
	g_return_val_if_fail (name != NULL, (GCMGLPlugin * )NULL);
#line 956 "gcm-gl-desktop.c"
{
#line 528 "gcm-gl-desktop.gob"
	
		return g_hash_table_lookup(selfp->gl_desktop_plugins, name);
	}}
#line 962 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_window_decorator_autostart:
 * @self: #GCMGLDesktop
 * @enable: if TRUE window decorator is started on login
 *
 * Enable or disable window decorator startup on login
 **/
#line 539 "gcm-gl-desktop.gob"
void 
gcm_gl_desktop_window_decorator_autostart (GCMGLDesktop * self, gboolean enable)
#line 975 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::window_decorator_autostart"
#line 539 "gcm-gl-desktop.gob"
	g_return_if_fail (self != NULL);
#line 539 "gcm-gl-desktop.gob"
	g_return_if_fail (GCM_IS_GL_DESKTOP (self));
#line 982 "gcm-gl-desktop.c"
{
#line 541 "gcm-gl-desktop.gob"
	
		gchar * autostart_path = g_build_filename(g_get_user_config_dir (),
												  "autostart", NULL);
		gchar * desktop_file = g_build_filename(autostart_path, 
												"window-decorator.desktop", NULL);
		
		g_mkdir_with_parents(autostart_path, S_IRWXU);
		
		if (!enable || selfp->version > 3000)
		{
			if (g_file_test(desktop_file, G_FILE_TEST_EXISTS))
				unlink(desktop_file);
		}
		else
		{
			GnomeDesktopItem * ditem = gnome_desktop_item_new();
			
			gnome_desktop_item_set_string(ditem, GNOME_DESKTOP_ITEM_EXEC, 
										  WINDOW_DECORATOR);
			gnome_desktop_item_save(ditem, desktop_file, TRUE, NULL);
			gnome_desktop_item_unref (ditem);
		}
		g_free(autostart_path);
		g_free(desktop_file);
	}}
#line 1010 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_get_option:
 * @self: #GCMGLDesktop
 * @name: name of option
 * @screen: #GCMGLOptionScreen
 *
 * Get an #GCMGLOption of GL Desktop
 *
 * Returns: #GCMGLOption
 **/
#line 578 "gcm-gl-desktop.gob"
GCMGLOption * 
gcm_gl_desktop_get_option (GCMGLDesktop * self, gchar * name, gint screen)
#line 1026 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::get_option"
#line 578 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (GCMGLOption * )0);
#line 578 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (GCMGLOption * )0);
#line 578 "gcm-gl-desktop.gob"
	g_return_val_if_fail (name != NULL, (GCMGLOption * )0);
#line 578 "gcm-gl-desktop.gob"
	g_return_val_if_fail (screen > -3, (GCMGLOption * )0);
#line 1037 "gcm-gl-desktop.c"
{
#line 580 "gcm-gl-desktop.gob"
	
		return gcm_gl_option_gconf_new(!g_ascii_strcasecmp(name, "action_double_click_titlebar") ? "metacity" : NULL, 
									   name, screen);
	}}
#line 1044 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_desktop_get_gl_manager:
 * @self: #GCMGLDesktop
 *
 * Get GL Manager name
 *
 * Returns: GL Manager name
 **/
#line 593 "gcm-gl-desktop.gob"
gchar * 
gcm_gl_desktop_get_gl_manager (GCMGLDesktop * self)
#line 1058 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::get_gl_manager"
#line 593 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (gchar * )NULL);
#line 593 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (gchar * )NULL);
#line 1065 "gcm-gl-desktop.c"
{
#line 595 "gcm-gl-desktop.gob"
	
		return selfp->compiz ? gcm_application_get_name(selfp->compiz) : NULL;
	}}
#line 1071 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

#line 599 "gcm-gl-desktop.gob"
static gint 
gcm_gl_desktop_compare_plugin (gchar * a, gchar * b, GCMGLDesktop * self)
#line 1077 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::compare_plugin"
#line 599 "gcm-gl-desktop.gob"
	g_return_val_if_fail (a != NULL, (gint )0);
#line 599 "gcm-gl-desktop.gob"
	g_return_val_if_fail (b != NULL, (gint )0);
#line 1084 "gcm-gl-desktop.c"
{
#line 601 "gcm-gl-desktop.gob"
	
		GCMGLPlugin * plugin_a = g_hash_table_lookup(selfp->gl_desktop_plugins, 
													 a);
		GCMGLPlugin * plugin_b = g_hash_table_lookup(selfp->gl_desktop_plugins, 
													 b);
		
		if (!plugin_a && !plugin_b) return 0;
		if (!plugin_a && plugin_b) return -1;
		if (plugin_a && !plugin_b) return 1;
		
		if (!g_ascii_strcasecmp(a, "gconf") && !g_ascii_strcasecmp(b, "gconf"))
			return 0;
		if (!g_ascii_strcasecmp(a, "gconf") && g_ascii_strcasecmp(b, "gconf"))
			return -1;
		if (g_ascii_strcasecmp(a, "gconf") && !g_ascii_strcasecmp(b, "gconf"))
			return 1;
		if (!g_ascii_strcasecmp(a, "png") && !g_ascii_strcasecmp(b, "png"))
			return 0;
		if (!g_ascii_strcasecmp(a, "png") && g_ascii_strcasecmp(b, "png"))
			return -1;
		if (g_ascii_strcasecmp(a, "png") && !g_ascii_strcasecmp(b, "png"))
			return 1;
		if (!g_ascii_strcasecmp(a, "svg") && !g_ascii_strcasecmp(b, "svg"))
			return 0;
		if (!g_ascii_strcasecmp(a, "svg") && g_ascii_strcasecmp(b, "svg"))
			return -1;
		if (g_ascii_strcasecmp(a, "svg") && !g_ascii_strcasecmp(b, "svg"))
			return 1;
		
		if (g_slist_find_custom(plugin_a->load_before,
								b,
								(GCompareFunc)g_ascii_strcasecmp))
			return -1;
		
		if (g_slist_find_custom(plugin_b->load_before,
								a,
								(GCompareFunc)g_ascii_strcasecmp))
			return 1;
		
		return 1;
	}}
#line 1128 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

#line 644 "gcm-gl-desktop.gob"
static gboolean 
gcm_gl_desktop_search_template (GCMGLDesktop * self)
#line 1134 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::search_template"
#line 644 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
#line 644 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (gboolean )FALSE);
#line 1141 "gcm-gl-desktop.c"
{
#line 646 "gcm-gl-desktop.gob"
	
		GDir * templatedir;
		gchar * item;
		gboolean result = FALSE;
		
		if ((templatedir = g_dir_open(GCM_XORG_TEMPLATE_DIR, 0, NULL)) == NULL)
			return result;
		
		while ((item = (gchar *)g_dir_read_name(templatedir)) != NULL)
		{
			if (g_pattern_match_simple("*.gcm", item))
			{
				gchar * itemdir = g_build_filename(GCM_XORG_TEMPLATE_DIR, item, NULL);
				GCMXorgTemplate * template = gcm_xorg_template_new(itemdir, 
																   !selfp->aiglx, 
																   selfp->aiglx);
				
				if (template)
				{
					gcm_xorg_template_parse(template);
					if (gcm_xorg_template_get_parsed(template))
					{
						selfp->templates = g_slist_append(selfp->templates, template);
						result = TRUE;
					}
					else
						g_object_unref(template);
				}
				g_free(itemdir);
			}
		}
		g_dir_close(templatedir);
		
		return result;
	}}
#line 1179 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

#line 682 "gcm-gl-desktop.gob"
static void 
gcm_gl_desktop_create_session_launcher (GCMGLDesktop * self)
#line 1185 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::create_session_launcher"
#line 682 "gcm-gl-desktop.gob"
	g_return_if_fail (self != NULL);
#line 682 "gcm-gl-desktop.gob"
	g_return_if_fail (GCM_IS_GL_DESKTOP (self));
#line 1192 "gcm-gl-desktop.c"
{
#line 684 "gcm-gl-desktop.gob"
	
		gchar * gcm_path = g_build_filename(g_get_home_dir(), ".gnome-compiz-manager", NULL);
		gchar * openbox = g_build_filename(gcm_path, "openbox", NULL);
		gchar * cmd;
		
		if (!g_file_test(gcm_path, G_FILE_TEST_EXISTS))
			mkdir(gcm_path,  S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH);
		g_free(gcm_path);
		
		if (selfp->aiglx)
		{
			if (selfp->version < 3006)
				cmd = g_strdup_printf("%s\ncompiz $@ --use-cow %s gconf",
							   self_check_nvidia_aiglx(self) ? 
							   "export __GL_YIELD=\"NOTHING\"" : " ", 
							   !self_check_nvidia_aiglx(self) ? 
							   "--strict-binding --indirect-rendering" : 
							   " ");
			else
				cmd = g_strdup_printf("%s\ncompiz $@ --indirect-rendering gconf",
							   self_check_nvidia_aiglx(self) ? 
							   "export __GL_YIELD=\"NOTHING\"" : " ");
		}
		else 
			cmd = g_strdup_printf("%s\ncompiz $@ gconf",
								  self_check_nvidia_aiglx(self) ? 
								  "export __GL_YIELD=\"NOTHING\"" : " ");
		g_file_set_contents(openbox, cmd, -1, NULL);
		g_free(cmd);
		chmod(openbox, 0700);
		g_free(openbox);
	}}
#line 1227 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

#line 717 "gcm-gl-desktop.gob"
static void 
gcm_gl_desktop_get_compiz_version (GCMGLDesktop * self)
#line 1233 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::get_compiz_version"
#line 717 "gcm-gl-desktop.gob"
	g_return_if_fail (self != NULL);
#line 717 "gcm-gl-desktop.gob"
	g_return_if_fail (GCM_IS_GL_DESKTOP (self));
#line 1240 "gcm-gl-desktop.c"
{
#line 719 "gcm-gl-desktop.gob"
	
		GList * argv = NULL;
		gchar * output;
		
		argv = g_list_append(NULL , g_strdup("--version"));
		gcm_application_set_argv(selfp->compiz, argv);
		if ((output = gcm_application_run(selfp->compiz)) != NULL)
		{
			if (g_pattern_match_simple("compiz ?.?.?\n", output))
			{
				gchar ** ver = g_strsplit(output + strlen("compiz "), ".", -1);
			
				selfp->version = atoi(ver[0]) * 1000000 + atoi(ver[1]) * 1000 + atoi(ver[2]);
				g_strfreev(ver);
			}
			g_free(output);
		}
	}}
#line 1261 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__

#line 738 "gcm-gl-desktop.gob"
static gboolean 
gcm_gl_desktop_check_nvidia_aiglx (GCMGLDesktop * self)
#line 1267 "gcm-gl-desktop.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Desktop::check_nvidia_aiglx"
#line 738 "gcm-gl-desktop.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 738 "gcm-gl-desktop.gob"
	g_return_val_if_fail (GCM_IS_GL_DESKTOP (self), (gboolean )0);
#line 1274 "gcm-gl-desktop.c"
{
#line 740 "gcm-gl-desktop.gob"
	
		XF86ConfDevicePtr devices, device;
		
		/* Check if in aiglx */
		if (gcm_xorg_is_xgl(selfp->xorg)) return FALSE;
		
		/* Get devices section */
		devices = gcm_xorg_config_get_devices(gcm_xorg_get_config(selfp->xorg));
		for (device = devices; device; device = (XF86ConfDevicePtr)((glp)device)->next)
		{
			/* check driver name */
			if (!g_ascii_strcasecmp(device->dev_driver, "nvidia"))
				return TRUE;
		}
		return FALSE;
	}}
#line 1293 "gcm-gl-desktop.c"
#undef __GOB_FUNCTION__
