/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
 
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <config.h>


#include "gcm-xorg-template.h"

int 
on_depth_choice(GCMXorgTemplate * template, gchar ** vals, gint def)
{
	gint cpt;
	gint result;
	
	for (cpt = 0; vals[cpt]; cpt++)
	{
		printf("%c %i -> %i depth\n", def == cpt ? '*': ' ', 
								cpt,  
								atoi(vals[cpt]));
	}
	
	printf("Choice : ? ");
	scanf("%i", &result);
	printf("%i", result);
	return atoi(vals[result]);
}

int
main (int argc, char *argv[])
{
 	GCMXorgTemplate * template;
	
	gtk_set_locale ();
	gtk_init (&argc, &argv);
	
	template = gcm_xorg_template_new(argv[1], FALSE, TRUE);
	//g_signal_connect(template, "depth_choice", G_CALLBACK(on_depth_choice), NULL);
	gcm_xorg_template_parse(template);
	if (gcm_xorg_template_get_parsed(template))
		printf("parsed\n");
	if (gcm_xorg_template_get_modified(template))
		printf("modified\n");
	gcm_xorg_config_write(gcm_xorg_template_get_config(template), "xorg.conf", NULL);
	
	return 0;
}
