# Note that this is NOT a relocatable package
%define name    gnome-cpufreq-applet
%define ver     0.3.1
%define RELEASE 1
%define rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix  /usr

Summary: GNOME CPU Frequency Scaling Monitor applet
Name: gnome-cpufreq-applet
Version: %ver
Release: %rel
Epoch: 1
Copyright: GPL
Group: Graphical desktop/GNOME
Source: http://carlosgc.linups.org/files/gnome-cpufreq-applet/%{name}/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
URL: http://carlosgc.linups.org/files/gnome-cpufreq-applet

Prereq:         scrollkeeper >= 0.1.4
Prereq:         GConf2
Prereq:         /usr/bin/gconftool-2
                                                                                
BuildRequires: pkgconfig
BuildRequires: intltool
BuildRequires: gnome-panel-devel
BuildRequires: libgnomeui-devel

Requires:       gnome-core >= 1.1.2
Requires:       gdk-pixbuf >= 0.7.0

%description

%prep
%setup -q

%build
if [ ! -f configure ]; then
CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=/usr --sysconfdir=/etc
else
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr --sysconfdir=/etc
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install
%find_lang %{name}

%clean
rm -rf %{buildroot}


%post   -p /sbin/ldconfig
%postun -p /sbin/ldconfig
%files -f %{name}.files
%defattr(-,root,root)
%{_prefix}/*
%{_sysconfdir}/gconf/schemas/cpufreq-applet.schemas
%doc AUTHORS COPYING ChangeLog NEWS README

