//  
//  Copyright (C) 2009 GNOME Do
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 

using System;
using System.Collections.Generic;
using System.Linq;

using Gdk;

using Do.Platform;
using Docky.Interface;

namespace VolumeDocklet
{
	
	
	public class VolumeDocklet : AbstractDockletItem
	{
		const string VolumeDown = "amixer set Master 3%- /dev/null";
		const string VolumeUp = "amixer set Master 3%+ /dev/null";
		
		public override string Name {
			get { return "Volume Control Docklet"; }
		}
	
		protected override string Icon {
			get { return "volume-max"; }
		}
		
		public override void Scrolled (Gdk.ScrollDirection direction)
		{
			switch (direction) {
			case ScrollDirection.Up:
				Services.Environment.Execute (VolumeUp);
				break;
			case ScrollDirection.Down:
				Services.Environment.Execute (VolumeDown);
				break;
			}
		}
	}
}
