/* CableScanner.c generated by valac, the Vala compiler
 * generated from CableScanner.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gee.h>
#include <gio/gio.h>
#include <dbus/dbus.h>


#define DVB_TYPE_ID_BUS_CABLE_SCANNER (dvb_id_bus_cable_scanner_get_type ())
#define DVB_ID_BUS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_CABLE_SCANNER, DVBIDBusCableScanner))
#define DVB_IS_ID_BUS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_CABLE_SCANNER))
#define DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_CABLE_SCANNER, DVBIDBusCableScannerIface))

typedef struct _DVBIDBusCableScanner DVBIDBusCableScanner;
typedef struct _DVBIDBusCableScannerIface DVBIDBusCableScannerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DVBIDBusCableScannerDBusProxy DVBIDBusCableScannerDBusProxy;
typedef DBusGProxyClass DVBIDBusCableScannerDBusProxyClass;

#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_CABLE_SCANNER (dvb_cable_scanner_get_type ())
#define DVB_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScanner))
#define DVB_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))
#define DVB_IS_CABLE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_SCANNER))
#define DVB_IS_CABLE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_SCANNER))
#define DVB_CABLE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_SCANNER, DVBCableScannerClass))

typedef struct _DVBCableScanner DVBCableScanner;
typedef struct _DVBCableScannerClass DVBCableScannerClass;
typedef struct _DVBCableScannerPrivate DVBCableScannerPrivate;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_CABLE_CHANNEL (dvb_cable_channel_get_type ())
#define DVB_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannel))
#define DVB_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))
#define DVB_IS_CABLE_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CABLE_CHANNEL))
#define DVB_IS_CABLE_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CABLE_CHANNEL))
#define DVB_CABLE_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CABLE_CHANNEL, DVBCableChannelClass))

typedef struct _DVBCableChannel DVBCableChannel;
typedef struct _DVBCableChannelClass DVBCableChannelClass;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DVBIDBusCableScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusCableScanner* self, GError** error);
	void (*Destroy) (DVBIDBusCableScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusCableScanner* self, const char* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusCableScanner* self, guint* channel_sids, int channel_sids_length1, const char* path, GError** error);
	void (*AddScanningData) (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusCableScanner* self, const char* path, GError** error);
};

struct _DVBIDBusCableScannerDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
	GeeHashMap* transport_streams;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
};

struct _DVBCableScanner {
	DVBScanner parent_instance;
	DVBCableScannerPrivate * priv;
};

struct _DVBCableScannerClass {
	DVBScannerClass parent_class;
};

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer dvb_cable_scanner_parent_class = NULL;
static DVBIDBusCableScannerIface* dvb_cable_scanner_dvb_id_bus_cable_scanner_parent_iface = NULL;

GType dvb_id_bus_cable_scanner_get_type (void);
void dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self, GError** error);
void dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self, GError** error);
gboolean dvb_id_bus_cable_scanner_WriteAllChannelsToFile (DVBIDBusCableScanner* self, const char* path, GError** error);
gboolean dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, guint* channel_sids, int channel_sids_length1, const char* path, GError** error);
void dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate, GError** error);
gboolean dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path, GError** error);
void dvb_id_bus_cable_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_id_bus_cable_scanner_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_id_bus_cable_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_introspect (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_property_get_all (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_WriteAllChannelsToFile (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_cable_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, DBusConnection* _connection);
static void _dbus_dvb_id_bus_cable_scanner_finished (GObject* _sender, DBusConnection* _connection);
static void _dbus_dvb_id_bus_cable_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, gboolean scrambled, DBusConnection* _connection);
GType dvb_id_bus_cable_scanner_dbus_proxy_get_type (void);
DVBIDBusCableScanner* dvb_id_bus_cable_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_dvb_id_bus_cable_scanner_frequency_scanned (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_cable_scanner_finished (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_dvb_id_bus_cable_scanner_channel_added (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_cable_scanner_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	DVB_ID_BUS_CABLE_SCANNER_DBUS_PROXY_DUMMY_PROPERTY
};
static void dvb_id_bus_cable_scanner_dbus_proxy_Run (DVBIDBusCableScanner* self, GError** error);
static void dvb_id_bus_cable_scanner_dbus_proxy_Destroy (DVBIDBusCableScanner* self, GError** error);
static gboolean dvb_id_bus_cable_scanner_dbus_proxy_WriteAllChannelsToFile (DVBIDBusCableScanner* self, const char* path, GError** error);
static gboolean dvb_id_bus_cable_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusCableScanner* self, guint* channel_sids, int channel_sids_length1, const char* path, GError** error);
static void dvb_id_bus_cable_scanner_dbus_proxy_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate, GError** error);
static gboolean dvb_id_bus_cable_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path, GError** error);
static void dvb_id_bus_cable_scanner_dbus_proxy_dvb_id_bus_cable_scanner__interface_init (DVBIDBusCableScannerIface* iface);
static void dvb_id_bus_cable_scanner_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_id_bus_cable_scanner_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dvb_scanner_get_type (void);
GType dvb_scanned_item_get_type (void);
GType dvb_channel_get_type (void);
GType dvb_channel_list_get_type (void);
GType dvb_cable_scanner_get_type (void);
enum  {
	DVB_CABLE_SCANNER_DUMMY_PROPERTY
};
GType dvb_device_get_type (void);
DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device);
DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device);
static inline void dvb_cable_scanner_add_scanning_data (DVBCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate);
static void dvb_cable_scanner_real_AddScanningData (DVBIDBusCableScanner* base, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate, GError** error);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
char* dvb_utils_read_file_contents (GFile* file, GError** error);
static gboolean dvb_cable_scanner_real_AddScanningDataFromFile (DVBIDBusCableScanner* base, const char* path, GError** error);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const char* key);
GType dvb_dvb_src_modulation_get_type (void);
DVBDvbSrcModulation dvb_get_modulation_val (const char* constellation);
GType dvb_dvb_src_code_rate_get_type (void);
DVBDvbSrcCodeRate dvb_get_code_rate_val (const char* code_rate_string);
static void dvb_cable_scanner_real_prepare (DVBScanner* base);
DVBScannedItem* dvb_scanned_item_new (guint frequency);
DVBScannedItem* dvb_scanned_item_construct (GType object_type, guint frequency);
static DVBScannedItem* dvb_cable_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
DVBCableChannel* dvb_cable_channel_new (void);
DVBCableChannel* dvb_cable_channel_construct (GType object_type);
GType dvb_cable_channel_get_type (void);
static DVBChannel* dvb_cable_scanner_real_get_new_channel (DVBScanner* base);
GType dvb_dvb_src_inversion_get_type (void);
void dvb_cable_channel_set_Inversion (DVBCableChannel* self, DVBDvbSrcInversion value);
void dvb_cable_channel_set_Modulation (DVBCableChannel* self, DVBDvbSrcModulation value);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
void dvb_cable_channel_set_SymbolRate (DVBCableChannel* self, guint value);
void dvb_cable_channel_set_CodeRate (DVBCableChannel* self, DVBDvbSrcCodeRate value);
static void dvb_cable_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
void dvb_cable_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_cable_scanner_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_cable_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_cable_scanner_introspect (DVBCableScanner* self, DBusConnection* connection, DBusMessage* message);
void dvb_scanner_Run (DVBScanner* self, GError** error);
void dvb_scanner_Destroy (DVBScanner* self, GError** error);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const char* path, GError** error);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const char* path, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_id_bus_cable_scanner_dbus_path_vtable = {_dvb_id_bus_cable_scanner_dbus_unregister, dvb_id_bus_cable_scanner_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_cable_scanner_dbus_vtable = {dvb_id_bus_cable_scanner_dbus_register_object};
static const DBusObjectPathVTable _dvb_cable_scanner_dbus_path_vtable = {_dvb_cable_scanner_dbus_unregister, dvb_cable_scanner_dbus_message};
static const _DBusObjectVTable _dvb_cable_scanner_dbus_vtable = {dvb_cable_scanner_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self, GError** error) {
	DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->Run (self, error);
}


void dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self, GError** error) {
	DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->Destroy (self, error);
}


gboolean dvb_id_bus_cable_scanner_WriteAllChannelsToFile (DVBIDBusCableScanner* self, const char* path, GError** error) {
	return DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->WriteAllChannelsToFile (self, path, error);
}


gboolean dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, guint* channel_sids, int channel_sids_length1, const char* path, GError** error) {
	return DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, channel_sids, channel_sids_length1, path, error);
}


void dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate, GError** error) {
	DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->AddScanningData (self, frequency, modulation, symbol_rate, code_rate, error);
}


gboolean dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path, GError** error) {
	return DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path, error);
}


void _dvb_id_bus_cable_scanner_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_introspect (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Cable\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteAllChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"channel_sids\" type=\"au\" direction=\"in\"/>\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"modulation\" type=\"s\" direction=\"in\"/>\n    <arg name=\"symbol_rate\" type=\"u\" direction=\"in\"/>\n    <arg name=\"code_rate\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"freq_left\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n    <arg name=\"scrambled\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_property_get_all (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.gnome.DVB.Scanner.Cable") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_cable_scanner_Run (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dvb_id_bus_cable_scanner_Destroy (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_WriteAllChannelsToFile (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* path = NULL;
	const char* _tmp1_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp2_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp1_);
	result = dvb_id_bus_cable_scanner_WriteAllChannelsToFile (self, path, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (path);
	_tmp2_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp2_);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint* channel_sids = NULL;
	int channel_sids_length1;
	guint* _tmp3_;
	int _tmp3__length;
	int _tmp3__size;
	int _tmp3__length1;
	DBusMessageIter _tmp4_;
	char* path = NULL;
	const char* _tmp6_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp7_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "aus")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	channel_sids_length1 = 0;
	_tmp3_ = g_new (guint, 5);
	_tmp3__length = 0;
	_tmp3__size = 4;
	_tmp3__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp4_);
	for (; dbus_message_iter_get_arg_type (&_tmp4_); _tmp3__length1++) {
		dbus_uint32_t _tmp5_;
		if (_tmp3__size == _tmp3__length) {
			_tmp3__size = 2 * _tmp3__size;
			_tmp3_ = g_renew (guint, _tmp3_, _tmp3__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp4_, &_tmp5_);
		dbus_message_iter_next (&_tmp4_);
		_tmp3_[_tmp3__length++] = _tmp5_;
	}
	channel_sids_length1 = _tmp3__length1;
	dbus_message_iter_next (&iter);
	channel_sids = _tmp3_;
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp6_);
	result = dvb_id_bus_cable_scanner_WriteChannelsToFile (self, channel_sids, channel_sids_length1, path, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	channel_sids = (g_free (channel_sids), NULL);
	_g_free0 (path);
	_tmp7_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp7_);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint frequency = 0U;
	dbus_uint32_t _tmp8_;
	char* modulation = NULL;
	const char* _tmp9_;
	guint symbol_rate = 0U;
	dbus_uint32_t _tmp10_;
	char* code_rate = NULL;
	const char* _tmp11_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "usus")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp8_);
	dbus_message_iter_next (&iter);
	frequency = _tmp8_;
	dbus_message_iter_get_basic (&iter, &_tmp9_);
	dbus_message_iter_next (&iter);
	modulation = g_strdup (_tmp9_);
	dbus_message_iter_get_basic (&iter, &_tmp10_);
	dbus_message_iter_next (&iter);
	symbol_rate = _tmp10_;
	dbus_message_iter_get_basic (&iter, &_tmp11_);
	dbus_message_iter_next (&iter);
	code_rate = g_strdup (_tmp11_);
	dvb_id_bus_cable_scanner_AddScanningData (self, frequency, modulation, symbol_rate, code_rate, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (modulation);
	_g_free0 (code_rate);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* path = NULL;
	const char* _tmp12_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp13_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp12_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp12_);
	result = dvb_id_bus_cable_scanner_AddScanningDataFromFile (self, path, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (path);
	_tmp13_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp13_);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_id_bus_cable_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_id_bus_cable_scanner_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_dvb_id_bus_cable_scanner_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "Run")) {
		result = _dbus_dvb_id_bus_cable_scanner_Run (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "Destroy")) {
		result = _dbus_dvb_id_bus_cable_scanner_Destroy (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "WriteAllChannelsToFile")) {
		result = _dbus_dvb_id_bus_cable_scanner_WriteAllChannelsToFile (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "WriteChannelsToFile")) {
		result = _dbus_dvb_id_bus_cable_scanner_WriteChannelsToFile (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "AddScanningData")) {
		result = _dbus_dvb_id_bus_cable_scanner_AddScanningData (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.Scanner.Cable", "AddScanningDataFromFile")) {
		result = _dbus_dvb_id_bus_cable_scanner_AddScanningDataFromFile (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_cable_scanner_frequency_scanned (GObject* _sender, guint frequency, guint freq_left, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp14_;
	dbus_uint32_t _tmp15_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Cable", "FrequencyScanned");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp14_ = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp14_);
	_tmp15_ = freq_left;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp15_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_cable_scanner_finished (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Cable", "Finished");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_dvb_id_bus_cable_scanner_channel_added (GObject* _sender, guint frequency, guint sid, const char* name, const char* network, const char* type, gboolean scrambled, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp16_;
	dbus_uint32_t _tmp17_;
	const char* _tmp18_;
	const char* _tmp19_;
	const char* _tmp20_;
	dbus_bool_t _tmp21_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.Scanner.Cable", "ChannelAdded");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp16_ = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp16_);
	_tmp17_ = sid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp17_);
	_tmp18_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp18_);
	_tmp19_ = network;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp19_);
	_tmp20_ = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp20_);
	_tmp21_ = scrambled;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp21_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_cable_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_cable_scanner_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "frequency-scanned", (GCallback) _dbus_dvb_id_bus_cable_scanner_frequency_scanned, connection);
	g_signal_connect (object, "finished", (GCallback) _dbus_dvb_id_bus_cable_scanner_finished, connection);
	g_signal_connect (object, "channel-added", (GCallback) _dbus_dvb_id_bus_cable_scanner_channel_added, connection);
}


static void dvb_id_bus_cable_scanner_base_init (DVBIDBusCableScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_CABLE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_CABLE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_CABLE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
		g_type_set_qdata (DVB_TYPE_ID_BUS_CABLE_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_cable_scanner_dbus_vtable));
	}
}


GType dvb_id_bus_cable_scanner_get_type (void) {
	static GType dvb_id_bus_cable_scanner_type_id = 0;
	if (dvb_id_bus_cable_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusCableScannerIface), (GBaseInitFunc) dvb_id_bus_cable_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_cable_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusCableScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_cable_scanner_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_cable_scanner_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &dvb_id_bus_cable_scanner_dbus_proxy_get_type);
	}
	return dvb_id_bus_cable_scanner_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusCableScannerDBusProxy, dvb_id_bus_cable_scanner_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_CABLE_SCANNER, dvb_id_bus_cable_scanner_dbus_proxy_dvb_id_bus_cable_scanner__interface_init) );
DVBIDBusCableScanner* dvb_id_bus_cable_scanner_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusCableScanner* self;
	self = g_object_new (dvb_id_bus_cable_scanner_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.Scanner.Cable", NULL);
	return self;
}


static GObject* dvb_id_bus_cable_scanner_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (dvb_id_bus_cable_scanner_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_cable_scanner_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_cable_scanner_frequency_scanned (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint frequency = 0U;
	dbus_uint32_t _tmp22_;
	guint freq_left = 0U;
	dbus_uint32_t _tmp23_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp22_);
	dbus_message_iter_next (&iter);
	frequency = _tmp22_;
	dbus_message_iter_get_basic (&iter, &_tmp23_);
	dbus_message_iter_next (&iter);
	freq_left = _tmp23_;
	g_signal_emit_by_name (self, "frequency-scanned", frequency, freq_left);
}


static void _dbus_handle_dvb_id_bus_cable_scanner_finished (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "finished");
}


static void _dbus_handle_dvb_id_bus_cable_scanner_channel_added (DVBIDBusCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint frequency = 0U;
	dbus_uint32_t _tmp24_;
	guint sid = 0U;
	dbus_uint32_t _tmp25_;
	char* name = NULL;
	const char* _tmp26_;
	char* network = NULL;
	const char* _tmp27_;
	char* type = NULL;
	const char* _tmp28_;
	gboolean scrambled = FALSE;
	dbus_bool_t _tmp29_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uusssb")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp24_);
	dbus_message_iter_next (&iter);
	frequency = _tmp24_;
	dbus_message_iter_get_basic (&iter, &_tmp25_);
	dbus_message_iter_next (&iter);
	sid = _tmp25_;
	dbus_message_iter_get_basic (&iter, &_tmp26_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp26_);
	dbus_message_iter_get_basic (&iter, &_tmp27_);
	dbus_message_iter_next (&iter);
	network = g_strdup (_tmp27_);
	dbus_message_iter_get_basic (&iter, &_tmp28_);
	dbus_message_iter_next (&iter);
	type = g_strdup (_tmp28_);
	dbus_message_iter_get_basic (&iter, &_tmp29_);
	dbus_message_iter_next (&iter);
	scrambled = _tmp29_;
	g_signal_emit_by_name (self, "channel-added", frequency, sid, name, network, type, scrambled);
	_g_free0 (name);
	_g_free0 (network);
	_g_free0 (type);
}


DBusHandlerResult dvb_id_bus_cable_scanner_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Cable", "FrequencyScanned")) {
			_dbus_handle_dvb_id_bus_cable_scanner_frequency_scanned (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Cable", "Finished")) {
			_dbus_handle_dvb_id_bus_cable_scanner_finished (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.gnome.DVB.Scanner.Cable", "ChannelAdded")) {
			_dbus_handle_dvb_id_bus_cable_scanner_channel_added (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_cable_scanner_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((DVBIDBusCableScannerDBusProxy*) self)->disposed) {
		return;
	}
	((DVBIDBusCableScannerDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_cable_scanner_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_cable_scanner_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_cable_scanner_dbus_proxy_class_init (DVBIDBusCableScannerDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = dvb_id_bus_cable_scanner_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_cable_scanner_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = dvb_id_bus_cable_scanner_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_id_bus_cable_scanner_dbus_proxy_set_property;
}


static void dvb_id_bus_cable_scanner_dbus_proxy_init (DVBIDBusCableScannerDBusProxy* self) {
}


static void dvb_id_bus_cable_scanner_dbus_proxy_Run (DVBIDBusCableScanner* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((DVBIDBusCableScannerDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "Run");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp30_;
			_edomain = DBUS_GERROR;
			_tmp30_ = _dbus_error.name + 27;
			if (strcmp (_tmp30_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp30_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp30_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp30_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp30_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp30_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp30_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp30_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp30_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp30_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp30_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp30_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp30_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp30_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp30_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp30_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp30_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp30_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp30_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp30_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp30_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp30_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp30_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp30_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp30_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp30_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp30_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp30_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp30_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp30_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp30_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp30_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp30_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void dvb_id_bus_cable_scanner_dbus_proxy_Destroy (DVBIDBusCableScanner* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((DVBIDBusCableScannerDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "Destroy");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp31_;
			_edomain = DBUS_GERROR;
			_tmp31_ = _dbus_error.name + 27;
			if (strcmp (_tmp31_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp31_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp31_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp31_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp31_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp31_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp31_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp31_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp31_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp31_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp31_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp31_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp31_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp31_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp31_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp31_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp31_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp31_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp31_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp31_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp31_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp31_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp31_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp31_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp31_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp31_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp31_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp31_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp31_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp31_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp31_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp31_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp31_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_cable_scanner_dbus_proxy_WriteAllChannelsToFile (DVBIDBusCableScanner* self, const char* path, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp32_;
	gboolean _result;
	dbus_bool_t _tmp33_;
	if (((DVBIDBusCableScannerDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "WriteAllChannelsToFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp32_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp32_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp34_;
			_edomain = DBUS_GERROR;
			_tmp34_ = _dbus_error.name + 27;
			if (strcmp (_tmp34_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp34_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp34_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp34_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp34_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp34_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp34_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp34_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp34_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp34_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp34_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp34_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp34_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp34_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp34_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp34_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp34_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp34_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp34_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp34_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp34_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp34_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp34_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp34_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp34_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp34_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp34_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp34_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp34_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp34_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp34_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp34_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp34_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "b")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "b", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp33_);
	dbus_message_iter_next (&_iter);
	_result = _tmp33_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_cable_scanner_dbus_proxy_WriteChannelsToFile (DVBIDBusCableScanner* self, guint* channel_sids, int channel_sids_length1, const char* path, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _tmp35_;
	DBusMessageIter _tmp36_;
	int _tmp37_;
	const char* _tmp39_;
	gboolean _result;
	dbus_bool_t _tmp40_;
	if (((DVBIDBusCableScannerDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "WriteChannelsToFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp35_ = channel_sids;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "u", &_tmp36_);
	for (_tmp37_ = 0; _tmp37_ < channel_sids_length1; _tmp37_++) {
		dbus_uint32_t _tmp38_;
		_tmp38_ = *_tmp35_;
		dbus_message_iter_append_basic (&_tmp36_, DBUS_TYPE_UINT32, &_tmp38_);
		_tmp35_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp36_);
	_tmp39_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp39_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp41_;
			_edomain = DBUS_GERROR;
			_tmp41_ = _dbus_error.name + 27;
			if (strcmp (_tmp41_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp41_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp41_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp41_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp41_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp41_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp41_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp41_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp41_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp41_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp41_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp41_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp41_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp41_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp41_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp41_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp41_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp41_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp41_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp41_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp41_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp41_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp41_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp41_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp41_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp41_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp41_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp41_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp41_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp41_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp41_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp41_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp41_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "b")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "b", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp40_);
	dbus_message_iter_next (&_iter);
	_result = _tmp40_;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_cable_scanner_dbus_proxy_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp42_;
	const char* _tmp43_;
	dbus_uint32_t _tmp44_;
	const char* _tmp45_;
	if (((DVBIDBusCableScannerDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "AddScanningData");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp42_ = frequency;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp42_);
	_tmp43_ = modulation;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp43_);
	_tmp44_ = symbol_rate;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp44_);
	_tmp45_ = code_rate;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp45_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp46_;
			_edomain = DBUS_GERROR;
			_tmp46_ = _dbus_error.name + 27;
			if (strcmp (_tmp46_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp46_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp46_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp46_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp46_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp46_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp46_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp46_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp46_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp46_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp46_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp46_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp46_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp46_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp46_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp46_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp46_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp46_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp46_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp46_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp46_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp46_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp46_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp46_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp46_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp46_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp46_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp46_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp46_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp46_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp46_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp46_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp46_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static gboolean dvb_id_bus_cable_scanner_dbus_proxy_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp47_;
	gboolean _result;
	dbus_bool_t _tmp48_;
	if (((DVBIDBusCableScannerDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.Scanner.Cable", "AddScanningDataFromFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp47_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp47_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp49_;
			_edomain = DBUS_GERROR;
			_tmp49_ = _dbus_error.name + 27;
			if (strcmp (_tmp49_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp49_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp49_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp49_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp49_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp49_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp49_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp49_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp49_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp49_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp49_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp49_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp49_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp49_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp49_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp49_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp49_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp49_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp49_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp49_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp49_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp49_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp49_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp49_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp49_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp49_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp49_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp49_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp49_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp49_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp49_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp49_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp49_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "b")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "b", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp48_);
	dbus_message_iter_next (&_iter);
	_result = _tmp48_;
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_cable_scanner_dbus_proxy_dvb_id_bus_cable_scanner__interface_init (DVBIDBusCableScannerIface* iface) {
	iface->Run = dvb_id_bus_cable_scanner_dbus_proxy_Run;
	iface->Destroy = dvb_id_bus_cable_scanner_dbus_proxy_Destroy;
	iface->WriteAllChannelsToFile = dvb_id_bus_cable_scanner_dbus_proxy_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = dvb_id_bus_cable_scanner_dbus_proxy_WriteChannelsToFile;
	iface->AddScanningData = dvb_id_bus_cable_scanner_dbus_proxy_AddScanningData;
	iface->AddScanningDataFromFile = dvb_id_bus_cable_scanner_dbus_proxy_AddScanningDataFromFile;
}


static void dvb_id_bus_cable_scanner_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void dvb_id_bus_cable_scanner_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device) {
	DVBCableScanner * self;
	g_return_val_if_fail (device != NULL, NULL);
	self = (DVBCableScanner*) g_object_new (object_type, "Device", device, NULL);
	return self;
}


DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device) {
	return dvb_cable_scanner_construct (DVB_TYPE_CABLE_SCANNER, device);
}


static void dvb_cable_scanner_real_AddScanningData (DVBIDBusCableScanner* base, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate, GError** error) {
	DVBCableScanner * self;
	self = (DVBCableScanner*) base;
	g_return_if_fail (modulation != NULL);
	g_return_if_fail (code_rate != NULL);
	dvb_cable_scanner_add_scanning_data (self, frequency, modulation, symbol_rate, code_rate);
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


static inline void dvb_cable_scanner_add_scanning_data (DVBCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate) {
	GstStructure* tuning_params;
	g_return_if_fail (self != NULL);
	g_return_if_fail (modulation != NULL);
	g_return_if_fail (code_rate != NULL);
	tuning_params = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "symbol-rate", G_TYPE_UINT, symbol_rate, "inner-fec", G_TYPE_STRING, code_rate, "modulation", G_TYPE_STRING, modulation, NULL);
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), _gst_structure_copy0 (tuning_params));
	_gst_structure_free0 (tuning_params);
}


static char* string_chug (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchug (_result_);
	result = _result_;
	return result;
}


static gboolean dvb_cable_scanner_real_AddScanningDataFromFile (DVBIDBusCableScanner* base, const char* path, GError** error) {
	DVBCableScanner * self;
	gboolean result;
	GError * _inner_error_;
	GFile* datafile;
	char* contents;
	self = (DVBCableScanner*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	_inner_error_ = NULL;
	datafile = g_file_new_for_path (path);
	g_debug ("CableScanner.vala:75: Reading scanning data from %s", path);
	contents = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = dvb_utils_read_file_contents (datafile, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		contents = (_tmp1_ = _tmp0_, _g_free0 (contents), _tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("CableScanner.vala:81: Could not read %s: %s", e->message, path);
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (datafile);
			_g_free0 (contents);
			return FALSE;
		} else {
			_g_object_unref0 (datafile);
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (contents == NULL) {
		result = FALSE;
		_g_object_unref0 (datafile);
		_g_free0 (contents);
		return result;
	}
	{
		char** _tmp2_;
		char** line_collection;
		int line_collection_length1;
		int line_it;
		line_collection = _tmp2_ = g_strsplit (contents, "\n", 0);
		line_collection_length1 = _vala_array_length (_tmp2_);
		for (line_it = 0; line_it < _vala_array_length (_tmp2_); line_it = line_it + 1) {
			char* line;
			line = g_strdup (line_collection[line_it]);
			{
				char* _tmp3_;
				char** _tmp5_;
				gint cols_size;
				gint cols_length1;
				char** _tmp4_;
				char** cols;
				gint cols_length;
				guint freq;
				char* modulation;
				guint symbol_rate;
				char* code_rate;
				line = (_tmp3_ = string_chug (line), _g_free0 (line), _tmp3_);
				if (g_str_has_prefix (line, "#")) {
					_g_free0 (line);
					continue;
				}
				cols = (_tmp5_ = _tmp4_ = g_regex_split_simple ("\\s+", line, 0, 0), cols_length1 = _vala_array_length (_tmp4_), cols_size = cols_length1, _tmp5_);
				cols_length = 0;
				while (TRUE) {
					if (!(cols[cols_length] != NULL)) {
						break;
					}
					cols_length++;
				}
				cols_length++;
				if (cols_length < 5) {
					_g_free0 (line);
					cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				freq = (guint) atoi (cols[1]);
				modulation = g_strdup (cols[4]);
				symbol_rate = (guint) (atoi (cols[2]) / 1000);
				code_rate = g_strdup (cols[3]);
				dvb_cable_scanner_add_scanning_data (self, freq, modulation, symbol_rate, code_rate);
				_g_free0 (line);
				cols = (_vala_array_free (cols, cols_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (modulation);
				_g_free0 (code_rate);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = TRUE;
	_g_object_unref0 (datafile);
	_g_free0 (contents);
	return result;
}


static void dvb_cable_scanner_real_prepare (DVBScanner* base) {
	DVBCableScanner * self;
	GstElement* dvbsrc;
	char** _tmp1_;
	gint keys_size;
	gint keys_length1;
	char** _tmp0_ = NULL;
	char** keys;
	self = (DVBCableScanner*) base;
	g_debug ("CableScanner.vala:113: Setting up pipeline for DVB-C scan");
	dvbsrc = gst_bin_get_by_name (GST_BIN (((DVBScanner*) self)->pipeline), "dvbsrc");
	keys = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("frequency"), _tmp0_[1] = g_strdup ("symbol-rate"), _tmp0_), keys_length1 = 2, keys_size = keys_length1, _tmp1_);
	{
		char** key_collection;
		int key_collection_length1;
		int key_it;
		key_collection = keys;
		key_collection_length1 = keys_length1;
		for (key_it = 0; key_it < keys_length1; key_it = key_it + 1) {
			char* key;
			key = g_strdup (key_collection[key_it]);
			{
				dvb_scanner_set_uint_property (dvbsrc, ((DVBScanner*) self)->current_tuning_params, key);
				_g_free0 (key);
			}
		}
	}
	g_object_set ((GObject*) dvbsrc, "modulation", dvb_get_modulation_val (gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "modulation")), NULL);
	g_object_set ((GObject*) dvbsrc, "code-rate-hp", dvb_get_code_rate_val (gst_structure_get_string (((DVBScanner*) self)->current_tuning_params, "inner-fec")), NULL);
	_gst_object_unref0 (dvbsrc);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
}


static DVBScannedItem* dvb_cable_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBCableScanner * self;
	DVBScannedItem* result;
	guint freq = 0U;
	self = (DVBCableScanner*) base;
	g_return_val_if_fail (structure != NULL, NULL);
	gst_structure_get_uint (structure, "frequency", &freq);
	result = dvb_scanned_item_new (freq);
	return result;
}


static DVBChannel* dvb_cable_scanner_real_get_new_channel (DVBScanner* base) {
	DVBCableScanner * self;
	DVBChannel* result;
	self = (DVBCableScanner*) base;
	result = (DVBChannel*) dvb_cable_channel_new ();
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_cable_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBCableScanner * self;
	DVBCableChannel* cc;
	guint freq = 0U;
	guint symbol_rate = 0U;
	self = (DVBCableScanner*) base;
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (channel != NULL);
	if (!DVB_IS_CABLE_CHANNEL (channel)) {
		return;
	}
	cc = _g_object_ref0 (DVB_CABLE_CHANNEL (channel));
	dvb_cable_channel_set_Inversion (cc, DVB_DVB_SRC_INVERSION_INVERSION_AUTO);
	dvb_cable_channel_set_Modulation (cc, dvb_get_modulation_val (gst_structure_get_string (delivery, "modulation")));
	gst_structure_get_uint (delivery, "frequency", &freq);
	dvb_channel_set_Frequency ((DVBChannel*) cc, freq);
	gst_structure_get_uint (delivery, "symbol-rate", &symbol_rate);
	dvb_cable_channel_set_SymbolRate (cc, symbol_rate);
	dvb_cable_channel_set_CodeRate (cc, dvb_get_code_rate_val (gst_structure_get_string (delivery, "inner-fec")));
	_g_object_unref0 (cc);
}


void _dvb_cable_scanner_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_cable_scanner_introspect (DVBCableScanner* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Scanner.Cable\">\n  <method name=\"Run\">\n  </method>\n  <method name=\"Destroy\">\n  </method>\n  <method name=\"WriteAllChannelsToFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"WriteChannelsToFile\">\n    <arg name=\"channel_sids\" type=\"au\" direction=\"in\"/>\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddScanningData\">\n    <arg name=\"frequency\" type=\"u\" direction=\"in\"/>\n    <arg name=\"modulation\" type=\"s\" direction=\"in\"/>\n    <arg name=\"symbol_rate\" type=\"u\" direction=\"in\"/>\n    <arg name=\"code_rate\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"AddScanningDataFromFile\">\n    <arg name=\"path\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"FrequencyScanned\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"freq_left\" type=\"u\"/>\n  </signal>\n  <signal name=\"Finished\">\n  </signal>\n  <signal name=\"ChannelAdded\">\n    <arg name=\"frequency\" type=\"u\"/>\n    <arg name=\"sid\" type=\"u\"/>\n    <arg name=\"name\" type=\"s\"/>\n    <arg name=\"network\" type=\"s\"/>\n    <arg name=\"type\" type=\"s\"/>\n    <arg name=\"scrambled\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_cable_scanner_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_cable_scanner_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dvb_id_bus_cable_scanner_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_cable_scanner_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_cable_scanner_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_cable_scanner_dbus_register_object (connection, path, object);
}


static void dvb_cable_scanner_class_init (DVBCableScannerClass * klass) {
	dvb_cable_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->prepare = dvb_cable_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_cable_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_cable_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_cable_scanner_real_add_values_from_structure_to_channel;
	g_type_set_qdata (DVB_TYPE_CABLE_SCANNER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_cable_scanner_dbus_vtable));
}


static void dvb_cable_scanner_dvb_id_bus_cable_scanner_interface_init (DVBIDBusCableScannerIface * iface) {
	dvb_cable_scanner_dvb_id_bus_cable_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = dvb_cable_scanner_real_AddScanningData;
	iface->AddScanningDataFromFile = dvb_cable_scanner_real_AddScanningDataFromFile;
	iface->Run = (void (*)(DVBIDBusCableScanner* ,GError**)) dvb_scanner_Run;
	iface->Destroy = (void (*)(DVBIDBusCableScanner* ,GError**)) dvb_scanner_Destroy;
	iface->WriteAllChannelsToFile = (gboolean (*)(DVBIDBusCableScanner* ,const char* ,GError**)) dvb_scanner_WriteAllChannelsToFile;
	iface->WriteChannelsToFile = (gboolean (*)(DVBIDBusCableScanner* ,guint* ,int ,const char* ,GError**)) dvb_scanner_WriteChannelsToFile;
}


static void dvb_cable_scanner_instance_init (DVBCableScanner * self) {
}


GType dvb_cable_scanner_get_type (void) {
	static GType dvb_cable_scanner_type_id = 0;
	if (dvb_cable_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBCableScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_cable_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBCableScanner), 0, (GInstanceInitFunc) dvb_cable_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_cable_scanner_info = { (GInterfaceInitFunc) dvb_cable_scanner_dvb_id_bus_cable_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_cable_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBCableScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_cable_scanner_type_id, DVB_TYPE_ID_BUS_CABLE_SCANNER, &dvb_id_bus_cable_scanner_info);
	}
	return dvb_cable_scanner_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}



