/* MpegTsEnums.c generated by valac, the Vala compiler
 * generated from MpegTsEnums.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;



GType dvb_dvb_src_code_rate_get_type (void);
GType dvb_dvb_src_modulation_get_type (void);
GType dvb_dvb_src_transmission_mode_get_type (void);
GType dvb_dvb_src_bandwidth_get_type (void);
GType dvb_dvb_src_guard_get_type (void);
GType dvb_dvb_src_hierarchy_get_type (void);
GType dvb_dvb_src_inversion_get_type (void);
DVBDvbSrcBandwidth dvb_get_bandwidth_val (guint bandwidth);
DVBDvbSrcHierarchy dvb_get_hierarchy_val (guint hierarchy);
DVBDvbSrcModulation dvb_get_modulation_val (const char* constellation);
DVBDvbSrcCodeRate dvb_get_code_rate_val (const char* code_rate_string);
DVBDvbSrcGuard dvb_get_guard_interval_val (guint guard);
DVBDvbSrcTransmissionMode dvb_get_transmission_mode_val (const char* transmode);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType dvb_dvb_src_code_rate_get_type (void) {
	static GType dvb_dvb_src_code_rate_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_code_rate_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_CODE_RATE_FEC_NONE, "DVB_DVB_SRC_CODE_RATE_FEC_NONE", "fec-none"}, {DVB_DVB_SRC_CODE_RATE_FEC_1_2, "DVB_DVB_SRC_CODE_RATE_FEC_1_2", "fec-1-2"}, {DVB_DVB_SRC_CODE_RATE_FEC_2_3, "DVB_DVB_SRC_CODE_RATE_FEC_2_3", "fec-2-3"}, {DVB_DVB_SRC_CODE_RATE_FEC_3_4, "DVB_DVB_SRC_CODE_RATE_FEC_3_4", "fec-3-4"}, {DVB_DVB_SRC_CODE_RATE_FEC_4_5, "DVB_DVB_SRC_CODE_RATE_FEC_4_5", "fec-4-5"}, {DVB_DVB_SRC_CODE_RATE_FEC_5_6, "DVB_DVB_SRC_CODE_RATE_FEC_5_6", "fec-5-6"}, {DVB_DVB_SRC_CODE_RATE_FEC_6_7, "DVB_DVB_SRC_CODE_RATE_FEC_6_7", "fec-6-7"}, {DVB_DVB_SRC_CODE_RATE_FEC_7_8, "DVB_DVB_SRC_CODE_RATE_FEC_7_8", "fec-7-8"}, {DVB_DVB_SRC_CODE_RATE_FEC_8_9, "DVB_DVB_SRC_CODE_RATE_FEC_8_9", "fec-8-9"}, {DVB_DVB_SRC_CODE_RATE_FEC_AUTO, "DVB_DVB_SRC_CODE_RATE_FEC_AUTO", "fec-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_code_rate_type_id = g_enum_register_static ("DVBDvbSrcCodeRate", values);
	}
	return dvb_dvb_src_code_rate_type_id;
}



GType dvb_dvb_src_modulation_get_type (void) {
	static GType dvb_dvb_src_modulation_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_modulation_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_MODULATION_QPSK, "DVB_DVB_SRC_MODULATION_QPSK", "qpsk"}, {DVB_DVB_SRC_MODULATION_QAM_16, "DVB_DVB_SRC_MODULATION_QAM_16", "qam-16"}, {DVB_DVB_SRC_MODULATION_QAM_32, "DVB_DVB_SRC_MODULATION_QAM_32", "qam-32"}, {DVB_DVB_SRC_MODULATION_QAM_64, "DVB_DVB_SRC_MODULATION_QAM_64", "qam-64"}, {DVB_DVB_SRC_MODULATION_QAM_128, "DVB_DVB_SRC_MODULATION_QAM_128", "qam-128"}, {DVB_DVB_SRC_MODULATION_QAM_256, "DVB_DVB_SRC_MODULATION_QAM_256", "qam-256"}, {DVB_DVB_SRC_MODULATION_QAM_AUTO, "DVB_DVB_SRC_MODULATION_QAM_AUTO", "qam-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_modulation_type_id = g_enum_register_static ("DVBDvbSrcModulation", values);
	}
	return dvb_dvb_src_modulation_type_id;
}



GType dvb_dvb_src_transmission_mode_get_type (void) {
	static GType dvb_dvb_src_transmission_mode_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_transmission_mode_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K, "DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K", "transmission-mode-2k"}, {DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K, "DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K", "transmission-mode-8k"}, {DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO, "DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO", "transmission-mode-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_transmission_mode_type_id = g_enum_register_static ("DVBDvbSrcTransmissionMode", values);
	}
	return dvb_dvb_src_transmission_mode_type_id;
}



GType dvb_dvb_src_bandwidth_get_type (void) {
	static GType dvb_dvb_src_bandwidth_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_bandwidth_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ", "bandwidth-8-mhz"}, {DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ", "bandwidth-7-mhz"}, {DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ", "bandwidth-6-mhz"}, {DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO, "DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO", "bandwidth-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_bandwidth_type_id = g_enum_register_static ("DVBDvbSrcBandwidth", values);
	}
	return dvb_dvb_src_bandwidth_type_id;
}



GType dvb_dvb_src_guard_get_type (void) {
	static GType dvb_dvb_src_guard_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_guard_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32", "guard-interval-1-32"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16", "guard-interval-1-16"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8", "guard-interval-1-8"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4", "guard-interval-1-4"}, {DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO, "DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO", "guard-interval-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_guard_type_id = g_enum_register_static ("DVBDvbSrcGuard", values);
	}
	return dvb_dvb_src_guard_type_id;
}



GType dvb_dvb_src_hierarchy_get_type (void) {
	static GType dvb_dvb_src_hierarchy_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_hierarchy_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE", "hierarchy-none"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_1, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_1", "hierarchy-1"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_2, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_2", "hierarchy-2"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_4, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_4", "hierarchy-4"}, {DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO, "DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO", "hierarchy-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_hierarchy_type_id = g_enum_register_static ("DVBDvbSrcHierarchy", values);
	}
	return dvb_dvb_src_hierarchy_type_id;
}



GType dvb_dvb_src_inversion_get_type (void) {
	static GType dvb_dvb_src_inversion_type_id = 0;
	if (G_UNLIKELY (dvb_dvb_src_inversion_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_DVB_SRC_INVERSION_INVERSION_OFF, "DVB_DVB_SRC_INVERSION_INVERSION_OFF", "inversion-off"}, {DVB_DVB_SRC_INVERSION_INVERSION_ON, "DVB_DVB_SRC_INVERSION_INVERSION_ON", "inversion-on"}, {DVB_DVB_SRC_INVERSION_INVERSION_AUTO, "DVB_DVB_SRC_INVERSION_INVERSION_AUTO", "inversion-auto"}, {0, NULL, NULL}};
		dvb_dvb_src_inversion_type_id = g_enum_register_static ("DVBDvbSrcInversion", values);
	}
	return dvb_dvb_src_inversion_type_id;
}


DVBDvbSrcBandwidth dvb_get_bandwidth_val (guint bandwidth) {
	DVBDvbSrcBandwidth result;
	DVBDvbSrcBandwidth val = 0;
	switch (bandwidth) {
		case 6:
		{
			val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ;
			break;
		}
		case 7:
		{
			val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ;
			break;
		}
		case 8:
		{
			val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ;
			break;
		}
		default:
		{
			val = DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO;
			break;
		}
	}
	result = val;
	return result;
}


DVBDvbSrcHierarchy dvb_get_hierarchy_val (guint hierarchy) {
	DVBDvbSrcHierarchy result;
	DVBDvbSrcHierarchy val = 0;
	switch (hierarchy) {
		case 0:
		{
			val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE;
			break;
		}
		case 1:
		{
			val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_1;
			break;
		}
		case 2:
		{
			val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_2;
			break;
		}
		case 4:
		{
			val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_4;
			break;
		}
		default:
		{
			val = DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO;
			break;
		}
	}
	result = val;
	return result;
}


DVBDvbSrcModulation dvb_get_modulation_val (const char* constellation) {
	DVBDvbSrcModulation result;
	DVBDvbSrcModulation val = 0;
	g_return_val_if_fail (constellation != NULL, 0);
	if (_vala_strcmp0 (constellation, "QPSK") == 0) {
		val = DVB_DVB_SRC_MODULATION_QPSK;
	} else {
		if (_vala_strcmp0 (constellation, "QAM16") == 0) {
			val = DVB_DVB_SRC_MODULATION_QAM_16;
		} else {
			if (_vala_strcmp0 (constellation, "QAM32") == 0) {
				val = DVB_DVB_SRC_MODULATION_QAM_32;
			} else {
				if (_vala_strcmp0 (constellation, "QAM64") == 0) {
					val = DVB_DVB_SRC_MODULATION_QAM_64;
				} else {
					if (_vala_strcmp0 (constellation, "QAM128") == 0) {
						val = DVB_DVB_SRC_MODULATION_QAM_128;
					} else {
						if (_vala_strcmp0 (constellation, "QAM256") == 0) {
							val = DVB_DVB_SRC_MODULATION_QAM_256;
						} else {
							val = DVB_DVB_SRC_MODULATION_QAM_AUTO;
						}
					}
				}
			}
		}
	}
	result = val;
	return result;
}


DVBDvbSrcCodeRate dvb_get_code_rate_val (const char* code_rate_string) {
	DVBDvbSrcCodeRate result;
	DVBDvbSrcCodeRate val = 0;
	g_return_val_if_fail (code_rate_string != NULL, 0);
	if (_vala_strcmp0 (code_rate_string, "NONE") == 0) {
		val = DVB_DVB_SRC_CODE_RATE_FEC_NONE;
	} else {
		if (_vala_strcmp0 (code_rate_string, "1/2") == 0) {
			val = DVB_DVB_SRC_CODE_RATE_FEC_1_2;
		} else {
			if (_vala_strcmp0 (code_rate_string, "2/3") == 0) {
				val = DVB_DVB_SRC_CODE_RATE_FEC_2_3;
			} else {
				if (_vala_strcmp0 (code_rate_string, "3/4") == 0) {
					val = DVB_DVB_SRC_CODE_RATE_FEC_3_4;
				} else {
					if (_vala_strcmp0 (code_rate_string, "4/5") == 0) {
						val = DVB_DVB_SRC_CODE_RATE_FEC_4_5;
					} else {
						if (_vala_strcmp0 (code_rate_string, "5/6") == 0) {
							val = DVB_DVB_SRC_CODE_RATE_FEC_5_6;
						} else {
							if (_vala_strcmp0 (code_rate_string, "6/7") == 0) {
								val = DVB_DVB_SRC_CODE_RATE_FEC_5_6;
							} else {
								if (_vala_strcmp0 (code_rate_string, "7/8") == 0) {
									val = DVB_DVB_SRC_CODE_RATE_FEC_7_8;
								} else {
									if (_vala_strcmp0 (code_rate_string, "8/9") == 0) {
										val = DVB_DVB_SRC_CODE_RATE_FEC_8_9;
									} else {
										val = DVB_DVB_SRC_CODE_RATE_FEC_AUTO;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = val;
	return result;
}


DVBDvbSrcGuard dvb_get_guard_interval_val (guint guard) {
	DVBDvbSrcGuard result;
	DVBDvbSrcGuard val = 0;
	switch (guard) {
		case 4:
		{
			val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4;
			break;
		}
		case 8:
		{
			val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8;
			break;
		}
		case 16:
		{
			val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16;
			break;
		}
		case 32:
		{
			val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32;
			break;
		}
		default:
		{
			val = DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO;
			break;
		}
	}
	result = val;
	return result;
}


DVBDvbSrcTransmissionMode dvb_get_transmission_mode_val (const char* transmode) {
	DVBDvbSrcTransmissionMode result;
	DVBDvbSrcTransmissionMode val = 0;
	g_return_val_if_fail (transmode != NULL, 0);
	if (_vala_strcmp0 (transmode, "2k") == 0) {
		val = DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K;
	} else {
		if (_vala_strcmp0 (transmode, "8k") == 0) {
			val = DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K;
		} else {
			val = DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO;
		}
	}
	result = val;
	return result;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




