/* Recording.c generated by valac, the Vala compiler
 * generated from Recording.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>
#include <stdio.h>


#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
typedef struct _DVBRecordingPrivate DVBRecordingPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DVBRecording {
	GObject parent_instance;
	DVBRecordingPrivate * priv;
};

struct _DVBRecordingClass {
	GObjectClass parent_class;
};

struct _DVBRecordingPrivate {
	guint32 _Id;
	guint _ChannelSid;
	char* _ChannelName;
	GFile* _Location;
	char* _Name;
	char* _Description;
	struct tm _StartTime;
	gint64 _Length;
	GFileMonitor* _file_monitor;
};


static gpointer dvb_recording_parent_class = NULL;

GType dvb_recording_get_type (void);
#define DVB_RECORDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_RECORDING, DVBRecordingPrivate))
enum  {
	DVB_RECORDING_DUMMY_PROPERTY,
	DVB_RECORDING_ID,
	DVB_RECORDING_CHANNEL_SID,
	DVB_RECORDING_CHANNEL_NAME,
	DVB_RECORDING_LOCATION,
	DVB_RECORDING_NAME,
	DVB_RECORDING_DESCRIPTION,
	DVB_RECORDING_LENGTH,
	DVB_RECORDING_FILE_MONITOR
};
void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result);
guint* dvb_recording_get_start (DVBRecording* self, int* result_length1);
GFile* dvb_recording_get_Location (DVBRecording* self);
char* dvb_recording_serialize (DVBRecording* self);
void dvb_recording_save_to_disk (DVBRecording* self, GError** error);
const char* dvb_recording_get_Name (DVBRecording* self);
const char* dvb_recording_get_Description (DVBRecording* self);
guint32 dvb_recording_get_Id (DVBRecording* self);
const char* dvb_recording_get_ChannelName (DVBRecording* self);
gint64 dvb_recording_get_Length (DVBRecording* self);
char* dvb_utils_read_file_contents (GFile* file, GError** error);
DVBRecording* dvb_recording_new (void);
DVBRecording* dvb_recording_construct (GType object_type);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
void dvb_recording_set_ChannelName (DVBRecording* self, const char* value);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
void dvb_recording_set_Name (DVBRecording* self, const char* value);
void dvb_recording_set_Description (DVBRecording* self, const char* value);
DVBRecording* dvb_recording_deserialize (GFile* file, GError** error);
guint dvb_recording_get_ChannelSid (DVBRecording* self);
void dvb_recording_set_ChannelSid (DVBRecording* self, guint value);
GFileMonitor* dvb_recording_get_file_monitor (DVBRecording* self);
void dvb_recording_set_file_monitor (DVBRecording* self, GFileMonitor* value);
static void dvb_recording_finalize (GObject* obj);
static void dvb_recording_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_recording_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



guint* dvb_recording_get_start (DVBRecording* self, int* result_length1) {
	guint* result;
	guint* _tmp0_ = NULL;
	guint* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = (_tmp0_ = g_new0 (guint, 5), _tmp0_[0] = (guint) (self->priv->_StartTime.tm_year + 1900), _tmp0_[1] = (guint) (self->priv->_StartTime.tm_mon + 1), _tmp0_[2] = (guint) self->priv->_StartTime.tm_mday, _tmp0_[3] = (guint) self->priv->_StartTime.tm_hour, _tmp0_[4] = (guint) self->priv->_StartTime.tm_min, _tmp0_), *result_length1 = 5, _tmp1_);
	return result;
}


void dvb_recording_save_to_disk (DVBRecording* self, GError** error) {
	GError * _inner_error_;
	GFile* parentdir;
	GFile* recfile;
	char* _tmp0_;
	GFileOutputStream* stream;
	char* text;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	parentdir = g_file_get_parent (self->priv->_Location);
	recfile = g_file_get_child (parentdir, "info.rec");
	g_debug ("Recording.vala:58: Saving recording to %s", _tmp0_ = g_file_get_path (recfile));
	_g_free0 (_tmp0_);
	if (g_file_query_exists (recfile, NULL)) {
		g_debug ("Recording.vala:61: Deleting old info.rec");
		g_file_delete (recfile, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parentdir);
			_g_object_unref0 (recfile);
			return;
		}
	}
	stream = g_file_create (recfile, 0, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (parentdir);
		_g_object_unref0 (recfile);
		return;
	}
	text = dvb_recording_serialize (self);
	g_output_stream_write ((GOutputStream*) stream, text, strlen (text), NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (parentdir);
		_g_object_unref0 (recfile);
		_g_object_unref0 (stream);
		_g_free0 (text);
		return;
	}
	g_output_stream_close ((GOutputStream*) stream, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (parentdir);
		_g_object_unref0 (recfile);
		_g_object_unref0 (stream);
		_g_free0 (text);
		return;
	}
	_g_object_unref0 (parentdir);
	_g_object_unref0 (recfile);
	_g_object_unref0 (stream);
	_g_free0 (text);
}


char* dvb_recording_serialize (DVBRecording* self) {
	char* result;
	guint* _tmp1_;
	gint started_size;
	gint started_length1;
	gint _tmp0_;
	guint* started;
	const char* _tmp2_;
	const char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	started = (_tmp1_ = dvb_recording_get_start (self, &_tmp0_), started_length1 = _tmp0_, started_size = started_length1, _tmp1_);
	_tmp2_ = NULL;
	if (self->priv->_Name == NULL) {
		_tmp2_ = "";
	} else {
		_tmp2_ = self->priv->_Name;
	}
	_tmp3_ = NULL;
	if (self->priv->_Description == NULL) {
		_tmp3_ = "";
	} else {
		_tmp3_ = self->priv->_Description;
	}
	result = (_tmp5_ = g_strdup_printf ("%u\n%s\n%s\n%u-%u-%u %u:%u\n%" G_GINT64_FORMAT "\n%s\n%s", self->priv->_Id, self->priv->_ChannelName, _tmp4_ = g_file_get_path (self->priv->_Location), started[0], started[1], started[2], started[3], started[4], self->priv->_Length, _tmp2_, _tmp3_), _g_free0 (_tmp4_), _tmp5_);
	started = (g_free (started), NULL);
	return result;
	started = (g_free (started), NULL);
}


DVBRecording* dvb_recording_deserialize (GFile* file, GError** error) {
	DVBRecording* result;
	GError * _inner_error_;
	char* contents;
	char** _tmp1_;
	gint fields_size;
	gint fields_length1;
	char** _tmp0_;
	char** fields;
	DVBRecording* rec;
	char* field;
	gint i;
	g_return_val_if_fail (file != NULL, NULL);
	_inner_error_ = NULL;
	contents = dvb_utils_read_file_contents (file, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (contents == NULL) {
		result = NULL;
		_g_free0 (contents);
		return result;
	}
	fields = (_tmp1_ = _tmp0_ = g_strsplit (contents, "\n", 7), fields_length1 = _vala_array_length (_tmp0_), fields_size = fields_length1, _tmp1_);
	rec = dvb_recording_new ();
	field = NULL;
	i = 0;
	while (TRUE) {
		char* _tmp2_;
		if (!((field = (_tmp2_ = g_strdup (fields[i]), _g_free0 (field), _tmp2_)) != NULL)) {
			break;
		}
		switch (i) {
			case 0:
			{
				dvb_recording_set_Id (rec, (guint32) atoi (field));
				break;
			}
			case 1:
			{
				dvb_recording_set_ChannelName (rec, field);
				break;
			}
			case 2:
			{
				if (_vala_strcmp0 (field, "") == 0) {
					dvb_recording_set_Location (rec, NULL);
				} else {
					GFile* _tmp3_;
					dvb_recording_set_Location (rec, _tmp3_ = g_file_new_for_path (field));
					_g_object_unref0 (_tmp3_);
				}
				break;
			}
			case 3:
			{
				{
					gint year;
					gint month;
					gint day;
					gint hour;
					gint minute;
					gboolean _tmp4_ = FALSE;
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_ = FALSE;
					gboolean _tmp7_ = FALSE;
					year = 0;
					month = 0;
					day = 0;
					hour = 0;
					minute = 0;
					sscanf (field, "%d-%d-%d %d:%d", &year, &month, &day, &hour, &minute);
					if (year >= 1900) {
						_tmp7_ = month >= 1;
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						_tmp6_ = day >= 1;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						_tmp5_ = hour >= 0;
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						_tmp4_ = minute >= 0;
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						struct tm _tmp8_ = {0};
						struct tm _tmp9_;
						dvb_recording_set_StartTime (rec, (_tmp9_ = (dvb_utils_create_time (year, month, day, hour, minute, 0, &_tmp8_), _tmp8_), &_tmp9_));
					}
					break;
				}
			}
			case 4:
			{
				dvb_recording_set_Length (rec, (gint64) atoi (field));
				break;
			}
			case 5:
			{
				const char* _tmp10_;
				_tmp10_ = NULL;
				if (_vala_strcmp0 (field, "") == 0) {
					_tmp10_ = NULL;
				} else {
					_tmp10_ = field;
				}
				dvb_recording_set_Name (rec, _tmp10_);
				break;
			}
			default:
			{
				dvb_recording_set_Description (rec, field);
				break;
			}
		}
		i++;
	}
	result = rec;
	_g_free0 (contents);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (field);
	return result;
}


DVBRecording* dvb_recording_construct (GType object_type) {
	DVBRecording * self;
	self = (DVBRecording*) g_object_new (object_type, NULL);
	return self;
}


DVBRecording* dvb_recording_new (void) {
	return dvb_recording_construct (DVB_TYPE_RECORDING);
}


guint32 dvb_recording_get_Id (DVBRecording* self) {
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Id;
	return result;
}


void dvb_recording_set_Id (DVBRecording* self, guint32 value) {
	g_return_if_fail (self != NULL);
	self->priv->_Id = value;
	g_object_notify ((GObject *) self, "Id");
}


guint dvb_recording_get_ChannelSid (DVBRecording* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_ChannelSid;
	return result;
}


void dvb_recording_set_ChannelSid (DVBRecording* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_ChannelSid = value;
	g_object_notify ((GObject *) self, "ChannelSid");
}


const char* dvb_recording_get_ChannelName (DVBRecording* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_ChannelName;
	return result;
}


void dvb_recording_set_ChannelName (DVBRecording* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_ChannelName = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_ChannelName), _tmp0_);
	g_object_notify ((GObject *) self, "ChannelName");
}


GFile* dvb_recording_get_Location (DVBRecording* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Location;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_recording_set_Location (DVBRecording* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Location = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_Location), _tmp0_);
	g_object_notify ((GObject *) self, "Location");
}


const char* dvb_recording_get_Name (DVBRecording* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Name;
	return result;
}


void dvb_recording_set_Name (DVBRecording* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_Name), _tmp0_);
	g_object_notify ((GObject *) self, "Name");
}


const char* dvb_recording_get_Description (DVBRecording* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Description;
	return result;
}


void dvb_recording_set_Description (DVBRecording* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Description = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_Description), _tmp0_);
	g_object_notify ((GObject *) self, "Description");
}


void dvb_recording_get_StartTime (DVBRecording* self, struct tm* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_StartTime;
	return;
}


void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value) {
	g_return_if_fail (self != NULL);
	self->priv->_StartTime = *value;
}


gint64 dvb_recording_get_Length (DVBRecording* self) {
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_Length;
	return result;
}


void dvb_recording_set_Length (DVBRecording* self, gint64 value) {
	g_return_if_fail (self != NULL);
	self->priv->_Length = value;
	g_object_notify ((GObject *) self, "Length");
}


GFileMonitor* dvb_recording_get_file_monitor (DVBRecording* self) {
	GFileMonitor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_file_monitor;
	return result;
}


void dvb_recording_set_file_monitor (DVBRecording* self, GFileMonitor* value) {
	GFileMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_file_monitor = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_file_monitor), _tmp0_);
	g_object_notify ((GObject *) self, "file-monitor");
}


static void dvb_recording_class_init (DVBRecordingClass * klass) {
	dvb_recording_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBRecordingPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_recording_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_recording_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_recording_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_ID, g_param_spec_uint ("Id", "Id", "Id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_CHANNEL_SID, g_param_spec_uint ("ChannelSid", "ChannelSid", "ChannelSid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_CHANNEL_NAME, g_param_spec_string ("ChannelName", "ChannelName", "ChannelName", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_LOCATION, g_param_spec_object ("Location", "Location", "Location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_DESCRIPTION, g_param_spec_string ("Description", "Description", "Description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_LENGTH, g_param_spec_int64 ("Length", "Length", "Length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_RECORDING_FILE_MONITOR, g_param_spec_object ("file-monitor", "file-monitor", "file-monitor", G_TYPE_FILE_MONITOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_recording_instance_init (DVBRecording * self) {
	self->priv = DVB_RECORDING_GET_PRIVATE (self);
}


static void dvb_recording_finalize (GObject* obj) {
	DVBRecording * self;
	self = DVB_RECORDING (obj);
	_g_free0 (self->priv->_ChannelName);
	_g_object_unref0 (self->priv->_Location);
	_g_free0 (self->priv->_Name);
	_g_free0 (self->priv->_Description);
	_g_object_unref0 (self->priv->_file_monitor);
	G_OBJECT_CLASS (dvb_recording_parent_class)->finalize (obj);
}


GType dvb_recording_get_type (void) {
	static GType dvb_recording_type_id = 0;
	if (dvb_recording_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBRecordingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_recording_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBRecording), 0, (GInstanceInitFunc) dvb_recording_instance_init, NULL };
		dvb_recording_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBRecording", &g_define_type_info, 0);
	}
	return dvb_recording_type_id;
}


static void dvb_recording_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBRecording * self;
	self = DVB_RECORDING (object);
	switch (property_id) {
		case DVB_RECORDING_ID:
		g_value_set_uint (value, dvb_recording_get_Id (self));
		break;
		case DVB_RECORDING_CHANNEL_SID:
		g_value_set_uint (value, dvb_recording_get_ChannelSid (self));
		break;
		case DVB_RECORDING_CHANNEL_NAME:
		g_value_set_string (value, dvb_recording_get_ChannelName (self));
		break;
		case DVB_RECORDING_LOCATION:
		g_value_set_object (value, dvb_recording_get_Location (self));
		break;
		case DVB_RECORDING_NAME:
		g_value_set_string (value, dvb_recording_get_Name (self));
		break;
		case DVB_RECORDING_DESCRIPTION:
		g_value_set_string (value, dvb_recording_get_Description (self));
		break;
		case DVB_RECORDING_LENGTH:
		g_value_set_int64 (value, dvb_recording_get_Length (self));
		break;
		case DVB_RECORDING_FILE_MONITOR:
		g_value_set_object (value, dvb_recording_get_file_monitor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_recording_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBRecording * self;
	self = DVB_RECORDING (object);
	switch (property_id) {
		case DVB_RECORDING_ID:
		dvb_recording_set_Id (self, g_value_get_uint (value));
		break;
		case DVB_RECORDING_CHANNEL_SID:
		dvb_recording_set_ChannelSid (self, g_value_get_uint (value));
		break;
		case DVB_RECORDING_CHANNEL_NAME:
		dvb_recording_set_ChannelName (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_LOCATION:
		dvb_recording_set_Location (self, g_value_get_object (value));
		break;
		case DVB_RECORDING_NAME:
		dvb_recording_set_Name (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_DESCRIPTION:
		dvb_recording_set_Description (self, g_value_get_string (value));
		break;
		case DVB_RECORDING_LENGTH:
		dvb_recording_set_Length (self, g_value_get_int64 (value));
		break;
		case DVB_RECORDING_FILE_MONITOR:
		dvb_recording_set_file_monitor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




