/* Scanner.c generated by valac, the Vala compiler
 * generated from Scanner.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cstuff.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>


#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_CHANNEL_LIST_WRITER (dvb_channel_list_writer_get_type ())
#define DVB_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST_WRITER, DVBChannelListWriter))
#define DVB_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST_WRITER, DVBChannelListWriterClass))
#define DVB_IS_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IS_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST_WRITER))
#define DVB_CHANNEL_LIST_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST_WRITER, DVBChannelListWriterClass))

typedef struct _DVBChannelListWriter DVBChannelListWriter;
typedef struct _DVBChannelListWriterClass DVBChannelListWriterClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
	GeeHashMap* transport_streams;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
};

struct _DVBScannerPrivate {
	DVBDevice* _Device;
	GeeArrayList* new_channels;
	GStaticRecMutex __lock_new_channels;
	GSource* check_for_lock_source;
	GSource* wait_for_tables_source;
	gboolean nit_arrived;
	gboolean sdt_arrived;
	gboolean pat_arrived;
	gboolean pmt_arrived;
	gboolean locked;
	GMainContext* context;
	GMainLoop* loop;
	GThread* worker_thread;
	gboolean running;
	guint bus_watch_id;
};


static gpointer dvb_scanner_parent_class = NULL;

GType dvb_scanner_get_type (void);
GType dvb_scanned_item_get_type (void);
GType dvb_channel_get_type (void);
GType dvb_channel_list_get_type (void);
GType dvb_device_get_type (void);
#define DVB_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNER, DVBScannerPrivate))
enum  {
	DVB_SCANNER_DUMMY_PROPERTY,
	DVB_SCANNER_DEVICE,
	DVB_SCANNER_CHANNELS
};
#define DVB_SCANNER_BASE_PIDS "16:17:18"
#define DVB_SCANNER_PIPELINE_TEMPLATE "dvbsrc name=dvbsrc adapter=%u frontend=%u pids=%s stats-reporting-inte" \
"rval=0 ! mpegtsparse ! fakesink silent=true"
void dvb_scanner_prepare (DVBScanner* self);
static void dvb_scanner_real_prepare (DVBScanner* self);
DVBScannedItem* dvb_scanner_get_scanned_item (DVBScanner* self, const GstStructure* structure);
static DVBScannedItem* dvb_scanner_real_get_scanned_item (DVBScanner* self, const GstStructure* structure);
DVBChannel* dvb_scanner_get_new_channel (DVBScanner* self);
static DVBChannel* dvb_scanner_real_get_new_channel (DVBScanner* self);
void dvb_scanner_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
static void dvb_scanner_real_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
static void* dvb_scanner_worker (DVBScanner* self);
static void* _dvb_scanner_worker_gthread_func (gpointer self);
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
DVBDevice* dvb_scanner_get_Device (DVBScanner* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
gboolean dvb_scanner_bus_watch_func (DVBScanner* self, GstBus* bus, GstMessage* message);
static gboolean _dvb_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
gboolean dvb_scanner_start_scan (DVBScanner* self);
static gboolean _dvb_scanner_start_scan_gsource_func (gpointer self);
void dvb_scanner_Run (DVBScanner* self, GError** error);
void dvb_scanner_do_destroy (DVBScanner* self);
void dvb_scanner_Destroy (DVBScanner* self, GError** error);
void dvb_scanner_remove_check_for_lock_timeout (DVBScanner* self);
void dvb_scanner_remove_wait_for_tables_timeout (DVBScanner* self);
void dvb_scanner_clear_and_reset_all (DVBScanner* self);
void dvb_channel_list_clear (DVBChannelList* self);
DVBChannelListWriter* dvb_channel_list_writer_new (GFile* file);
DVBChannelListWriter* dvb_channel_list_writer_construct (GType object_type, GFile* file);
GType dvb_channel_list_writer_get_type (void);
void dvb_channel_list_writer_write (DVBChannelListWriter* self, DVBChannel* channel, GError** error);
gboolean dvb_channel_list_writer_close (DVBChannelListWriter* self, GError** error);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const char* path, GError** error);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const char* path, GError** error);
void dvb_scanner_clear_frequencies (DVBScanner* self);
guint dvb_scanned_item_get_Frequency (DVBScannedItem* self);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
void dvb_channel_list_remove (DVBChannelList* self, guint sid);
gboolean dvb_scanner_check_for_lock (DVBScanner* self);
static gboolean _dvb_scanner_check_for_lock_gsource_func (gpointer self);
void dvb_scanner_queue_start_scan (DVBScanner* self);
gboolean dvb_scanner_wait_for_tables (DVBScanner* self);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const char* key);
static gboolean _dvb_scanner_wait_for_tables_gsource_func (gpointer self);
void dvb_scanner_on_dvb_frontend_stats_structure (DVBScanner* self, const GstStructure* structure);
void dvb_scanner_on_dvb_read_failure_structure (DVBScanner* self);
void dvb_scanner_on_pat_structure (DVBScanner* self, const GstStructure* structure);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
void dvb_scanner_add_new_channel (DVBScanner* self, guint sid);
void dvb_channel_set_Scrambled (DVBChannel* self, gboolean value);
void dvb_channel_set_Name (DVBChannel* self, const char* value);
void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value);
void dvb_channel_set_Network (DVBChannel* self, const char* value);
void dvb_scanner_on_sdt_structure (DVBScanner* self, const GstStructure* structure);
void dvb_channel_set_LogicalChannelNumber (DVBChannel* self, guint* value);
void dvb_scanner_on_nit_structure (DVBScanner* self, const GstStructure* structure);
void dvb_channel_set_VideoPID (DVBChannel* self, guint value);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
void dvb_scanner_on_pmt_structure (DVBScanner* self, const GstStructure* structure);
guint dvb_channel_get_TransportStreamId (DVBChannel* self);
gboolean dvb_channel_is_valid (DVBChannel* self);
gboolean dvb_channel_is_radio (DVBChannel* self);
char* dvb_channel_to_string (DVBChannel* self);
guint dvb_channel_get_Frequency (DVBChannel* self);
const char* dvb_channel_get_Name (DVBChannel* self);
const char* dvb_channel_get_Network (DVBChannel* self);
gboolean dvb_channel_get_Scrambled (DVBChannel* self);
void dvb_channel_set_Sid (DVBChannel* self, guint value);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
DVBScanner* dvb_scanner_construct (GType object_type);
static void dvb_scanner_set_Device (DVBScanner* self, DVBDevice* value);
DVBChannelList* dvb_scanner_get_Channels (DVBScanner* self);
guint dvb_scanned_item_hash (DVBScannedItem* o);
static guint _dvb_scanned_item_hash_ghash_func (void* key);
gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2);
static gboolean _dvb_scanned_item_equal_gequal_func (void* a, void* b);
static GObject * dvb_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_scanner_finalize (GObject* obj);
static void dvb_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static void dvb_scanner_real_prepare (DVBScanner* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_prepare'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_scanner_prepare (DVBScanner* self) {
	DVB_SCANNER_GET_CLASS (self)->prepare (self);
}


static DVBScannedItem* dvb_scanner_real_get_scanned_item (DVBScanner* self, const GstStructure* structure) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_get_scanned_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DVBScannedItem* dvb_scanner_get_scanned_item (DVBScanner* self, const GstStructure* structure) {
	return DVB_SCANNER_GET_CLASS (self)->get_scanned_item (self, structure);
}


static DVBChannel* dvb_scanner_real_get_new_channel (DVBScanner* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_get_new_channel'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DVBChannel* dvb_scanner_get_new_channel (DVBScanner* self) {
	return DVB_SCANNER_GET_CLASS (self)->get_new_channel (self);
}


static void dvb_scanner_real_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_add_values_from_structure_to_channel'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_scanner_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel) {
	DVB_SCANNER_GET_CLASS (self)->add_values_from_structure_to_channel (self, delivery, channel);
}


static void* _dvb_scanner_worker_gthread_func (gpointer self) {
	return dvb_scanner_worker (self);
}


static gboolean _dvb_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	return dvb_scanner_bus_watch_func (self, bus, message);
}


static gboolean _dvb_scanner_start_scan_gsource_func (gpointer self) {
	return dvb_scanner_start_scan (self);
}


void dvb_scanner_Run (DVBScanner* self, GError** error) {
	GError * _inner_error_;
	GMainLoop* _tmp0_;
	DVBChannelList* _tmp2_;
	GstBus* bus;
	GSource* source;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->priv->running) {
		return;
	}
	self->priv->running = TRUE;
	self->priv->loop = (_tmp0_ = g_main_loop_new (self->priv->context, FALSE), _g_main_loop_unref0 (self->priv->loop), _tmp0_);
	{
		GThread* _tmp1_;
		_tmp1_ = g_thread_create (_dvb_scanner_worker_gthread_func, self, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch47_g_error;
		}
		self->priv->worker_thread = _tmp1_;
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Scanner.vala:154: Could not create thread: %s", e->message);
			_g_error_free0 (e);
			return;
		}
	}
	__finally47:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->channels = (_tmp2_ = dvb_channel_list_new (NULL), _g_object_unref0 (self->channels), _tmp2_);
	{
		char* _tmp3_;
		GstElement* _tmp4_;
		GstElement* _tmp5_;
		GstElement* _tmp6_;
		_tmp5_ = (_tmp4_ = gst_parse_launch (_tmp3_ = g_strdup_printf (DVB_SCANNER_PIPELINE_TEMPLATE, dvb_device_get_Adapter (self->priv->_Device), dvb_device_get_Frontend (self->priv->_Device), DVB_SCANNER_BASE_PIDS), &_inner_error_), _g_free0 (_tmp3_), _tmp4_);
		if (_inner_error_ != NULL) {
			goto __catch48_g_error;
		}
		self->pipeline = (_tmp6_ = _tmp5_, _gst_object_unref0 (self->pipeline), _tmp6_);
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("Scanner.vala:165: Could not create pipeline: %s", e->message);
			_g_error_free0 (e);
			return;
		}
	}
	__finally48:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	bus = gst_element_get_bus (self->pipeline);
	self->priv->bus_watch_id = gst_bus_add_watch_context (bus, _dvb_scanner_bus_watch_func_gst_bus_func, self, self->priv->context);
	gst_element_set_state (self->pipeline, GST_STATE_READY);
	source = g_idle_source_new ();
	g_source_set_callback (source, _dvb_scanner_start_scan_gsource_func, g_object_ref (self), g_object_unref);
	g_source_attach (source, self->priv->context);
	_gst_object_unref0 (bus);
	_g_source_unref0 (source);
}


void dvb_scanner_Destroy (DVBScanner* self, GError** error) {
	g_return_if_fail (self != NULL);
	dvb_scanner_do_destroy (self);
}


void dvb_scanner_do_destroy (DVBScanner* self) {
	DVBChannelList* _tmp0_;
	g_return_if_fail (self != NULL);
	dvb_scanner_remove_check_for_lock_timeout (self);
	dvb_scanner_remove_wait_for_tables_timeout (self);
	dvb_scanner_clear_and_reset_all (self);
	dvb_channel_list_clear (self->channels);
	self->channels = (_tmp0_ = NULL, _g_object_unref0 (self->channels), _tmp0_);
	if (self->priv->loop != NULL) {
		GMainLoop* _tmp1_;
		g_main_loop_quit (self->priv->loop);
		self->priv->loop = (_tmp1_ = NULL, _g_main_loop_unref0 (self->priv->loop), _tmp1_);
		g_thread_join (self->priv->worker_thread);
		self->priv->worker_thread = NULL;
	}
	g_signal_emit_by_name (self, "destroyed");
}


gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const char* path, GError** error) {
	gboolean result;
	GError * _inner_error_;
	gboolean success;
	GFile* _tmp0_;
	DVBChannelListWriter* _tmp1_;
	DVBChannelListWriter* writer;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_inner_error_ = NULL;
	success = TRUE;
	writer = (_tmp1_ = dvb_channel_list_writer_new (_tmp0_ = g_file_new_for_path (path)), _g_object_unref0 (_tmp0_), _tmp1_);
	{
		GeeIterator* _c_it;
		_c_it = gee_iterable_iterator ((GeeIterable*) self->channels);
		while (TRUE) {
			DVBChannel* c;
			if (!gee_iterator_next (_c_it)) {
				break;
			}
			c = (DVBChannel*) gee_iterator_get (_c_it);
			{
				dvb_channel_list_writer_write (writer, c, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch49_g_error;
				}
			}
			goto __finally49;
			__catch49_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_critical ("Scanner.vala:215: Could not write to file: %s", e->message);
					success = FALSE;
					_g_error_free0 (e);
				}
			}
			__finally49:
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (c);
					_g_object_unref0 (_c_it);
					_g_object_unref0 (writer);
					return FALSE;
				} else {
					_g_object_unref0 (c);
					_g_object_unref0 (_c_it);
					_g_object_unref0 (writer);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_it);
	}
	{
		dvb_channel_list_writer_close (writer, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
		}
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Scanner.vala:223: Could not close file handle: %s", e->message);
			success = FALSE;
			_g_error_free0 (e);
		}
	}
	__finally50:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (writer);
			return FALSE;
		} else {
			_g_object_unref0 (writer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (writer);
	return result;
}


gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const char* path, GError** error) {
	gboolean result;
	GError * _inner_error_;
	gboolean success;
	GFile* _tmp0_;
	DVBChannelListWriter* _tmp1_;
	DVBChannelListWriter* writer;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_inner_error_ = NULL;
	success = TRUE;
	writer = (_tmp1_ = dvb_channel_list_writer_new (_tmp0_ = g_file_new_for_path (path)), _g_object_unref0 (_tmp0_), _tmp1_);
	{
		guint* sid_collection;
		int sid_collection_length1;
		int sid_it;
		sid_collection = channel_sids;
		sid_collection_length1 = channel_sids_length1;
		for (sid_it = 0; sid_it < channel_sids_length1; sid_it = sid_it + 1) {
			guint sid;
			sid = sid_collection[sid_it];
			{
				DVBChannel* c;
				c = dvb_channel_list_get_channel (self->channels, sid);
				if (c == NULL) {
					g_warning ("Scanner.vala:244: Channel with SID %u does not exist", sid);
					_g_object_unref0 (c);
					continue;
				}
				{
					dvb_channel_list_writer_write (writer, c, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch51_g_error;
					}
				}
				goto __finally51;
				__catch51_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					{
						g_critical ("Scanner.vala:250: Could not write to file: %s", e->message);
						success = FALSE;
						_g_error_free0 (e);
					}
				}
				__finally51:
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (c);
						_g_object_unref0 (writer);
						return FALSE;
					} else {
						_g_object_unref0 (c);
						_g_object_unref0 (writer);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				_g_object_unref0 (c);
			}
		}
	}
	{
		dvb_channel_list_writer_close (writer, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch52_g_error;
		}
	}
	goto __finally52;
	__catch52_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("Scanner.vala:258: Could not close file handle: %s", e->message);
			success = FALSE;
			_g_error_free0 (e);
		}
	}
	__finally52:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (writer);
			return FALSE;
		} else {
			_g_object_unref0 (writer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (writer);
	return result;
}


static void* dvb_scanner_worker (DVBScanner* self) {
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_main_loop_run (self->priv->loop);
	result = NULL;
	return result;
}


static gpointer _g_source_ref0 (gpointer self) {
	return self ? g_source_ref (self) : NULL;
}


void dvb_scanner_clear_and_reset_all (DVBScanner* self) {
	GstStructure* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->pipeline != NULL) {
		GSource* bus_watch_source;
		GstElement* _tmp0_;
		bus_watch_source = _g_source_ref0 (g_main_context_find_source_by_id (self->priv->context, self->priv->bus_watch_id));
		if (bus_watch_source != NULL) {
			g_source_destroy (bus_watch_source);
			self->priv->bus_watch_id = (guint) 0;
		}
		gst_element_set_state (self->pipeline, GST_STATE_NULL);
		self->pipeline = (_tmp0_ = NULL, _gst_object_unref0 (self->pipeline), _tmp0_);
		_g_source_unref0 (bus_watch_source);
	}
	gee_abstract_map_clear ((GeeAbstractMap*) self->transport_streams);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->scanned_frequencies);
	dvb_scanner_clear_frequencies (self);
	self->current_tuning_params = (_tmp1_ = NULL, _gst_structure_free0 (self->current_tuning_params), _tmp1_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->new_channels);
	self->priv->running = FALSE;
}


void dvb_scanner_clear_frequencies (DVBScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GstStructure* s;
		GstStructure* _tmp0_;
		if (!(!g_queue_is_empty (self->frequencies))) {
			break;
		}
		s = (GstStructure*) g_queue_pop_head (self->frequencies);
		s = (_tmp0_ = NULL, _gst_structure_free0 (s), _tmp0_);
		_gst_structure_free0 (s);
	}
	g_queue_clear (self->frequencies);
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure) {
	DVBScannedItem* item;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	if (structure == NULL) {
		_gst_structure_free0 (structure);
		return;
	}
	item = dvb_scanner_get_scanned_item (self, structure);
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) self->scanned_frequencies, item)) {
		g_debug ("Scanner.vala:308: Queueing new frequency %u", dvb_scanned_item_get_Frequency (item));
		g_queue_push_tail (self->frequencies, _gst_structure_copy0 (structure));
		gee_abstract_collection_add ((GeeAbstractCollection*) self->scanned_frequencies, item);
	}
	_g_object_unref0 (item);
	_gst_structure_free0 (structure);
}


static char* bool_to_string (gboolean self) {
	char* result;
	if (self) {
		result = g_strdup ("true");
		return result;
	} else {
		result = g_strdup ("false");
		return result;
	}
}


static gboolean _dvb_scanner_check_for_lock_gsource_func (gpointer self) {
	return dvb_scanner_check_for_lock (self);
}


gboolean dvb_scanner_start_scan (DVBScanner* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean all_tables;
	char* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	GstStructure* _tmp8_;
	guint freq = 0U;
	GstElement* dvbsrc;
	GSource* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->sdt_arrived) {
		_tmp2_ = self->priv->nit_arrived;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->pat_arrived;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->pmt_arrived;
	} else {
		_tmp0_ = FALSE;
	}
	all_tables = _tmp0_;
	g_debug ("Scanner.vala:321: Received all tables: %s (pat: %s, sdt: %s, nit: %s, " \
"pmt: %s)", _tmp3_ = bool_to_string (all_tables), _tmp4_ = bool_to_string (self->priv->pat_arrived), _tmp5_ = bool_to_string (self->priv->sdt_arrived), _tmp6_ = bool_to_string (self->priv->nit_arrived), _tmp7_ = bool_to_string (self->priv->pmt_arrived));
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	self->priv->nit_arrived = FALSE;
	self->priv->sdt_arrived = FALSE;
	self->priv->pat_arrived = FALSE;
	self->priv->pmt_arrived = FALSE;
	self->priv->locked = FALSE;
	if (self->current_tuning_params != NULL) {
		guint old_freq = 0U;
		gst_structure_get_uint (self->current_tuning_params, "frequency", &old_freq);
		g_signal_emit_by_name (self, "frequency-scanned", old_freq, self->frequencies->length);
	}
	if (g_queue_is_empty (self->frequencies)) {
		g_message ("Scanner.vala:339: Finished scanning");
		g_static_rec_mutex_lock (&self->priv->__lock_new_channels);
		{
			g_debug ("Scanner.vala:343: %u channels still have missing or invalid informatio" \
"n", (guint) gee_collection_get_size ((GeeCollection*) self->priv->new_channels));
			{
				GeeIterator* _sid_it;
				_sid_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->new_channels);
				while (TRUE) {
					guint sid;
					if (!gee_iterator_next (_sid_it)) {
						break;
					}
					sid = GPOINTER_TO_UINT (gee_iterator_get (_sid_it));
					dvb_channel_list_remove (self->channels, sid);
				}
				_g_object_unref0 (_sid_it);
			}
		}
		g_static_rec_mutex_unlock (&self->priv->__lock_new_channels);
		dvb_scanner_clear_and_reset_all (self);
		g_signal_emit_by_name (self, "finished");
		result = FALSE;
		return result;
	}
	self->current_tuning_params = (_tmp8_ = (GstStructure*) g_queue_pop_head (self->frequencies), _gst_structure_free0 (self->current_tuning_params), _tmp8_);
	gst_structure_get_uint (self->current_tuning_params, "frequency", &freq);
	g_debug ("Scanner.vala:360: Starting scanning frequency %u (%u left)", freq, g_queue_get_length (self->frequencies));
	gst_element_set_state (self->pipeline, GST_STATE_READY);
	dvb_scanner_prepare (self);
	dvbsrc = gst_bin_get_by_name (GST_BIN (self->pipeline), "dvbsrc");
	g_object_set ((GObject*) dvbsrc, "pids", DVB_SCANNER_BASE_PIDS, NULL);
	self->priv->check_for_lock_source = (_tmp9_ = g_timeout_source_new_seconds ((guint) 5), _g_source_unref0 (self->priv->check_for_lock_source), _tmp9_);
	g_source_set_callback (self->priv->check_for_lock_source, _dvb_scanner_check_for_lock_gsource_func, g_object_ref (self), g_object_unref);
	g_source_attach (self->priv->check_for_lock_source, self->priv->context);
	gst_element_set_state (self->pipeline, GST_STATE_PLAYING);
	result = FALSE;
	_gst_object_unref0 (dvbsrc);
	return result;
}


gboolean dvb_scanner_check_for_lock (DVBScanner* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->locked) {
		gst_element_set_state (self->pipeline, GST_STATE_READY);
		dvb_scanner_queue_start_scan (self);
	}
	result = FALSE;
	return result;
}


gboolean dvb_scanner_wait_for_tables (DVBScanner* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->sdt_arrived) {
		_tmp2_ = self->priv->nit_arrived;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->pat_arrived;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->pmt_arrived;
	} else {
		_tmp0_ = FALSE;
	}
	if (!_tmp0_) {
		gst_element_set_state (self->pipeline, GST_STATE_READY);
		dvb_scanner_queue_start_scan (self);
	}
	result = FALSE;
	return result;
}


void dvb_scanner_remove_check_for_lock_timeout (DVBScanner* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->check_for_lock_source != NULL) {
		GSource* _tmp0_;
		g_source_destroy (self->priv->check_for_lock_source);
		self->priv->check_for_lock_source = (_tmp0_ = NULL, _g_source_unref0 (self->priv->check_for_lock_source), _tmp0_);
	}
}


void dvb_scanner_remove_wait_for_tables_timeout (DVBScanner* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->wait_for_tables_source != NULL) {
		GSource* _tmp0_;
		g_source_destroy (self->priv->wait_for_tables_source);
		self->priv->wait_for_tables_source = (_tmp0_ = NULL, _g_source_unref0 (self->priv->wait_for_tables_source), _tmp0_);
	}
}


void dvb_scanner_queue_start_scan (DVBScanner* self) {
	GSource* source;
	g_return_if_fail (self != NULL);
	source = g_idle_source_new ();
	g_source_set_callback (source, _dvb_scanner_start_scan_gsource_func, g_object_ref (self), g_object_unref);
	g_source_attach (source, self->priv->context);
	_g_source_unref0 (source);
}


void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const char* key) {
	guint val = 0U;
	g_return_if_fail (src != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (key != NULL);
	gst_structure_get_uint (params, key, &val);
	g_object_set ((GObject*) src, key, val, NULL);
}


static gboolean _dvb_scanner_wait_for_tables_gsource_func (gpointer self) {
	return dvb_scanner_wait_for_tables (self);
}


void dvb_scanner_on_dvb_frontend_stats_structure (DVBScanner* self, const GstStructure* structure) {
	gboolean has_lock = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	gst_structure_get_boolean (structure, "lock", &has_lock);
	if (has_lock) {
		_tmp0_ = !self->priv->locked;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSource* _tmp1_;
		g_debug ("Scanner.vala:433: Got lock");
		dvb_scanner_remove_check_for_lock_timeout (self);
		self->priv->wait_for_tables_source = (_tmp1_ = g_timeout_source_new_seconds ((guint) 10), _g_source_unref0 (self->priv->wait_for_tables_source), _tmp1_);
		g_source_set_callback (self->priv->wait_for_tables_source, _dvb_scanner_wait_for_tables_gsource_func, g_object_ref (self), g_object_unref);
		g_source_attach (self->priv->wait_for_tables_source, self->priv->context);
	}
}


void dvb_scanner_on_dvb_read_failure_structure (DVBScanner* self) {
	g_return_if_fail (self != NULL);
	g_warning ("Scanner.vala:443: Read failure");
}


void dvb_scanner_on_pat_structure (DVBScanner* self, const GstStructure* structure) {
	GeeSet* pid_set;
	GValue programs;
	guint size;
	GValue val = {0};
	const GstStructure* program;
	GString* new_pids;
	gint i;
	GstElement* dvbsrc;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	g_debug ("Scanner.vala:450: Received PAT");
	pid_set = (GeeSet*) gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
	gee_collection_add ((GeeCollection*) pid_set, GUINT_TO_POINTER ((guint) 16));
	gee_collection_add ((GeeCollection*) pid_set, GUINT_TO_POINTER ((guint) 17));
	gee_collection_add ((GeeCollection*) pid_set, GUINT_TO_POINTER ((guint) 18));
	programs = *gst_structure_get_value (structure, "programs");
	size = gst_value_list_get_size (&programs);
	program = NULL;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint sid = 0U;
				guint pmt = 0U;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < size)) {
					break;
				}
				val = *gst_value_list_get_value (&programs, i);
				program = gst_value_get_structure (&val);
				gst_structure_get_uint (program, "program-number", &sid);
				gst_structure_get_uint (program, "pid", &pmt);
				gee_collection_add ((GeeCollection*) pid_set, GUINT_TO_POINTER (pmt));
			}
		}
	}
	new_pids = g_string_new ("");
	i = 0;
	{
		GeeIterator* _pid_it;
		_pid_it = gee_iterable_iterator ((GeeIterable*) pid_set);
		while (TRUE) {
			guint pid;
			if (!gee_iterator_next (_pid_it)) {
				break;
			}
			pid = GPOINTER_TO_UINT (gee_iterator_get (_pid_it));
			if ((i + 1) == gee_collection_get_size ((GeeCollection*) pid_set)) {
				char* _tmp1_;
				g_string_append (new_pids, _tmp1_ = g_strdup_printf ("%u", pid));
				_g_free0 (_tmp1_);
			} else {
				char* _tmp2_;
				g_string_append (new_pids, _tmp2_ = g_strdup_printf ("%u:", pid));
				_g_free0 (_tmp2_);
			}
			i++;
		}
		_g_object_unref0 (_pid_it);
	}
	g_debug ("Scanner.vala:486: Setting %d pids: %s", gee_collection_get_size ((GeeCollection*) pid_set), new_pids->str);
	dvbsrc = gst_bin_get_by_name (GST_BIN (self->pipeline), "dvbsrc");
	g_object_set ((GObject*) dvbsrc, "pids", new_pids->str, NULL);
	self->priv->pat_arrived = TRUE;
	_g_object_unref0 (pid_set);
	_g_string_free0 (new_pids);
	_gst_object_unref0 (dvbsrc);
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch53_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch53_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally53;
	__catch53_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally53:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void dvb_scanner_on_sdt_structure (DVBScanner* self, const GstStructure* structure) {
	guint tsid = 0U;
	GValue services;
	guint size;
	GValue val = {0};
	const GstStructure* service;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	g_debug ("Scanner.vala:495: Received SDT");
	gst_structure_get_uint (structure, "transport-stream-id", &tsid);
	services = *gst_structure_get_value (structure, "services");
	size = gst_value_list_get_size (&services);
	service = NULL;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				char* name;
				char* _tmp1_;
				gint _tmp2_;
				gint sid;
				DVBChannel* channel;
				char* provider;
				gboolean _tmp5_ = FALSE;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < size)) {
					break;
				}
				val = *gst_value_list_get_value (&services, i);
				service = gst_value_get_structure (&val);
				name = g_strdup (gst_structure_get_name (service));
				sid = (_tmp2_ = atoi (_tmp1_ = string_substring (name, (glong) 8, g_utf8_strlen (name, -1) - 8)), _g_free0 (_tmp1_), _tmp2_);
				if (gst_structure_has_field (service, "name")) {
					char* _tmp3_;
					name = (_tmp3_ = g_strdup (gst_structure_get_string (service, "name")), _g_free0 (name), _tmp3_);
				}
				if (!dvb_channel_list_contains (self->channels, (guint) sid)) {
					dvb_scanner_add_new_channel (self, (guint) sid);
				}
				channel = dvb_channel_list_get_channel (self->channels, (guint) sid);
				if (gst_structure_has_field (service, "scrambled")) {
					gboolean scrambled = FALSE;
					gst_structure_get_boolean (service, "scrambled", &scrambled);
					dvb_channel_set_Scrambled (channel, scrambled);
				} else {
					dvb_channel_set_Scrambled (channel, FALSE);
				}
				if (g_utf8_validate (name, -1, NULL)) {
					char* _tmp4_;
					dvb_channel_set_Name (channel, _tmp4_ = string_replace (name, "\\s", " "));
					_g_free0 (_tmp4_);
				}
				dvb_channel_set_TransportStreamId (channel, tsid);
				provider = g_strdup (gst_structure_get_string (service, "provider-name"));
				if (provider != NULL) {
					_tmp5_ = g_utf8_validate (provider, -1, NULL);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					dvb_channel_set_Network (channel, provider);
				} else {
					dvb_channel_set_Network (channel, "");
				}
				_g_free0 (name);
				_g_object_unref0 (channel);
				_g_free0 (provider);
			}
		}
	}
	self->priv->sdt_arrived = TRUE;
}


void dvb_scanner_on_nit_structure (DVBScanner* self, const GstStructure* structure) {
	char* name;
	GValue transports;
	guint size;
	GValue val = {0};
	const GstStructure* transport;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	g_debug ("Scanner.vala:549: Received NIT");
	name = NULL;
	if (gst_structure_has_field (structure, "network-name")) {
		char* _tmp0_;
		name = (_tmp0_ = g_strdup (gst_structure_get_string (structure, "network-name")), _g_free0 (name), _tmp0_);
	} else {
		guint nid = 0U;
		char* _tmp1_;
		gst_structure_get_uint (structure, "network-id", &nid);
		name = (_tmp1_ = g_strdup_printf ("%u", nid), _g_free0 (name), _tmp1_);
	}
	g_debug ("Scanner.vala:559: Network name '%s'", name);
	transports = *gst_structure_get_value (structure, "transports");
	size = gst_value_list_get_size (&transports);
	transport = NULL;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				guint tsid = 0U;
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < size)) {
					break;
				}
				val = *gst_value_list_get_value (&transports, i);
				transport = gst_value_get_structure (&val);
				gst_structure_get_uint (transport, "transport-stream-id", &tsid);
				if (gst_structure_has_field (transport, "delivery")) {
					GValue delivery_val;
					const GstStructure* delivery;
					guint freq = 0U;
					delivery_val = *gst_structure_get_value (transport, "delivery");
					delivery = gst_value_get_structure (&delivery_val);
					g_debug ("Scanner.vala:578: Received TS %u", tsid);
					gee_abstract_map_set ((GeeAbstractMap*) self->transport_streams, GUINT_TO_POINTER (tsid), delivery);
					gst_structure_get_uint (delivery, "frequency", &freq);
					dvb_scanner_add_structure_to_scan (self, _gst_structure_copy0 (delivery));
				}
				if (gst_structure_has_field (transport, "channels")) {
					GValue channels;
					guint channels_size;
					GValue channel_val = {0};
					const GstStructure* channel_struct;
					channels = *gst_structure_get_value (transport, "channels");
					channels_size = gst_value_list_get_size (&channels);
					channel_struct = NULL;
					{
						gint j;
						j = 0;
						{
							gboolean _tmp3_;
							_tmp3_ = TRUE;
							while (TRUE) {
								guint sid = 0U;
								DVBChannel* dvb_channel;
								guint lcnumber = 0U;
								if (!_tmp3_) {
									j++;
								}
								_tmp3_ = FALSE;
								if (!(j < channels_size)) {
									break;
								}
								channel_val = *gst_value_list_get_value (&channels, (guint) j);
								channel_struct = gst_value_get_structure (&channel_val);
								gst_structure_get_uint (channel_struct, "service-id", &sid);
								if (!dvb_channel_list_contains (self->channels, sid)) {
									dvb_scanner_add_new_channel (self, sid);
								}
								dvb_channel = dvb_channel_list_get_channel (self->channels, sid);
								if (g_utf8_validate (name, -1, NULL)) {
									dvb_channel_set_Network (dvb_channel, name);
								} else {
									dvb_channel_set_Network (dvb_channel, "");
								}
								gst_structure_get_uint (channel_struct, "logical-channel-number", &lcnumber);
								dvb_channel_set_LogicalChannelNumber (dvb_channel, &lcnumber);
								_g_object_unref0 (dvb_channel);
							}
						}
					}
				}
			}
		}
	}
	self->priv->nit_arrived = TRUE;
	_g_free0 (name);
}


void dvb_scanner_on_pmt_structure (DVBScanner* self, const GstStructure* structure) {
	guint program_number = 0U;
	DVBChannel* dvb_channel;
	GValue streams;
	guint size;
	GValue stream_val = {0};
	const GstStructure* stream;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	g_debug ("Scanner.vala:624: Received PMT");
	gst_structure_get_uint (structure, "program-number", &program_number);
	if (!dvb_channel_list_contains (self->channels, program_number)) {
		dvb_scanner_add_new_channel (self, program_number);
	}
	dvb_channel = dvb_channel_list_get_channel (self->channels, program_number);
	streams = *gst_structure_get_value (structure, "streams");
	size = gst_value_list_get_size (&streams);
	stream = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint pid = 0U;
				guint stream_type = 0U;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < size)) {
					break;
				}
				stream_val = *gst_value_list_get_value (&streams, (guint) i);
				stream = gst_value_get_structure (&stream_val);
				gst_structure_get_uint (stream, "pid", &pid);
				gst_structure_get_uint (stream, "stream-type", &stream_type);
				switch (stream_type) {
					case 0x01:
					case 0x02:
					case 0x1b:
					{
						g_debug ("Scanner.vala:656: Found video PID %u for channel %u", pid, program_number);
						dvb_channel_set_VideoPID (dvb_channel, pid);
						break;
					}
					case 0x03:
					case 0x04:
					case 0x0f:
					case 0x11:
					{
						g_debug ("Scanner.vala:664: Found audio PID %u for channel %u", pid, program_number);
						gee_collection_add ((GeeCollection*) dvb_channel_get_AudioPIDs (dvb_channel), GUINT_TO_POINTER (pid));
						break;
					}
					default:
					{
						g_debug ("Scanner.vala:669: Other stream type: 0x%02x", stream_type);
						break;
					}
				}
			}
		}
	}
	self->priv->pmt_arrived = TRUE;
	_g_object_unref0 (dvb_channel);
}


gboolean dvb_scanner_bus_watch_func (DVBScanner* self, GstBus* bus, GstMessage* message) {
	gboolean result;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	switch (message->type) {
		case GST_MESSAGE_ELEMENT:
		{
			{
				if (_vala_strcmp0 (gst_structure_get_name (message->structure), "dvb-frontend-stats") == 0) {
					dvb_scanner_on_dvb_frontend_stats_structure (self, message->structure);
				} else {
					if (_vala_strcmp0 (gst_structure_get_name (message->structure), "dvb-read-failure") == 0) {
						dvb_scanner_on_dvb_read_failure_structure (self);
					} else {
						if (_vala_strcmp0 (gst_structure_get_name (message->structure), "sdt") == 0) {
							dvb_scanner_on_sdt_structure (self, message->structure);
						} else {
							if (_vala_strcmp0 (gst_structure_get_name (message->structure), "nit") == 0) {
								dvb_scanner_on_nit_structure (self, message->structure);
							} else {
								if (_vala_strcmp0 (gst_structure_get_name (message->structure), "pat") == 0) {
									dvb_scanner_on_pat_structure (self, message->structure);
								} else {
									if (_vala_strcmp0 (gst_structure_get_name (message->structure), "pmt") == 0) {
										dvb_scanner_on_pmt_structure (self, message->structure);
									}
								}
							}
						}
					}
				}
				break;
			}
		}
		case GST_MESSAGE_ERROR:
		{
			{
				GError* gerror;
				char* debug;
				char* _tmp3_;
				char* _tmp2_ = NULL;
				GError* _tmp1_;
				GError* _tmp0_ = NULL;
				gerror = NULL;
				debug = NULL;
				(gst_message_parse_error (message, &_tmp0_, &_tmp2_), gerror = (_tmp1_ = _tmp0_, _g_error_free0 (gerror), _tmp1_));
				debug = (_tmp3_ = _tmp2_, _g_free0 (debug), _tmp3_);
				g_critical ("Scanner.vala:698: %s %s", gerror->message, debug);
				dvb_scanner_do_destroy (self);
				result = FALSE;
				_g_error_free0 (gerror);
				_g_free0 (debug);
				return result;
			}
		}
	}
	if (self->priv->nit_arrived) {
		_tmp4_ = self->priv->sdt_arrived;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		g_static_rec_mutex_lock (&self->priv->__lock_new_channels);
		{
			{
				GeeIterator* _sid_it;
				_sid_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->new_channels);
				while (TRUE) {
					guint sid;
					DVBChannel* channel;
					guint tsid;
					if (!gee_iterator_next (_sid_it)) {
						break;
					}
					sid = GPOINTER_TO_UINT (gee_iterator_get (_sid_it));
					channel = dvb_channel_list_get_channel (self->channels, sid);
					tsid = dvb_channel_get_TransportStreamId (channel);
					if (gee_map_contains ((GeeMap*) self->transport_streams, GUINT_TO_POINTER (tsid))) {
						GstStructure* _tmp5_;
						dvb_scanner_add_values_from_structure_to_channel (self, _tmp5_ = (GstStructure*) gee_abstract_map_get ((GeeAbstractMap*) self->transport_streams, GUINT_TO_POINTER (tsid)), channel);
						_gst_structure_free0 (_tmp5_);
					} else {
						g_debug ("Scanner.vala:718: TS %u for channel %u does not exist", tsid, sid);
						self->priv->nit_arrived = FALSE;
					}
					_g_object_unref0 (channel);
				}
				_g_object_unref0 (_sid_it);
			}
			if (self->priv->pat_arrived) {
				GeeArrayList* del_channels;
				del_channels = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
				{
					GeeIterator* _sid_it;
					_sid_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->new_channels);
					while (TRUE) {
						guint sid;
						DVBChannel* channel;
						if (!gee_iterator_next (_sid_it)) {
							break;
						}
						sid = GPOINTER_TO_UINT (gee_iterator_get (_sid_it));
						channel = dvb_channel_list_get_channel (self->channels, sid);
						if (dvb_channel_is_valid (channel)) {
							const char* _tmp6_;
							char* type;
							char* _tmp7_;
							_tmp6_ = NULL;
							if (dvb_channel_is_radio (channel)) {
								_tmp6_ = "Radio";
							} else {
								_tmp6_ = "TV";
							}
							type = g_strdup (_tmp6_);
							g_debug ("Scanner.vala:736: Channel added: %s", _tmp7_ = dvb_channel_to_string (channel));
							_g_free0 (_tmp7_);
							g_signal_emit_by_name (self, "channel-added", dvb_channel_get_Frequency (channel), sid, dvb_channel_get_Name (channel), dvb_channel_get_Network (channel), type, dvb_channel_get_Scrambled (channel));
							gee_abstract_collection_add ((GeeAbstractCollection*) del_channels, GUINT_TO_POINTER (sid));
							_g_free0 (type);
						} else {
							char* _tmp8_;
							g_debug ("Scanner.vala:743: Channel %u is not valid: %s", sid, _tmp8_ = dvb_channel_to_string (channel));
							_g_free0 (_tmp8_);
							self->priv->pmt_arrived = FALSE;
						}
						_g_object_unref0 (channel);
					}
					_g_object_unref0 (_sid_it);
				}
				{
					GeeIterator* _sid_it;
					_sid_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) del_channels);
					while (TRUE) {
						guint sid;
						if (!gee_iterator_next (_sid_it)) {
							break;
						}
						sid = GPOINTER_TO_UINT (gee_iterator_get (_sid_it));
						gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->new_channels, GUINT_TO_POINTER (sid));
					}
					_g_object_unref0 (_sid_it);
				}
				_g_object_unref0 (del_channels);
			}
		}
		g_static_rec_mutex_unlock (&self->priv->__lock_new_channels);
	}
	if (self->priv->sdt_arrived) {
		_tmp11_ = self->priv->nit_arrived;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		_tmp10_ = self->priv->pat_arrived;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tmp9_ = self->priv->pmt_arrived;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		dvb_scanner_remove_wait_for_tables_timeout (self);
		dvb_scanner_queue_start_scan (self);
	}
	result = TRUE;
	return result;
}


void dvb_scanner_add_new_channel (DVBScanner* self, guint sid) {
	DVBChannel* new_channel;
	g_return_if_fail (self != NULL);
	g_debug ("Scanner.vala:770: Adding new channel with SID %u", sid);
	new_channel = dvb_scanner_get_new_channel (self);
	dvb_channel_set_Sid (new_channel, sid);
	dvb_channel_list_add (self->channels, new_channel);
	g_static_rec_mutex_lock (&self->priv->__lock_new_channels);
	{
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->new_channels, GUINT_TO_POINTER (sid));
	}
	g_static_rec_mutex_unlock (&self->priv->__lock_new_channels);
	_g_object_unref0 (new_channel);
}


DVBScanner* dvb_scanner_construct (GType object_type) {
	DVBScanner * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBDevice* dvb_scanner_get_Device (DVBScanner* self) {
	DVBDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Device;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_scanner_set_Device (DVBScanner* self, DVBDevice* value) {
	DVBDevice* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Device = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_Device), _tmp0_);
	g_object_notify ((GObject *) self, "Device");
}


DVBChannelList* dvb_scanner_get_Channels (DVBScanner* self) {
	DVBChannelList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->channels;
	return result;
}


static guint _dvb_scanned_item_hash_ghash_func (void* key) {
	return dvb_scanned_item_hash (key);
}


static gboolean _dvb_scanned_item_equal_gequal_func (void* a, void* b) {
	return dvb_scanned_item_equal (a, b);
}


static GObject * dvb_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBScanner * self;
	parent_class = G_OBJECT_CLASS (dvb_scanner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SCANNER (obj);
	{
		GeeHashSet* _tmp0_;
		GeeArrayList* _tmp1_;
		GQueue* _tmp2_;
		GeeHashMap* _tmp3_;
		GMainContext* _tmp4_;
		self->scanned_frequencies = (_tmp0_ = gee_hash_set_new (DVB_TYPE_SCANNED_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, _dvb_scanned_item_hash_ghash_func, _dvb_scanned_item_equal_gequal_func), _g_object_unref0 (self->scanned_frequencies), _tmp0_);
		self->priv->new_channels = (_tmp1_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL), _g_object_unref0 (self->priv->new_channels), _tmp1_);
		self->frequencies = (_tmp2_ = g_queue_new (), _g_queue_free0 (self->frequencies), _tmp2_);
		self->transport_streams = (_tmp3_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GST_TYPE_STRUCTURE, (GBoxedCopyFunc) gst_structure_copy, gst_structure_free, NULL, NULL, NULL), _g_object_unref0 (self->transport_streams), _tmp3_);
		self->priv->context = (_tmp4_ = g_main_context_new (), _g_main_context_unref0 (self->priv->context), _tmp4_);
		self->priv->running = FALSE;
	}
	return obj;
}


static void dvb_scanner_class_init (DVBScannerClass * klass) {
	dvb_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannerPrivate));
	DVB_SCANNER_CLASS (klass)->prepare = dvb_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_scanner_real_add_values_from_structure_to_channel;
	G_OBJECT_CLASS (klass)->get_property = dvb_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_scanner_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNER_DEVICE, g_param_spec_object ("Device", "Device", "Device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNER_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("destroyed", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("frequency_scanned", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("channel_added", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
	g_signal_new ("finished", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void dvb_scanner_instance_init (DVBScanner * self) {
	self->priv = DVB_SCANNER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_new_channels);
}


static void dvb_scanner_finalize (GObject* obj) {
	DVBScanner * self;
	self = DVB_SCANNER (obj);
	_g_object_unref0 (self->priv->_Device);
	_g_object_unref0 (self->channels);
	_gst_object_unref0 (self->pipeline);
	_g_queue_free0 (self->frequencies);
	_gst_structure_free0 (self->current_tuning_params);
	_g_object_unref0 (self->scanned_frequencies);
	_g_object_unref0 (self->transport_streams);
	g_static_rec_mutex_free (&self->priv->__lock_new_channels);
	_g_object_unref0 (self->priv->new_channels);
	_g_source_unref0 (self->priv->check_for_lock_source);
	_g_source_unref0 (self->priv->wait_for_tables_source);
	_g_main_context_unref0 (self->priv->context);
	_g_main_loop_unref0 (self->priv->loop);
	G_OBJECT_CLASS (dvb_scanner_parent_class)->finalize (obj);
}


GType dvb_scanner_get_type (void) {
	static GType dvb_scanner_type_id = 0;
	if (dvb_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScanner), 0, (GInstanceInitFunc) dvb_scanner_instance_init, NULL };
		dvb_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBScanner", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return dvb_scanner_type_id;
}


static void dvb_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScanner * self;
	self = DVB_SCANNER (object);
	switch (property_id) {
		case DVB_SCANNER_DEVICE:
		g_value_set_object (value, dvb_scanner_get_Device (self));
		break;
		case DVB_SCANNER_CHANNELS:
		g_value_set_object (value, dvb_scanner_get_Channels (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScanner * self;
	self = DVB_SCANNER (object);
	switch (property_id) {
		case DVB_SCANNER_DEVICE:
		dvb_scanner_set_Device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}



