/* MediaFactory.c generated by valac, the Vala compiler
 * generated from MediaFactory.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/rtsp-server/rtsp-media-factory.h>
#include <gst/rtsp/gstrtspconnection.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gst/rtsp-server/rtsp-media.h>


#define DVB_TYPE_MEDIA_FACTORY (dvb_media_factory_get_type ())
#define DVB_MEDIA_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactory))
#define DVB_MEDIA_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryClass))
#define DVB_IS_MEDIA_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MEDIA_FACTORY))
#define DVB_IS_MEDIA_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MEDIA_FACTORY))
#define DVB_MEDIA_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryClass))

typedef struct _DVBMediaFactory DVBMediaFactory;
typedef struct _DVBMediaFactoryClass DVBMediaFactoryClass;
typedef struct _DVBMediaFactoryPrivate DVBMediaFactoryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_FACTORY (dvb_channel_factory_get_type ())
#define DVB_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactory))
#define DVB_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))
#define DVB_IS_CHANNEL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_IS_CHANNEL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_FACTORY))
#define DVB_CHANNEL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_FACTORY, DVBChannelFactoryClass))

typedef struct _DVBChannelFactory DVBChannelFactory;
typedef struct _DVBChannelFactoryClass DVBChannelFactoryClass;

#define DVB_TYPE_PLAYER_THREAD (dvb_player_thread_get_type ())
#define DVB_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThread))
#define DVB_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))
#define DVB_IS_PLAYER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PLAYER_THREAD))
#define DVB_IS_PLAYER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PLAYER_THREAD))
#define DVB_PLAYER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PLAYER_THREAD, DVBPlayerThreadClass))

typedef struct _DVBPlayerThread DVBPlayerThread;
typedef struct _DVBPlayerThreadClass DVBPlayerThreadClass;

#define DVB_TYPE_DVB_MEDIA (dvb_dvb_media_get_type ())
#define DVB_DVB_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_MEDIA, DVBDVBMedia))
#define DVB_DVB_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_MEDIA, DVBDVBMediaClass))
#define DVB_IS_DVB_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_MEDIA))
#define DVB_IS_DVB_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_MEDIA))
#define DVB_DVB_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_MEDIA, DVBDVBMediaClass))

typedef struct _DVBDVBMedia DVBDVBMedia;
typedef struct _DVBDVBMediaClass DVBDVBMediaClass;
typedef struct _DVBDVBMediaPrivate DVBDVBMediaPrivate;

struct _DVBMediaFactory {
	GstRTSPMediaFactory parent_instance;
	DVBMediaFactoryPrivate * priv;
};

struct _DVBMediaFactoryClass {
	GstRTSPMediaFactoryClass parent_class;
};

typedef void (*DVBForcedStopNotify) (DVBChannel* channel, void* user_data);
struct _DVBDVBMedia {
	GstRTSPMedia parent_instance;
	DVBDVBMediaPrivate * priv;
	DVBDeviceGroup* group;
	DVBChannel* channel;
	GstElement* payloader;
};

struct _DVBDVBMediaClass {
	GstRTSPMediaClass parent_class;
};


static gpointer dvb_media_factory_parent_class = NULL;
static gpointer dvb_dvb_media_parent_class = NULL;

GType dvb_media_factory_get_type (void);
enum  {
	DVB_MEDIA_FACTORY_DUMMY_PROPERTY
};
GType dvb_manager_get_type (void);
DVBManager* dvb_manager_get_instance (void);
GType dvb_device_group_get_type (void);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
GType dvb_channel_list_get_type (void);
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GType dvb_channel_get_type (void);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
GType dvb_channel_factory_get_type (void);
DVBChannelFactory* dvb_device_group_get_channel_factory (DVBDeviceGroup* self);
GType dvb_player_thread_get_type (void);
DVBPlayerThread* dvb_channel_factory_watch_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink_element, gboolean force, DVBForcedStopNotify notify_func, void* notify_func_target);
void dvb_rtsp_server_stop_streaming (DVBChannel* channel);
static void _dvb_rtsp_server_stop_streaming_dvb_forced_stop_notify (DVBChannel* channel, gpointer self);
GstElement* dvb_player_thread_get_sink_bin (DVBPlayerThread* self, guint sid, GstElement* sink);
DVBDVBMedia* dvb_dvb_media_new (DVBDeviceGroup* group, DVBChannel* channel, GstElement* payloader);
DVBDVBMedia* dvb_dvb_media_construct (GType object_type, DVBDeviceGroup* group, DVBChannel* channel, GstElement* payloader);
GType dvb_dvb_media_get_type (void);
GstElement* dvb_player_thread_get_pipeline (DVBPlayerThread* self);
static GstRTSPMedia* dvb_media_factory_real_construct (GstRTSPMediaFactory* base, GstRTSPUrl* url);
static char* dvb_media_factory_real_gen_key (GstRTSPMediaFactory* base, GstRTSPUrl* url);
DVBMediaFactory* dvb_media_factory_new (void);
DVBMediaFactory* dvb_media_factory_construct (GType object_type);
static GObject * dvb_media_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
enum  {
	DVB_DVB_MEDIA_DUMMY_PROPERTY
};
gboolean dvb_channel_factory_stop_channel (DVBChannelFactory* self, DVBChannel* channel, GstElement* sink);
static gboolean dvb_dvb_media_real_unprepare (GstRTSPMedia* base);
static void dvb_dvb_media_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static void _dvb_rtsp_server_stop_streaming_dvb_forced_stop_notify (DVBChannel* channel, gpointer self) {
	dvb_rtsp_server_stop_streaming (channel);
}


static GstRTSPMedia* dvb_media_factory_real_construct (GstRTSPMediaFactory* base, GstRTSPUrl* url) {
	DVBMediaFactory * self;
	GstRTSPMedia* result;
	guint sidnr;
	guint grpnr;
	char** _tmp1_;
	gint path_elements_size;
	gint path_elements_length1;
	char** _tmp0_;
	char** path_elements;
	gint i;
	char* elem;
	DVBManager* manager;
	DVBDeviceGroup* devgrp;
	GstElement* payload;
	DVBChannel* channel;
	DVBChannelFactory* channels_factory;
	DVBPlayerThread* player;
	GstElement* bin;
	GstRTSPMedia* media;
	GstElement* _tmp3_;
	self = (DVBMediaFactory*) base;
	g_return_val_if_fail (url != NULL, NULL);
	sidnr = (guint) 0;
	grpnr = (guint) 0;
	path_elements = (_tmp1_ = _tmp0_ = g_strsplit (url->abspath, "/", 0), path_elements_length1 = _vala_array_length (_tmp0_), path_elements_size = path_elements_length1, _tmp1_);
	i = 0;
	elem = NULL;
	while (TRUE) {
		char* _tmp2_;
		if (!((elem = (_tmp2_ = g_strdup (path_elements[i]), _g_free0 (elem), _tmp2_)) != NULL)) {
			break;
		}
		if (i == 1) {
			grpnr = (guint) atoi (elem);
		} else {
			if (i == 2) {
				sidnr = (guint) atoi (elem);
			}
		}
		i++;
	}
	manager = _g_object_ref0 (dvb_manager_get_instance ());
	devgrp = dvb_manager_get_device_group_if_exists (manager, grpnr);
	if (devgrp == NULL) {
		g_warning ("MediaFactory.vala:51: Unknown group %u", grpnr);
		result = NULL;
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (elem);
		_g_object_unref0 (manager);
		_g_object_unref0 (devgrp);
		return result;
	}
	payload = gst_element_factory_make ("rtpmp2tpay", "pay0");
	if (payload == NULL) {
		g_critical ("MediaFactory.vala:58: Could not create rtpmp2tpay element");
		result = NULL;
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (elem);
		_g_object_unref0 (manager);
		_g_object_unref0 (devgrp);
		_gst_object_unref0 (payload);
		return result;
	}
	g_object_set ((GObject*) payload, "pt", 96, NULL);
	channel = dvb_channel_list_get_channel (dvb_device_group_get_Channels (devgrp), sidnr);
	if (channel == NULL) {
		g_critical ("MediaFactory.vala:65: No channel with SID %u", sidnr);
		result = NULL;
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (elem);
		_g_object_unref0 (manager);
		_g_object_unref0 (devgrp);
		_gst_object_unref0 (payload);
		_g_object_unref0 (channel);
		return result;
	}
	channels_factory = _g_object_ref0 (dvb_device_group_get_channel_factory (devgrp));
	player = dvb_channel_factory_watch_channel (channels_factory, channel, _gst_object_ref0 (payload), FALSE, _dvb_rtsp_server_stop_streaming_dvb_forced_stop_notify, NULL);
	if (player == NULL) {
		g_debug ("MediaFactory.vala:73: Could not create player");
		result = NULL;
		path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (elem);
		_g_object_unref0 (manager);
		_g_object_unref0 (devgrp);
		_gst_object_unref0 (payload);
		_g_object_unref0 (channel);
		_g_object_unref0 (channels_factory);
		_g_object_unref0 (player);
		return result;
	}
	g_debug ("MediaFactory.vala:76: Retrieving sink bin with payloader");
	bin = dvb_player_thread_get_sink_bin (player, sidnr, payload);
	media = (GstRTSPMedia*) dvb_dvb_media_new (devgrp, channel, payload);
	media->element = bin;
	media->pipeline = (_tmp3_ = dvb_player_thread_get_pipeline (player), _gst_object_unref0 (media->pipeline), _tmp3_);
	gst_rtsp_media_factory_collect_streams ((GstRTSPMediaFactory*) self, url, media);
	result = media;
	path_elements = (_vala_array_free (path_elements, path_elements_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (elem);
	_g_object_unref0 (manager);
	_g_object_unref0 (devgrp);
	_gst_object_unref0 (payload);
	_g_object_unref0 (channel);
	_g_object_unref0 (channels_factory);
	_g_object_unref0 (player);
	_gst_object_unref0 (bin);
	return result;
}


static char* dvb_media_factory_real_gen_key (GstRTSPMediaFactory* base, GstRTSPUrl* url) {
	DVBMediaFactory * self;
	char* result;
	self = (DVBMediaFactory*) base;
	g_return_val_if_fail (url != NULL, NULL);
	result = g_strdup (url->abspath);
	return result;
}


DVBMediaFactory* dvb_media_factory_construct (GType object_type) {
	DVBMediaFactory * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DVBMediaFactory* dvb_media_factory_new (void) {
	return dvb_media_factory_construct (DVB_TYPE_MEDIA_FACTORY);
}


static GObject * dvb_media_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBMediaFactory * self;
	parent_class = G_OBJECT_CLASS (dvb_media_factory_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MEDIA_FACTORY (obj);
	{
		gst_rtsp_media_factory_set_shared ((GstRTSPMediaFactory*) self, TRUE);
	}
	return obj;
}


static void dvb_media_factory_class_init (DVBMediaFactoryClass * klass) {
	dvb_media_factory_parent_class = g_type_class_peek_parent (klass);
	GST_RTSP_MEDIA_FACTORY_CLASS (klass)->construct = dvb_media_factory_real_construct;
	GST_RTSP_MEDIA_FACTORY_CLASS (klass)->gen_key = dvb_media_factory_real_gen_key;
	G_OBJECT_CLASS (klass)->constructor = dvb_media_factory_constructor;
}


static void dvb_media_factory_instance_init (DVBMediaFactory * self) {
}


GType dvb_media_factory_get_type (void) {
	static GType dvb_media_factory_type_id = 0;
	if (dvb_media_factory_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaFactory), 0, (GInstanceInitFunc) dvb_media_factory_instance_init, NULL };
		dvb_media_factory_type_id = g_type_register_static (GST_TYPE_RTSP_MEDIA_FACTORY, "DVBMediaFactory", &g_define_type_info, 0);
	}
	return dvb_media_factory_type_id;
}


DVBDVBMedia* dvb_dvb_media_construct (GType object_type, DVBDeviceGroup* group, DVBChannel* channel, GstElement* payloader) {
	DVBDVBMedia * self;
	DVBDeviceGroup* _tmp0_;
	DVBChannel* _tmp1_;
	GstElement* _tmp2_;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (payloader != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	self->group = (_tmp0_ = _g_object_ref0 (group), _g_object_unref0 (self->group), _tmp0_);
	self->channel = (_tmp1_ = _g_object_ref0 (channel), _g_object_unref0 (self->channel), _tmp1_);
	self->payloader = (_tmp2_ = _gst_object_ref0 (payloader), _gst_object_unref0 (self->payloader), _tmp2_);
	return self;
}


DVBDVBMedia* dvb_dvb_media_new (DVBDeviceGroup* group, DVBChannel* channel, GstElement* payloader) {
	return dvb_dvb_media_construct (DVB_TYPE_DVB_MEDIA, group, channel, payloader);
}


static gboolean dvb_dvb_media_real_unprepare (GstRTSPMedia* base) {
	DVBDVBMedia * self;
	gboolean result;
	DVBChannelFactory* channels_factory;
	self = (DVBDVBMedia*) base;
	gst_rtsp_media_remove_elements ((GstRTSPMedia*) self);
	channels_factory = _g_object_ref0 (dvb_device_group_get_channel_factory (self->group));
	dvb_channel_factory_stop_channel (channels_factory, self->channel, self->payloader);
	result = TRUE;
	_g_object_unref0 (channels_factory);
	return result;
}


static void dvb_dvb_media_class_init (DVBDVBMediaClass * klass) {
	dvb_dvb_media_parent_class = g_type_class_peek_parent (klass);
	GST_RTSP_MEDIA_CLASS (klass)->unprepare = dvb_dvb_media_real_unprepare;
	G_OBJECT_CLASS (klass)->finalize = dvb_dvb_media_finalize;
}


static void dvb_dvb_media_instance_init (DVBDVBMedia * self) {
}


static void dvb_dvb_media_finalize (GObject* obj) {
	DVBDVBMedia * self;
	self = DVB_DVB_MEDIA (obj);
	_g_object_unref0 (self->group);
	_g_object_unref0 (self->channel);
	_gst_object_unref0 (self->payloader);
	G_OBJECT_CLASS (dvb_dvb_media_parent_class)->finalize (obj);
}


GType dvb_dvb_media_get_type (void) {
	static GType dvb_dvb_media_type_id = 0;
	if (dvb_dvb_media_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDVBMediaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_dvb_media_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDVBMedia), 0, (GInstanceInitFunc) dvb_dvb_media_instance_init, NULL };
		dvb_dvb_media_type_id = g_type_register_static (GST_TYPE_RTSP_MEDIA, "DVBDVBMedia", &g_define_type_info, 0);
	}
	return dvb_dvb_media_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




