/* vi:set ts=8 sts=0 sw=8:
 * $Id: advopts.h,v 1.1 2000/07/15 20:02:46 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __ADVOPT_H__
#define __ADVOPT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <config.h>

enum advopt_e {
	AO_NONE		= 0,

	/* Options */
	AO_DAYSTART	= (1 << 0),
	AO_DEPTH	= (1 << 1),
	AO_FOLLOW	= (1 << 2),
	AO_MAXDEPTH	= (1 << 3),
	AO_MINDEPTH	= (1 << 4),
	AO_XDEV		= (1 << 5),
	AO_NOLEAF	= (1 << 6),

	/* Actions - Print */
	AO_STDOUT	= (1 << 7),
	AO_FPRINT	= (1 << 8),
	AO_WPRINT	= (1 << 9),

	/* Actions - Misc */
	AO_PRUNE	= (1 << 10),

	/* Actions - Exec */
	AO_EXEC_EXEC	= (1 << 11),
	AO_EXEC_PROMPT	= (1 << 12),

	/* Actions - Special */
	AO_GREP		= (1 << 13),

	AO_LAST		= (1 << 31)
};
typedef enum advopt_e advopt_t;


extern void	advopts_cb(GtkWidget *wgt, gpointer cbdata);
extern int	advopts_options_add(win_t *w, GSList *argvl);
extern int	advopts_tests_add(win_t *w, GSList *argvl);
extern int	advopts_actions_add(win_t *w, GSList *argvl);
extern void	advopts_prefs_toolbar_set(win_t *w);
extern void	advopts_prefs_save(win_t *w);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __ADVOPT_H__ */
