/* vi:set ts=8 sts=0 sw=8:
 * $Id: misc.h,v 1.2 2000/07/18 06:10:24 kahn Exp kahn $
 *
 * Copyright (C) 2000 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __MISC_H__
#define __MISC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include "win.h"

#define GLADE_MODAL		(1 << 0)
#define GLADE_POS_MOUSE		(1 << 1)
#define GLADE_SHOW		(1 << 2)
#define GLADE_HIDE		(1 << 3)

extern GtkWidget **my_widgets_setup(win_t *w, GtkWidget **wgts, int num,
				    ef_t ef_wgts[], char *name,
				    int top_id, int max_id,
				    gboolean destroy_and_rebuild);
extern void my_gtk_events_flush(void);
extern GtkWidget *my_glade_widget_get(GladeXML *xml, char *name, int flags);
extern GladeXML *my_glade_xml_get(char *root);
extern void my_prefs_window_set_size(GtkWidget *, int, int w_id, int h_id);
extern char *strrepl(char *orig, char *pat, char *repl);
extern char *my_dir_expand_home(char *txt);
extern void my_clist_down(GtkWidget **wgts, int clist_id);
extern void my_clist_up(GtkWidget **wgts, int clist_id);
extern void my_clist_del(GtkWidget **wgts, int clist_id);
extern GSList *my_argvl_build(char *txt, int *argc, GSList *argvl);
extern char *my_tempname(void);
extern void cmd_err(const char *msg, int errnum);
extern int  cmd_exec(const char *msg, win_t *w, char *, gboolean, gboolean);
extern char *file_full_pathname_make(char *fname);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __MISC_H__ */
