/* command-runner.c generated by valac 0.35.5.22-e5360, the Vala compiler
 * generated from command-runner.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_RUNNER (games_runner_get_type ())
#define GAMES_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RUNNER, GamesRunner))
#define GAMES_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RUNNER))
#define GAMES_RUNNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_RUNNER, GamesRunnerIface))

typedef struct _GamesRunner GamesRunner;
typedef struct _GamesRunnerIface GamesRunnerIface;

#define GAMES_TYPE_MEDIA_SET (games_media_set_get_type ())
#define GAMES_MEDIA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MEDIA_SET, GamesMediaSet))
#define GAMES_MEDIA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MEDIA_SET, GamesMediaSetClass))
#define GAMES_IS_MEDIA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MEDIA_SET))
#define GAMES_IS_MEDIA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MEDIA_SET))
#define GAMES_MEDIA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MEDIA_SET, GamesMediaSetClass))

typedef struct _GamesMediaSet GamesMediaSet;
typedef struct _GamesMediaSetClass GamesMediaSetClass;

#define GAMES_TYPE_COMMAND_RUNNER (games_command_runner_get_type ())
#define GAMES_COMMAND_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COMMAND_RUNNER, GamesCommandRunner))
#define GAMES_COMMAND_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_COMMAND_RUNNER, GamesCommandRunnerClass))
#define GAMES_IS_COMMAND_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COMMAND_RUNNER))
#define GAMES_IS_COMMAND_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_COMMAND_RUNNER))
#define GAMES_COMMAND_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_COMMAND_RUNNER, GamesCommandRunnerClass))

typedef struct _GamesCommandRunner GamesCommandRunner;
typedef struct _GamesCommandRunnerClass GamesCommandRunnerClass;
typedef struct _GamesCommandRunnerPrivate GamesCommandRunnerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_REMOTE_DISPLAY (games_remote_display_get_type ())
#define GAMES_REMOTE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_REMOTE_DISPLAY, GamesRemoteDisplay))
#define GAMES_REMOTE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_REMOTE_DISPLAY, GamesRemoteDisplayClass))
#define GAMES_IS_REMOTE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_REMOTE_DISPLAY))
#define GAMES_IS_REMOTE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_REMOTE_DISPLAY))
#define GAMES_REMOTE_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_REMOTE_DISPLAY, GamesRemoteDisplayClass))

typedef struct _GamesRemoteDisplay GamesRemoteDisplay;
typedef struct _GamesRemoteDisplayClass GamesRemoteDisplayClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesRunnerIface {
	GTypeInterface parent_iface;
	gboolean (*check_is_valid) (GamesRunner* self, gchar* * error_message, GError** error);
	GtkWidget* (*get_display) (GamesRunner* self);
	void (*start) (GamesRunner* self, GError** error);
	void (*resume) (GamesRunner* self, GError** error);
	void (*pause) (GamesRunner* self);
	void (*stop) (GamesRunner* self);
	gboolean (*get_can_fullscreen) (GamesRunner* self);
	gboolean (*get_can_quit_safely) (GamesRunner* self);
	gboolean (*get_can_resume) (GamesRunner* self);
	GamesMediaSet* (*get_media_set) (GamesRunner* self);
};

struct _GamesCommandRunner {
	GObject parent_instance;
	GamesCommandRunnerPrivate * priv;
};

struct _GamesCommandRunnerClass {
	GObjectClass parent_class;
};

struct _GamesCommandRunnerPrivate {
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gboolean watch_child;
	gboolean running;
};

typedef enum  {
	GAMES_COMMAND_ERROR_INVALID_COMMAND,
	GAMES_COMMAND_ERROR_EXECUTION_FAILED
} GamesCommandError;
#define GAMES_COMMAND_ERROR games_command_error_quark ()

static gpointer games_command_runner_parent_class = NULL;
static GamesRunnerIface * games_command_runner_games_runner_parent_iface = NULL;

GType games_media_set_get_type (void) G_GNUC_CONST;
GType games_runner_get_type (void) G_GNUC_CONST;
GType games_command_runner_get_type (void) G_GNUC_CONST;
#define GAMES_COMMAND_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_COMMAND_RUNNER, GamesCommandRunnerPrivate))
enum  {
	GAMES_COMMAND_RUNNER_DUMMY_PROPERTY,
	GAMES_COMMAND_RUNNER_CAN_FULLSCREEN,
	GAMES_COMMAND_RUNNER_CAN_QUIT_SAFELY,
	GAMES_COMMAND_RUNNER_CAN_RESUME,
	GAMES_COMMAND_RUNNER_MEDIA_SET
};
GamesCommandRunner* games_command_runner_new (gchar** args, int args_length1, gboolean watch_child);
GamesCommandRunner* games_command_runner_construct (GType object_type, gchar** args, int args_length1, gboolean watch_child);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gboolean games_command_runner_real_check_is_valid (GamesRunner* base, gchar* * error_message, GError** error);
static GtkWidget* games_command_runner_real_get_display (GamesRunner* base);
GamesRemoteDisplay* games_remote_display_new (void);
GamesRemoteDisplay* games_remote_display_construct (GType object_type);
GType games_remote_display_get_type (void) G_GNUC_CONST;
static void games_command_runner_real_start (GamesRunner* base, GError** error);
static gint* _int_dup (gint* self);
GQuark games_command_error_quark (void);
static void __lambda4_ (GamesCommandRunner* self);
static void games_command_runner_on_process_stopped (GamesCommandRunner* self);
static void ___lambda4__gchild_watch_func (GPid pid, gint status, gpointer self);
static void games_command_runner_real_resume (GamesRunner* base, GError** error);
static void games_command_runner_real_pause (GamesRunner* base);
static void games_command_runner_real_stop (GamesRunner* base);
static void games_command_runner_finalize (GObject * obj);
gboolean games_runner_get_can_fullscreen (GamesRunner* self);
gboolean games_runner_get_can_quit_safely (GamesRunner* self);
gboolean games_runner_get_can_resume (GamesRunner* self);
GamesMediaSet* games_runner_get_media_set (GamesRunner* self);
static void _vala_games_command_runner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


GamesCommandRunner* games_command_runner_construct (GType object_type, gchar** args, int args_length1, gboolean watch_child) {
	GamesCommandRunner * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp2_;
	self = (GamesCommandRunner*) g_object_new (object_type, NULL);
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->args = _tmp1_;
	self->priv->args_length1 = _tmp1__length1;
	self->priv->_args_size_ = self->priv->args_length1;
	_tmp2_ = watch_child;
	self->priv->watch_child = _tmp2_;
	return self;
}


GamesCommandRunner* games_command_runner_new (gchar** args, int args_length1, gboolean watch_child) {
	return games_command_runner_construct (GAMES_TYPE_COMMAND_RUNNER, args, args_length1, watch_child);
}


static gboolean games_command_runner_real_check_is_valid (GamesRunner* base, gchar* * error_message, GError** error) {
	GamesCommandRunner * self;
	gchar* _vala_error_message = NULL;
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	self = (GamesCommandRunner*) base;
	_tmp0_ = self->priv->args;
	_tmp0__length1 = self->priv->args_length1;
	if (_tmp0__length1 > 0) {
		result = TRUE;
		if (error_message) {
			*error_message = _vala_error_message;
		} else {
			_g_free0 (_vala_error_message);
		}
		return result;
	}
	g_debug ("command-runner.vala:32: Invalid command: it doesn’t have any argument.");
	_tmp1_ = g_strdup (_ ("The game doesn’t have a valid command."));
	_g_free0 (_vala_error_message);
	_vala_error_message = _tmp1_;
	result = FALSE;
	if (error_message) {
		*error_message = _vala_error_message;
	} else {
		_g_free0 (_vala_error_message);
	}
	return result;
}


static GtkWidget* games_command_runner_real_get_display (GamesRunner* base) {
	GamesCommandRunner * self;
	GtkWidget* result = NULL;
	GamesRemoteDisplay* _tmp0_;
	self = (GamesCommandRunner*) base;
	_tmp0_ = games_remote_display_new ();
	g_object_ref_sink (_tmp0_);
	result = (GtkWidget*) _tmp0_;
	return result;
}


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static void __lambda4_ (GamesCommandRunner* self) {
	games_command_runner_on_process_stopped (self);
}


static void ___lambda4__gchild_watch_func (GPid pid, gint status, gpointer self) {
	__lambda4_ ((GamesCommandRunner*) self);
}


static void games_command_runner_real_start (GamesRunner* base, GError** error) {
	GamesCommandRunner * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gchar* working_directory;
	gchar** envp;
	gint envp_length1;
	gint _envp_size_;
	GSpawnFlags flags;
	gboolean _tmp3_;
	GSpawnChildSetupFunc child_setup;
	void* child_setup_target;
	GDestroyNotify child_setup_target_destroy_notify;
	GPid pid = 0;
	gint* standard_input;
	gint* standard_output;
	gint* standard_error;
	gboolean _tmp28_;
	GPid _tmp29_;
	GError * _inner_error_ = NULL;
	self = (GamesCommandRunner*) base;
	_tmp1_ = self->priv->running;
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->watch_child;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	working_directory = NULL;
	envp = NULL;
	envp_length1 = 0;
	_envp_size_ = envp_length1;
	flags = G_SPAWN_SEARCH_PATH;
	_tmp3_ = self->priv->watch_child;
	if (_tmp3_) {
		GSpawnFlags _tmp4_;
		_tmp4_ = flags;
		flags = _tmp4_ | G_SPAWN_DO_NOT_REAP_CHILD;
	}
	child_setup = NULL;
	child_setup_target = NULL;
	child_setup_target_destroy_notify = NULL;
	standard_input = NULL;
	standard_output = NULL;
	standard_error = NULL;
	{
		gboolean _result_;
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp7_;
		gint _tmp7__length1;
		GSpawnFlags _tmp8_;
		GSpawnChildSetupFunc _tmp9_;
		void* _tmp9__target;
		GPid _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gboolean _tmp14_;
		gint _tmp15_;
		gint* _tmp16_;
		gint _tmp17_;
		gint* _tmp18_;
		gint _tmp19_;
		gint* _tmp20_;
		gboolean _tmp21_;
		_tmp5_ = working_directory;
		_tmp6_ = self->priv->args;
		_tmp6__length1 = self->priv->args_length1;
		_tmp7_ = envp;
		_tmp7__length1 = envp_length1;
		_tmp8_ = flags;
		_tmp9_ = child_setup;
		_tmp9__target = child_setup_target;
		_tmp14_ = g_spawn_async_with_pipes (_tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp9__target, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_inner_error_);
		pid = _tmp10_;
		_g_free0 (standard_input);
		_tmp15_ = _tmp11_;
		_tmp16_ = __int_dup0 (&_tmp15_);
		standard_input = _tmp16_;
		_g_free0 (standard_output);
		_tmp17_ = _tmp12_;
		_tmp18_ = __int_dup0 (&_tmp17_);
		standard_output = _tmp18_;
		_g_free0 (standard_error);
		_tmp19_ = _tmp13_;
		_tmp20_ = __int_dup0 (&_tmp19_);
		standard_error = _tmp20_;
		_result_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (standard_error);
			_g_free0 (standard_output);
			_g_free0 (standard_input);
			(child_setup_target_destroy_notify == NULL) ? NULL : (child_setup_target_destroy_notify (child_setup_target), NULL);
			child_setup = NULL;
			child_setup_target = NULL;
			child_setup_target_destroy_notify = NULL;
			envp = (_vala_array_free (envp, envp_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (working_directory);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp21_ = _result_;
		if (!_tmp21_) {
			gchar** _tmp22_;
			gint _tmp22__length1;
			const gchar* _tmp23_;
			GError* _tmp24_;
			_tmp22_ = self->priv->args;
			_tmp22__length1 = self->priv->args_length1;
			_tmp23_ = _tmp22_[0];
			_tmp24_ = g_error_new (GAMES_COMMAND_ERROR, GAMES_COMMAND_ERROR_EXECUTION_FAILED, _ ("Couldn’t run “%s”: execution failed."), _tmp23_);
			_inner_error_ = _tmp24_;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		gboolean _tmp27_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		g_warning ("command-runner.vala:67: %s\n", _tmp26_);
		_tmp27_ = self->priv->watch_child;
		if (_tmp27_) {
			_g_error_free0 (e);
			_g_free0 (standard_error);
			_g_free0 (standard_output);
			_g_free0 (standard_input);
			(child_setup_target_destroy_notify == NULL) ? NULL : (child_setup_target_destroy_notify (child_setup_target), NULL);
			child_setup = NULL;
			child_setup_target = NULL;
			child_setup_target_destroy_notify = NULL;
			envp = (_vala_array_free (envp, envp_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (working_directory);
			return;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		_g_free0 (standard_input);
		(child_setup_target_destroy_notify == NULL) ? NULL : (child_setup_target_destroy_notify (child_setup_target), NULL);
		child_setup = NULL;
		child_setup_target = NULL;
		child_setup_target_destroy_notify = NULL;
		envp = (_vala_array_free (envp, envp_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (working_directory);
		return;
	}
	_tmp28_ = self->priv->watch_child;
	if (!_tmp28_) {
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		_g_free0 (standard_input);
		(child_setup_target_destroy_notify == NULL) ? NULL : (child_setup_target_destroy_notify (child_setup_target), NULL);
		child_setup = NULL;
		child_setup_target = NULL;
		child_setup_target_destroy_notify = NULL;
		envp = (_vala_array_free (envp, envp_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (working_directory);
		return;
	}
	_tmp29_ = pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp29_, ___lambda4__gchild_watch_func, g_object_ref (self), g_object_unref);
	self->priv->running = TRUE;
	_g_free0 (standard_error);
	_g_free0 (standard_output);
	_g_free0 (standard_input);
	(child_setup_target_destroy_notify == NULL) ? NULL : (child_setup_target_destroy_notify (child_setup_target), NULL);
	child_setup = NULL;
	child_setup_target = NULL;
	child_setup_target_destroy_notify = NULL;
	envp = (_vala_array_free (envp, envp_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (working_directory);
}


static void games_command_runner_real_resume (GamesRunner* base, GError** error) {
	GamesCommandRunner * self;
	self = (GamesCommandRunner*) base;
}


static void games_command_runner_real_pause (GamesRunner* base) {
	GamesCommandRunner * self;
	self = (GamesCommandRunner*) base;
}


static void games_command_runner_real_stop (GamesRunner* base) {
	GamesCommandRunner * self;
	self = (GamesCommandRunner*) base;
}


static void games_command_runner_on_process_stopped (GamesCommandRunner* self) {
	g_return_if_fail (self != NULL);
	self->priv->running = FALSE;
	g_signal_emit_by_name ((GamesRunner*) self, "stopped");
}


static gboolean games_command_runner_real_get_can_fullscreen (GamesRunner* base) {
	gboolean result;
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	result = FALSE;
	return result;
}


static gboolean games_command_runner_real_get_can_quit_safely (GamesRunner* base) {
	gboolean result;
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	result = TRUE;
	return result;
}


static gboolean games_command_runner_real_get_can_resume (GamesRunner* base) {
	gboolean result;
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	result = FALSE;
	return result;
}


static GamesMediaSet* games_command_runner_real_get_media_set (GamesRunner* base) {
	GamesMediaSet* result;
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	result = NULL;
	return result;
}


static void games_command_runner_class_init (GamesCommandRunnerClass * klass) {
	games_command_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesCommandRunnerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_command_runner_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_command_runner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COMMAND_RUNNER_CAN_FULLSCREEN, g_param_spec_boolean ("can-fullscreen", "can-fullscreen", "can-fullscreen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COMMAND_RUNNER_CAN_QUIT_SAFELY, g_param_spec_boolean ("can-quit-safely", "can-quit-safely", "can-quit-safely", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COMMAND_RUNNER_CAN_RESUME, g_param_spec_boolean ("can-resume", "can-resume", "can-resume", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COMMAND_RUNNER_MEDIA_SET, g_param_spec_object ("media-set", "media-set", "media-set", GAMES_TYPE_MEDIA_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void games_command_runner_games_runner_interface_init (GamesRunnerIface * iface) {
	games_command_runner_games_runner_parent_iface = g_type_interface_peek_parent (iface);
	iface->check_is_valid = (gboolean (*) (GamesRunner *, gchar* *, GError**)) games_command_runner_real_check_is_valid;
	iface->get_display = (GtkWidget* (*) (GamesRunner *)) games_command_runner_real_get_display;
	iface->start = (void (*) (GamesRunner *, GError**)) games_command_runner_real_start;
	iface->resume = (void (*) (GamesRunner *, GError**)) games_command_runner_real_resume;
	iface->pause = (void (*) (GamesRunner *)) games_command_runner_real_pause;
	iface->stop = (void (*) (GamesRunner *)) games_command_runner_real_stop;
	iface->get_can_fullscreen = games_command_runner_real_get_can_fullscreen;
	iface->get_can_quit_safely = games_command_runner_real_get_can_quit_safely;
	iface->get_can_resume = games_command_runner_real_get_can_resume;
	iface->get_media_set = games_command_runner_real_get_media_set;
}


static void games_command_runner_instance_init (GamesCommandRunner * self) {
	self->priv = GAMES_COMMAND_RUNNER_GET_PRIVATE (self);
}


static void games_command_runner_finalize (GObject * obj) {
	GamesCommandRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_COMMAND_RUNNER, GamesCommandRunner);
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (games_command_runner_parent_class)->finalize (obj);
}


GType games_command_runner_get_type (void) {
	static volatile gsize games_command_runner_type_id__volatile = 0;
	if (g_once_init_enter (&games_command_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesCommandRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_command_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesCommandRunner), 0, (GInstanceInitFunc) games_command_runner_instance_init, NULL };
		static const GInterfaceInfo games_runner_info = { (GInterfaceInitFunc) games_command_runner_games_runner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType games_command_runner_type_id;
		games_command_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesCommandRunner", &g_define_type_info, 0);
		g_type_add_interface_static (games_command_runner_type_id, GAMES_TYPE_RUNNER, &games_runner_info);
		g_once_init_leave (&games_command_runner_type_id__volatile, games_command_runner_type_id);
	}
	return games_command_runner_type_id__volatile;
}


static void _vala_games_command_runner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesCommandRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_COMMAND_RUNNER, GamesCommandRunner);
	switch (property_id) {
		case GAMES_COMMAND_RUNNER_CAN_FULLSCREEN:
		g_value_set_boolean (value, games_runner_get_can_fullscreen ((GamesRunner*) self));
		break;
		case GAMES_COMMAND_RUNNER_CAN_QUIT_SAFELY:
		g_value_set_boolean (value, games_runner_get_can_quit_safely ((GamesRunner*) self));
		break;
		case GAMES_COMMAND_RUNNER_CAN_RESUME:
		g_value_set_boolean (value, games_runner_get_can_resume ((GamesRunner*) self));
		break;
		case GAMES_COMMAND_RUNNER_MEDIA_SET:
		g_value_set_object (value, games_runner_get_media_set ((GamesRunner*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



