// This file is part of GNOME Games. License: GPL-3.0+.

private enum Games.StandardGamepadAxis {
	UNKNOWN,

	/**
	 * The horizontal axis of the left stick.
	 *
	 * Negative is left, positive is right.
	 */
	LEFT_X,

	/**
	 * The vertical axis of the left stick.
	 *
	 * Negative is up, positive is down.
	 */
	LEFT_Y,

	/**
	 * The horizontal axis of the right stick.
	 *
	 * Negative is left, positive is right.
	 */
	RIGHT_X,

	/**
	 * The vertical axis of the right stick.
	 *
	 * Negative is up, positive is down.
	 */
	RIGHT_Y,
}
