/* turbografx-cd-plugin.c generated by valac 0.38.0, the Vala compiler
 * generated from turbografx-cd-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN (games_turbo_grafx_cd_plugin_get_type ())
#define GAMES_TURBO_GRAFX_CD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN, GamesTurboGrafxCDPlugin))
#define GAMES_TURBO_GRAFX_CD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN, GamesTurboGrafxCDPluginClass))
#define GAMES_IS_TURBO_GRAFX_CD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN))
#define GAMES_IS_TURBO_GRAFX_CD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN))
#define GAMES_TURBO_GRAFX_CD_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN, GamesTurboGrafxCDPluginClass))

typedef struct _GamesTurboGrafxCDPlugin GamesTurboGrafxCDPlugin;
typedef struct _GamesTurboGrafxCDPluginClass GamesTurboGrafxCDPluginClass;
typedef struct _GamesTurboGrafxCDPluginPrivate GamesTurboGrafxCDPluginPrivate;
enum  {
	GAMES_TURBO_GRAFX_CD_PLUGIN_DUMMY_PROPERTY,
	GAMES_TURBO_GRAFX_CD_PLUGIN_LAST_PROPERTY
};
static GParamSpec* games_turbo_grafx_cd_plugin_properties[GAMES_TURBO_GRAFX_CD_PLUGIN_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesTurboGrafxCDPlugin {
	GObject parent_instance;
	GamesTurboGrafxCDPluginPrivate * priv;
};

struct _GamesTurboGrafxCDPluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_TURBO_GRAFX_CD_ERROR_INVALID_DISC
} GamesTurboGrafxCDError;
#define GAMES_TURBO_GRAFX_CD_ERROR games_turbo_grafx_cd_error_quark ()

static gpointer games_turbo_grafx_cd_plugin_parent_class = NULL;
static GamesPluginIface * games_turbo_grafx_cd_plugin_games_plugin_parent_iface = NULL;
static GType games_turbo_grafx_cd_plugin_type_id = 0;

GType games_turbo_grafx_cd_plugin_get_type (void) G_GNUC_CONST;
#define GAMES_TURBO_GRAFX_CD_PLUGIN_FINGERPRINT_PREFIX "pc-engine"
#define GAMES_TURBO_GRAFX_CD_PLUGIN_MIME_TYPE "application/x-pc-engine-rom"
#define GAMES_TURBO_GRAFX_CD_PLUGIN_CUE_MIME_TYPE "application/x-cue"
#define GAMES_TURBO_GRAFX_CD_PLUGIN_CD_MAGIC_VALUE "PC Engine CD-ROM SYSTEM"
#define GAMES_TURBO_GRAFX_CD_PLUGIN_CD_PLATFORM "TurboGrafxCD"
static gchar** games_turbo_grafx_cd_plugin_real_get_mime_types (GamesPlugin* base, int* result_length1);
static GamesUriGameFactory** games_turbo_grafx_cd_plugin_real_get_uri_game_factories (GamesPlugin* base, int* result_length1);
static GamesGame* games_turbo_grafx_cd_plugin_game_for_uri (GamesUri* uri, GError** error);
static GamesGame* _games_turbo_grafx_cd_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri, gpointer self, GError** error);
static gboolean games_turbo_grafx_cd_plugin_is_valid_disc (GamesUri* uri, GError** error);
GQuark games_turbo_grafx_cd_error_quark (void);
GamesTurboGrafxCDPlugin* games_turbo_grafx_cd_plugin_new (void);
GamesTurboGrafxCDPlugin* games_turbo_grafx_cd_plugin_construct (GType object_type);
GType register_games_plugin (GTypeModule* module);
GType games_turbo_grafx_cd_plugin_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar** games_turbo_grafx_cd_plugin_real_get_mime_types (GamesPlugin* base, int* result_length1) {
	GamesTurboGrafxCDPlugin * self;
	gchar** result = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (GamesTurboGrafxCDPlugin*) base;
	_tmp0_ = g_strdup (GAMES_TURBO_GRAFX_CD_PLUGIN_CUE_MIME_TYPE);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static GamesGame* _games_turbo_grafx_cd_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri, gpointer self, GError** error) {
	GamesGame* result;
	result = games_turbo_grafx_cd_plugin_game_for_uri (uri, error);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GamesUriGameFactory** games_turbo_grafx_cd_plugin_real_get_uri_game_factories (GamesPlugin* base, int* result_length1) {
	GamesTurboGrafxCDPlugin * self;
	GamesUriGameFactory** result = NULL;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericUriGameFactory* _tmp1_;
	GamesUriGameFactory* _tmp2_;
	GamesUriGameFactory** _tmp3_;
	GamesUriGameFactory** _tmp4_;
	gint _tmp4__length1;
	self = (GamesTurboGrafxCDPlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_turbo_grafx_cd_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter);
	factory = _tmp1_;
	games_generic_uri_game_factory_add_mime_type (factory, GAMES_TURBO_GRAFX_CD_PLUGIN_CUE_MIME_TYPE);
	_tmp2_ = _g_object_ref0 ((GamesUriGameFactory*) factory);
	_tmp3_ = g_new0 (GamesUriGameFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}


static GamesGame* games_turbo_grafx_cd_plugin_game_for_uri (GamesUri* uri, GError** error) {
	GamesGame* result = NULL;
	gboolean _tmp0_ = FALSE;
	GamesUri* _tmp1_;
	gboolean _tmp2_;
	GamesFingerprintUid* uid = NULL;
	GamesUri* _tmp8_;
	GamesFingerprintUid* _tmp9_;
	GamesFilenameTitle* title = NULL;
	GamesUri* _tmp10_;
	GamesFilenameTitle* _tmp11_;
	GamesDummyIcon* icon = NULL;
	GamesDummyIcon* _tmp12_;
	GamesGriloMedia* media = NULL;
	GamesFilenameTitle* _tmp13_;
	GamesGriloMedia* _tmp14_;
	GamesCompositeCover* cover = NULL;
	GamesUri* _tmp15_;
	GamesLocalCover* _tmp16_;
	GamesGriloMedia* _tmp17_;
	GamesFingerprintUid* _tmp18_;
	GamesGriloCover* _tmp19_;
	GamesCover** _tmp20_;
	GamesCover** _tmp21_;
	gint _tmp21__length1;
	GamesCompositeCover* _tmp22_;
	GamesCompositeCover* _tmp23_;
	GamesRetroCoreSource* core_source = NULL;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	GamesRetroCoreSource* _tmp28_;
	GamesRetroCoreSource* _tmp29_;
	GamesRetroRunner* runner = NULL;
	GamesRetroCoreSource* _tmp30_;
	GamesUri* _tmp31_;
	GamesFingerprintUid* _tmp32_;
	GamesFilenameTitle* _tmp33_;
	GamesRetroRunner* _tmp34_;
	GamesFilenameTitle* _tmp35_;
	GamesDummyIcon* _tmp36_;
	GamesCompositeCover* _tmp37_;
	GamesRetroRunner* _tmp38_;
	GamesGenericGame* _tmp39_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp1_ = uri;
	_tmp2_ = games_turbo_grafx_cd_plugin_is_valid_disc (_tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (!_tmp0_) {
		GamesUri* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp3_ = uri;
		_tmp4_ = games_uri_to_string (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (GAMES_TURBO_GRAFX_CD_ERROR, GAMES_TURBO_GRAFX_CD_ERROR_INVALID_DISC, "“%s” isn’t a valid TurboGrafx-CD disc.", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp8_ = uri;
	_tmp9_ = games_fingerprint_uid_new (_tmp8_, GAMES_TURBO_GRAFX_CD_PLUGIN_FINGERPRINT_PREFIX);
	uid = _tmp9_;
	_tmp10_ = uri;
	_tmp11_ = games_filename_title_new (_tmp10_);
	title = _tmp11_;
	_tmp12_ = games_dummy_icon_new ();
	icon = _tmp12_;
	_tmp13_ = title;
	_tmp14_ = games_grilo_media_new ((GamesTitle*) _tmp13_, GAMES_TURBO_GRAFX_CD_PLUGIN_MIME_TYPE);
	media = _tmp14_;
	_tmp15_ = uri;
	_tmp16_ = games_local_cover_new (_tmp15_);
	_tmp17_ = media;
	_tmp18_ = uid;
	_tmp19_ = games_grilo_cover_new (_tmp17_, (GamesUid*) _tmp18_);
	_tmp20_ = g_new0 (GamesCover*, 2 + 1);
	_tmp20_[0] = (GamesCover*) _tmp16_;
	_tmp20_[1] = (GamesCover*) _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 2;
	_tmp22_ = games_composite_cover_new (_tmp21_, 2);
	_tmp23_ = _tmp22_;
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp23_;
	_tmp24_ = g_strdup (GAMES_TURBO_GRAFX_CD_PLUGIN_CUE_MIME_TYPE);
	_tmp25_ = g_strdup (GAMES_TURBO_GRAFX_CD_PLUGIN_MIME_TYPE);
	_tmp26_ = g_new0 (gchar*, 2 + 1);
	_tmp26_[0] = _tmp24_;
	_tmp26_[1] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 2;
	_tmp28_ = games_retro_core_source_new (GAMES_TURBO_GRAFX_CD_PLUGIN_CD_PLATFORM, _tmp27_, 2);
	_tmp29_ = _tmp28_;
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	core_source = _tmp29_;
	_tmp30_ = core_source;
	_tmp31_ = uri;
	_tmp32_ = uid;
	_tmp33_ = title;
	_tmp34_ = games_retro_runner_new (_tmp30_, _tmp31_, (GamesUid*) _tmp32_, (GamesTitle*) _tmp33_);
	runner = _tmp34_;
	_tmp35_ = title;
	_tmp36_ = icon;
	_tmp37_ = cover;
	_tmp38_ = runner;
	_tmp39_ = games_generic_game_new ((GamesTitle*) _tmp35_, (GamesIcon*) _tmp36_, (GamesCover*) _tmp37_, (GamesRunner*) _tmp38_);
	result = (GamesGame*) _tmp39_;
	_g_object_unref0 (runner);
	_g_object_unref0 (core_source);
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	return result;
}


static gboolean games_turbo_grafx_cd_plugin_is_valid_disc (GamesUri* uri, GError** error) {
	gboolean result = FALSE;
	GFile* file = NULL;
	GamesUri* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* file_info = NULL;
	GFile* _tmp2_;
	GFileInfo* _tmp3_;
	gchar* mime_type = NULL;
	GFileInfo* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GFile* bin_file = NULL;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GQuark _tmp11_ = 0U;
	gchar* path = NULL;
	GFile* _tmp31_;
	gchar* _tmp32_;
	gsize* offsets = NULL;
	const gchar* _tmp33_;
	gint _tmp34_;
	gsize* _tmp35_;
	gint offsets_length1;
	gint _offsets_size_;
	gsize* _tmp36_;
	gint _tmp36__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = games_uri_to_file (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	file_info = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return _tmp4_;
	}
	_tmp5_ = file_info;
	_tmp6_ = g_file_info_get_content_type (_tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	mime_type = _tmp7_;
	_tmp8_ = mime_type;
	_tmp9_ = _tmp8_;
	_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
	if (_tmp11_ == g_quark_from_string (GAMES_TURBO_GRAFX_CD_PLUGIN_CUE_MIME_TYPE)) {
		switch (0) {
			default:
			{
				GamesCueSheet* cue = NULL;
				GFile* _tmp12_;
				GamesCueSheet* _tmp13_;
				GamesCueSheet* _tmp15_;
				guint _tmp16_;
				guint _tmp17_;
				GamesCueSheetTrackNode* track = NULL;
				GamesCueSheet* _tmp18_;
				GamesCueSheetTrackNode* _tmp19_;
				GamesCueSheetTrackNode* _tmp21_;
				GamesCueSheetTrackMode _tmp22_;
				GamesCueSheetTrackMode _tmp23_;
				gboolean _tmp24_;
				GamesCueSheetTrackNode* _tmp25_;
				GamesCueSheetFileNode* _tmp26_;
				GamesCueSheetFileNode* _tmp27_;
				GFile* _tmp28_;
				GFile* _tmp29_;
				GFile* _tmp30_;
				_tmp12_ = file;
				_tmp13_ = games_cue_sheet_new (_tmp12_, &_inner_error_);
				cue = _tmp13_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp14_ = FALSE;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return _tmp14_;
				}
				_tmp15_ = cue;
				_tmp16_ = games_cue_sheet_get_tracks_number (_tmp15_);
				_tmp17_ = _tmp16_;
				if (_tmp17_ < ((guint) 2)) {
					result = FALSE;
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return result;
				}
				_tmp18_ = cue;
				_tmp19_ = games_cue_sheet_get_track (_tmp18_, (guint) 1, &_inner_error_);
				track = _tmp19_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp20_ = FALSE;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return _tmp20_;
				}
				_tmp21_ = track;
				_tmp22_ = games_cue_sheet_track_node_get_track_mode (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = games_cue_sheet_track_mode_is_mode1 (_tmp23_);
				if (!_tmp24_) {
					result = FALSE;
					_g_object_unref0 (track);
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return result;
				}
				_tmp25_ = track;
				_tmp26_ = games_cue_sheet_track_node_get_file (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = games_cue_sheet_file_node_get_file (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = _g_object_ref0 (_tmp29_);
				_g_object_unref0 (bin_file);
				bin_file = _tmp30_;
				_g_object_unref0 (track);
				_g_object_unref0 (cue);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_object_unref0 (bin_file);
				_g_free0 (mime_type);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file);
				return result;
			}
		}
	}
	_tmp31_ = bin_file;
	_tmp32_ = g_file_get_path (_tmp31_);
	path = _tmp32_;
	_tmp33_ = path;
	_tmp35_ = games_grep_get_offsets (_tmp33_, GAMES_TURBO_GRAFX_CD_PLUGIN_CD_MAGIC_VALUE, &_tmp34_);
	offsets = _tmp35_;
	offsets_length1 = _tmp34_;
	_offsets_size_ = offsets_length1;
	_tmp36_ = offsets;
	_tmp36__length1 = offsets_length1;
	result = _tmp36__length1 > 0;
	offsets = (g_free (offsets), NULL);
	_g_free0 (path);
	_g_object_unref0 (bin_file);
	_g_free0 (mime_type);
	_g_object_unref0 (file_info);
	_g_object_unref0 (file);
	return result;
}


GamesTurboGrafxCDPlugin* games_turbo_grafx_cd_plugin_construct (GType object_type) {
	GamesTurboGrafxCDPlugin * self = NULL;
	self = (GamesTurboGrafxCDPlugin*) g_object_new (object_type, NULL);
	return self;
}


GamesTurboGrafxCDPlugin* games_turbo_grafx_cd_plugin_new (void) {
	return games_turbo_grafx_cd_plugin_construct (GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN);
}


static void games_turbo_grafx_cd_plugin_class_init (GamesTurboGrafxCDPluginClass * klass) {
	games_turbo_grafx_cd_plugin_parent_class = g_type_class_peek_parent (klass);
}


static void games_turbo_grafx_cd_plugin_games_plugin_interface_init (GamesPluginIface * iface) {
	games_turbo_grafx_cd_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_mime_types = (gchar** (*) (GamesPlugin *, int*)) games_turbo_grafx_cd_plugin_real_get_mime_types;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin *, int*)) games_turbo_grafx_cd_plugin_real_get_uri_game_factories;
}


static void games_turbo_grafx_cd_plugin_instance_init (GamesTurboGrafxCDPlugin * self) {
}


GType games_turbo_grafx_cd_plugin_get_type (void) {
	return games_turbo_grafx_cd_plugin_type_id;
}


GType games_turbo_grafx_cd_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesTurboGrafxCDPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_turbo_grafx_cd_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesTurboGrafxCDPlugin), 0, (GInstanceInitFunc) games_turbo_grafx_cd_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_turbo_grafx_cd_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_turbo_grafx_cd_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesTurboGrafxCDPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_turbo_grafx_cd_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_turbo_grafx_cd_plugin_type_id;
}


GType register_games_plugin (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	games_turbo_grafx_cd_plugin_register_type (module);
	result = GAMES_TYPE_TURBO_GRAFX_CD_PLUGIN;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



