/**
 * gnome-gmail-notifier: the gnome gmail notifier.
 * Copyright (C) 2007 Bradley A. Worley.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * 
 *     Free Software Foundation, Inc.
 *     59 Temple Place, Suite 330
 *     Boston, MA 02111-1307 USA
 **/

/*
 * include our application header.
 */
#include <main.h>

/*
 * ggn_btostr:
 *
 * Converts gboolean values to strings.
 *
 * Return value: boolean string.
 */
gchar* ggn_btostr (gboolean value) {
    /* determine the value. */
    if (value == TRUE) {
        /* return the string. */
        return "True";
    }
    else {
        /* return the string. */
        return "False";
    }
}

/*
 * ggn_strtob:
 *
 * Converts string boolean representations
 * to gboolean values.
 *
 * Return value: gboolean.
 */
gboolean ggn_strtob (gchar* value) {
    /* false if the value is NULL. */
    if (!value) {
        /* hmm... */
        return FALSE;
    }

    /* determine the value. */
    if ((g_utf8_collate (value, "TRUE") == 0) ||
        (g_utf8_collate (value, "true") == 0) ||
        (g_utf8_collate (value, "True") == 0)) {
        /* return the bool. */
        return TRUE;
    }
    else {
        /* return the bool. */
        return FALSE;
    }
}

/*
 * ggn_pixmap_file:
 *
 * Returns a newly allocated string that represents
 * a pixmap file available for use to the program.
 *
 * Return value: filename.
 */
gchar* ggn_pixmap_file (gchar* title) {
    /* generate the string. */
    return g_strdup_printf ("%s/ggn-%s.svg", PIXMAPS_DIR, title);
}

/*
 * ggn_glade_file:
 *
 * Returns a newly allocated string that represents
 * a glade xml file available for use to the program.
 *
 * Return value: filename.
 */
gchar* ggn_glade_file (gchar* title) {
    /* generate the string. */
    return g_strdup_printf ("%s/ggn-%s.glade", GLADEXML_DIR, title);
}

/*
 * ggn_client_execute:
 *
 * Executes an internet/web client application after
 * determining the URI prefix, which ultimately
 * determines the client to open.
 *
 * Return value: void.
 */
void ggn_client_execute (const gchar* link) {
    /* declare a variable. */
    gchar* prg = NULL;
    
    /* see what our URI prefix is. */
    if ((g_str_has_prefix (link, "http") == TRUE) ||
        (g_str_has_prefix (link, "file") == TRUE)) {
        /* load the web browser. */
        prg = (gchar*) gconf_client_get_string (gconf_client_get_default (),
                                                GGN_GCONF_BROWSER,
                                                NULL);
    }
    else {
        /* load the email client. */
        prg = (gchar*) gconf_client_get_string (gconf_client_get_default (),
                                                GGN_GCONF_EMAILER,
                                                NULL);
    }
    
    /* make the final string. */
    gchar* execute = g_strdup_printf (prg, link);
    
    /* run the command. */
    g_spawn_command_line_async (execute, NULL);
    
    /* free the execution string. */
    g_free (execute);
}
