/*
 *  Hearts - player.h
 *  Copyright 2006 Sander Marechal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GAME_H
#define GAME_H

#include "cards.h"
#include "player-api.h"

/* the players */
typedef struct _Player
{
	gint 	  	score_total;
	gint 	  	score_round;
	gint		point_cards;
	lua_State 	*lua_state;
	CardsHand 	*hand;
	PangoLayout *layout;
} Player;

/* functions for the player */
Player* player_new (gint direction, gint orientation, GString *script, GtkWidget *widget);
void 	player_play (Player *player, Trick *trick);
void 	player_select_cards (Player *player);
void	player_trick_end(Player *player, Trick *trick);
void	player_round_end(Player *player);
void 	player_play_card (Player *player, Card *card, Trick *trick);
void 	player_free (Player *player);

#endif
