/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* chaninfo-dialog.cpp
 *
 * Copyright (C) 2005 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "logview.h"

enum {
	LOG_COL_LINE,
	LOG_COL_TIME,
	LOG_COL_TYPE,
	LOG_COL_STR,
	N_COLUMNS
};

static GtkTreeModel *
create_model (void)
{
	GtkListStore * store;
	
	store = gtk_list_store_new (N_COLUMNS,
				    G_TYPE_INT,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_STRING);
	return GTK_TREE_MODEL (store);
}

static void
add_columns (GtkTreeView *tv)
{
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *col;
	
	renderer = gtk_cell_renderer_text_new ();
	col = gtk_tree_view_column_new_with_attributes (_("No."), renderer,
							"text", LOG_COL_LINE,
							NULL);
	g_object_set (G_OBJECT (renderer), "xalign", 1.0, NULL);
	gtk_tree_view_append_column (tv, col);

	renderer = gtk_cell_renderer_text_new ();
	col = gtk_tree_view_column_new_with_attributes (_("Time"), renderer,
							"text", LOG_COL_TIME,
							NULL);
	gtk_tree_view_append_column (tv, col);
	
	renderer = gtk_cell_renderer_text_new ();
	col = gtk_tree_view_column_new_with_attributes (_("TYPE"), renderer,
							"text", LOG_COL_TYPE,
							NULL);
	gtk_tree_view_append_column (tv, col);
	
	renderer = gtk_cell_renderer_text_new ();
	col = gtk_tree_view_column_new_with_attributes (_("Log"), renderer,
							"text", LOG_COL_STR,
							NULL);
	gtk_tree_view_append_column (tv, col);
}

void
LogView::init (GtkWidget * w)
{
	GtkTreeModel *model;
	
	treeview = GTK_TREE_VIEW (w);
	
	model = create_model ();
	gtk_tree_view_set_model (treeview, model);
	add_columns (treeview);
}

void
LogView::appendLog (LogBuffer::TYPE type, const gchar *str)
{
	GtkListStore *store;
	GtkTreeIter iter;
	struct tm * lt;
	time_t t;
	gchar timestr[40];
	static unsigned int line = 0;
	
	t = sys->getTime();
	lt = localtime ((const time_t *)&t);
	strftime (timestr, sizeof(timestr), "%m/%d %H:%M:%S", lt);
	
	store = GTK_LIST_STORE (gtk_tree_view_get_model (treeview));
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter,
			    LOG_COL_LINE, ++line,
			    LOG_COL_TIME, timestr, 
			    LOG_COL_TYPE, LogBuffer::getTypeStr(type),
			    LOG_COL_STR, str,
			    -1);
}

void
LogView::clearLog (void)
{
	GtkTreeModel *model = gtk_tree_view_get_model (treeview);
	
	gtk_list_store_clear (GTK_LIST_STORE (model));
}
