/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* trayicon.cpp
 *
 * Copyright (C) 2006 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "channel.h"

#include "utils.h"
#include "callbacks.h"

#include "gnome-peercast.h"
#include "chaninfo-dialog.h"


void
TrayIcon::play_cb (GtkWidget *item, Channel *ch)
{
	play_channel (ch);
}

void
TrayIcon::info_cb (GtkWidget *item, Channel *ch)
{
	ChaninfoDialog *cd;

	if (ch)
		cd = new ChaninfoDialog (ch, NULL);
}

void
TrayIcon::url_cb (GtkWidget *item, Channel *ch)
{
	if (ch && ! ch->info.url.isEmpty ())	
		gnome_url_show (ch->info.url.cstr(), NULL);
}

void
TrayIcon::bump_cb (GtkWidget *item, Channel *ch)
{
	if (ch) ch->bump = true;
}

void
TrayIcon::stop_cb (GtkWidget *item, Channel *ch)
{
	if (ch) ch->thread.active = false;
}

void
TrayIcon::channel_submenu (GtkWidget *parent, Channel *ch)
{
	GtkWidget *entry;
	GtkWidget *menu;
	GtkWidget *image;

	menu = gtk_menu_new ();

	/* Play */
	entry = gtk_image_menu_item_new_from_stock (GTK_STOCK_MEDIA_PLAY, NULL);
	g_signal_connect (G_OBJECT (entry), "activate",
			  G_CALLBACK(&TrayIcon::play_cb), ch);
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
	
	/* Properties */
	entry = gtk_image_menu_item_new_from_stock (GTK_STOCK_PROPERTIES, NULL);
	g_signal_connect (G_OBJECT (entry), "activate",
			  G_CALLBACK(&TrayIcon::info_cb), ch);
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
	
	/* URL */
	entry = gtk_image_menu_item_new_with_mnemonic (_("URL"));
	g_signal_connect (G_OBJECT (entry), "activate",
			  G_CALLBACK(&TrayIcon::url_cb), ch);
	image = gtk_image_new_from_stock (GTK_STOCK_HOME, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (entry), image);
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
	
	/* Bump */
	entry = gtk_image_menu_item_new_with_mnemonic (_("Bump"));
	g_signal_connect (G_OBJECT (entry), "activate",
			  G_CALLBACK(&TrayIcon::bump_cb), ch);	
	image = gtk_image_new_from_stock (GTK_STOCK_UNDO, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (entry), image);
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
	
	/* Stop */
	entry = gtk_image_menu_item_new_from_stock (GTK_STOCK_STOP, NULL);
	g_signal_connect (G_OBJECT (entry), "activate",
			  G_CALLBACK(&TrayIcon::stop_cb), ch);
	gtk_menu_shell_append (GTK_MENU_SHELL (menu), entry);
	
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (parent), menu);
}

	 
void
TrayIcon::update_channel_list (void)
{
	GtkWidget *parent;
	static GtkWidget *chan_menu = NULL;
	GtkWidget *entry;
	Channel *ch;
	gboolean none = TRUE;

	parent = getMenuItem ("tray_channels");

	if (chan_menu)
		gtk_widget_destroy (chan_menu);
	
	chan_menu = gtk_menu_new ();
	
	ch = chanMgr->channel;
	while (ch) {
		gchar idStr[64];
		ch->info.id.toStr(idStr);
		if (!ch->isActive()) {
			ch = ch->next;
			continue;
		}
		entry = gtk_menu_item_new_with_label (ch->info.name.cstr());
		gtk_menu_shell_append (GTK_MENU_SHELL (chan_menu), entry);
		channel_submenu (entry, ch);
		none = FALSE;
		ch = ch->next;
	}
	if (none) {
		entry = gtk_menu_item_new_with_label (_("None"));
		gtk_menu_shell_append (GTK_MENU_SHELL (chan_menu), entry);
		gtk_widget_set_sensitive (entry, FALSE);
	}
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (parent), chan_menu);
}

void
TrayIcon::context_menu (void)
{
	/* dynamic context menu (sub menu) */
	update_channel_list ();
	
	gtk_widget_show_all (menu);
	
	gtk_menu_popup (GTK_MENU (menu),
			NULL, NULL,
			NULL, NULL,
			3,
			gtk_get_current_event_time());
}

void
TrayIcon::embedded_cb (GtkWidget *widget, gpointer data)
{
	TrayIcon *ticon = (TrayIcon *)data;
	gtk_image_set_from_file (GTK_IMAGE (ticon->image), ICON_DIR"/peercast.png");
	ticon->count++;
}

void
TrayIcon::destroyed_cb (GtkWidget *widget, gpointer data)
{
	TrayIcon *ticon = (TrayIcon *)data;
	ticon->count--;
}

void
TrayIcon::clicked_cb (GtkWidget *button, GdkEventButton *event, gpointer data)
{
	TrayIcon *ticon = (TrayIcon *)data;
	GnomePeercastApp *app = (GnomePeercastApp *)peercastApp;
	
        if (event->type != GDK_BUTTON_PRESS)
                return;
	
        switch (event->button) {
	case 1:
		/* hide / show */
		if (GTK_WIDGET_VISIBLE(app->window)) {
			gtk_widget_hide (app->window);
		} else {
			gtk_widget_show (app->window);
		}
		break;
	case 2:
		//printf ("clicked 2\n");		
		break;
	case 3:
		/* context menu */
		ticon->context_menu ();
		break;
        }
}


/* Constructor */
TrayIcon::TrayIcon (void)
{
	GtkWidget *box;

	debug_print (1, "New object: TrayIcon");
	
	count = 0;

	xml = load_glade_xml ("gnome-peercast.glade", "tray_icon_menu");

	ticon = egg_tray_icon_new ("Gnome PeerCast");
	image = gtk_image_new ();

	/* static context menu */
	menu = getMenuItem ("tray_icon_menu");
	
	menuSignalConnect ("tray_broadcast_cb",
			   G_CALLBACK (menu_new_cb), NULL);
	
	menuSignalConnect ("tray_preferences_cb",
			   G_CALLBACK (menu_pref_cb), NULL);
	
	menuSignalConnect ("tray_webif_cb",
			   G_CALLBACK (menu_web_cb), NULL);
	
	menuSignalConnect ("tray_go_yp_cb",
			   G_CALLBACK (menu_yp_cb), NULL);
	
	menuSignalConnect ("tray_about_cb",
			   G_CALLBACK (menu_about_cb), NULL);
	
	menuSignalConnect ("tray_quit_cb",
			   G_CALLBACK (menu_quit_cb), NULL);
	/* */
	
	box = gtk_event_box_new ();

        g_signal_connect (G_OBJECT (ticon), "embedded",
			  G_CALLBACK (&TrayIcon::embedded_cb), this);
        g_signal_connect (G_OBJECT (ticon), "destroy",
			  G_CALLBACK (&TrayIcon::destroyed_cb), this);

	g_signal_connect (G_OBJECT (box), "button-press-event",
			  G_CALLBACK (&TrayIcon::clicked_cb), this);

	gtk_container_add (GTK_CONTAINER (box), image);
	gtk_container_add (GTK_CONTAINER (ticon), box);

        if (!gtk_check_version (2,4,0))
                g_object_set (G_OBJECT(box), "visible-window", FALSE, NULL);

	gtk_widget_show_all (GTK_WIDGET (ticon));
}
