/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* chaninfo-dialog.h
 *
 * Copyright (C) 2005 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */

#ifndef __CHANINFO_DIALOG_H__
#define __CHANINFO_DIALOG_H__

#include <gtk/gtktooltips.h>

class ChaninfoDialog
{
public:
	ChaninfoDialog (Channel *ch, GtkWindow *window);
	~ChaninfoDialog (void) {
		debug_print (1, "Delete object: ChaninfoDialog");
		g_object_unref (xml);
	}

	GtkWidget * getWidget (const gchar *);
	void signalConnect (const gchar *handler,
			    GCallback callback, gpointer data) {
		glade_xml_signal_connect_data (xml, handler, callback, data);
	};
	void applyMetaInfo (void);
	void setInfo (void);
	void setHitList (void);

private:
	GtkWindow *parent;
	void disableApply (void);

	GtkTreeView *treeview;

	GtkTooltips *tips;
	Channel *channel;
	GladeXML *xml;
};

#endif

