require 'util'
require 'ftools'

header = <<HEADER_END
/************************************************

  @basename@ -

  $Author: klamath $
  $Date: 2002/03/13 01:40:45 $

  Copyright (C) 1998-2002 Yukihiro Matsumoto,
                          Daisuke Kanda,
                          Hiroshi Igarashi
                          Neil Conway
************************************************/

HEADER_END
header_header = <<HEADER_HEADER_END
/************************************************
HEADER_HEADER_END

pattern = /^#{Regexp.quote(header_header)}/op

for file_name in ARGV
  buf = File.open(file_name).read
  if pattern === buf
    Kernel._warning("#{file_name} already has the header.")
  else
    basename = File.basename(file_name)
    a_header = header.gsub("@basename@", basename)
    File.copy(file_name, file_name + ".bak", true)
    File.open(file_name, "w") do |file|
      file.print(a_header + buf)
    end
    Kernel._warning("The header was addded to #{file_name}.")
  end  
end
