import gtk, gobject, gtk.glade
import gnome, gnome.ui
import os, os.path
from gtk_goodies import gconf_wrapper, Undo, dialog_extras, image_extras
import gsudoku, sudoku, saver, sudoku_maker, printing, sudoku_generator_gui
import game_selector
import time, threading
from gettext import gettext as _
from gettext import ngettext
from defaults import *
from timer import ActiveTimer


icon_factory = gtk.IconFactory()
STOCK_PIXBUFS = {}
for filename,stock_id in [('Footprints.svg','tracks'),]:
    pb = gtk.gdk.pixbuf_new_from_file(os.path.join(IMAGE_DIR,filename))
    STOCK_PIXBUFS[stock_id]=pb
    iconset = gtk.IconSet(pb)
    icon_factory.add(stock_id,iconset)
    icon_factory.add_default()

gtk.stock_add([('tracks',
                _('Track moves'),
                0,0,""),])

class UI (gconf_wrapper.GConfWrapper):
    ui='''<ui>
    <menubar name="MenuBar">
      <menu name="File" action="File">
        <menuitem action="New"/>
        <menuitem action="Open"/>
        <menuitem action="ByHand"/>
        <separator/>
        <menuitem action="Print"/>
        <menuitem action="PrintMany"/>
        <separator/>
        <!--<menuitem action="Save"/>-->
        <separator/>
        <menuitem action="Generator"/>
        <menuitem action="BackgroundGenerator"/>
        <separator/>
        <menuitem action="Close"/>
        <!--<menuitem action="Quit"/>-->
      </menu>
      <menu action="Edit">
        <menuitem action="Undo"/>
        <menuitem action="Redo"/>
        <separator/>
        <menuitem action="Clear"/>
      </menu>
      <menu action="View">
        <menuitem action="ZoomIn"/>
        <menuitem action="ZoomOut"/>
        <separator/>
        <menuitem action="ZoomOnResize"/>
        <separator/>
        <menuitem action="ToggleToolbar"/>
        <separator/>
        <menuitem action="HighScores"/>
      </menu>
      <menu action="Hints">
         <menuitem action="ShowPossible"/>
          <menuitem action="Autofill"/>
          <separator/>
          <menuitem action="AlwaysShowPossible"/>
          <menuitem action="ShowImpossibleImplications"/>
        <separator/>
        <menuitem action="Tracker"/>
        <separator/>
        <menuitem action="PuzzleInfo"/>
       </menu>
       <menu action="Help">
         <menuitem action="About"/>
         <menuitem action="ShowFaq"/>
       </menu>
     </menubar>
     <toolbar name="Toolbar">
      <!--<toolitem action="Quit"/>-->
      <toolitem action="New"/>
      <toolitem action="Open"/>
      <toolitem action="Print"/>
      <!--<toolitem action="Save"/>-->
      <toolitem action="Clear"/>
      <separator/>
      <toolitem action="Undo"/>
      <toolitem action="Redo"/>
      <separator/>
      <toolitem action="ShowPossible"/>
      <!--<toolitem action="AlwaysShowPossible"/>-->
      <toolitem action="Autofill"/>
      <toolitem action="Tracker"/>
      <separator/>
      <toolitem action="ZoomIn"/>
      <toolitem action="ZoomOut"/>
     </toolbar>
     </ui>'''

    initial_prefs = {'group_size':9,
                     'font_zoom':0,
                     'zoom_on_resize':1,
                     'always_show_hints':0,
                     'player':os.environ.get('USERNAME',''),
                     'difficulty':0.0,
                     'minimum_number_of_new_puzzles':MIN_NEW_PUZZLES,
                     }

    def __init__ (self):
        self.w = gtk.Window()
        self.timer = ActiveTimer(self.w)
        self.won = False
        gconf_wrapper.GConfWrapper.__init__(self,
                                            gconf_wrapper.GConf('gnome-sudoku')
                                            )
        self.initialize_prefs()
        self.player = self.gconf['player']

        self.cleared = [] # used for Undo memory

        gnome.program_init(APPNAME,VERSION)
        self.w.connect('destroy',self.quit_cb)
        self.vb = gtk.VBox()
        self.uimanager = gtk.UIManager()
        self.gsd = gsudoku.SudokuGridDisplay()
        self.gsd.connect('puzzle-finished',self.you_win_callback)
        #self.gsd = gsudoku.SudokuGridDisplay()	 
        self.main_actions = gtk.ActionGroup('MainActions')        
        self.main_actions.add_actions([
            ('File',None,'_File'),
            ('New',gtk.STOCK_NEW,None,
             '<Control>n','Generate new game',self.new_cb),
            ('Print',gtk.STOCK_PRINT,None,
             None,'Print current game',self.print_game),
            ('PrintMany',gtk.STOCK_PRINT,_('Print _Multiple Sudokus'),
             None,'Print many sudokus at a time.',self.print_multiple_games),
            #('Quit',gtk.STOCK_QUIT,None,'<Control>q',
            # 'Quit Sudoku game',self.quit_cb),
            ('Close',gtk.STOCK_CLOSE,None,'<Control>w',
             'Close Sudoku (save game for later)',self.quit_cb),
            #('Save',gtk.STOCK_SAVE,_('_Save'),
            # '<Control>s','Save game to play later.',
            # self.save_game),
            ('ByHand',gtk.STOCK_EDIT,_('_Enter custom game'),
             None,'Enter new puzzle by hand (use this to copy a puzzle from another source).',
             self.enter_game_by_hand),
            ('Open',gtk.STOCK_OPEN,_('_Resume old game'),
             '<Control>r','Resume a previous saved game.',
             self.open_game),
            ('Hints',None,'H_ints'),
            ('View',None,'_View'),
            ('ShowPossible',gtk.STOCK_HELP,'_Hint',
             '<Control>i',
             'Show which numbers could go in the current square.',
             self.show_hint_cb),
            ('Autofill',gtk.STOCK_APPLY,'_Fill','<Control>a','Automatically fill in all squares for which there is only one valid value.',
             self.auto_fill_cb),
            ('ZoomIn',gtk.STOCK_ZOOM_IN,'_Increase size',
             '<Control>plus','Increase the size of numbers and squares',
             self.zoom_in_cb),
            ('ZoomOut',gtk.STOCK_ZOOM_OUT,'_Decrease size',
             '<Control>minus','Decrease the size of numbers and squares.',
             self.zoom_out_cb),
            ('PuzzleInfo',gtk.STOCK_ABOUT,'Puzzle _Statistics',
             None,'Show statistics about current puzzle',
             self.show_info_cb),
            ('Help',None,'_Help',
             None,None,None),
            ('About',gtk.STOCK_ABOUT,None,
             None,None,self.show_about),
            ('ShowFaq',gtk.STOCK_HELP,None,
             None,None,self.show_faq),
            ('HighScores',None,_('High _Scores'),
             None,'Show high scores or replay old games.',
             self.show_high_scores_cb),
            ])
        #if AUTO_SAVE:
        #    self.main_actions.get_action('Quit').set_visible(False)
        #    self.main_actions.get_action('Save').set_visible(False)
        # else:
        #    self.main_actions.get_action('Close').set_visible(False)
        self.main_actions.add_toggle_actions([
            ('AlwaysShowPossible',
             None,
             '_Always show hint',
             None,
             'Always show possible numbers in a square',
             self.auto_hint_cb),
            ('ShowImpossibleImplications',
             None,
             'Warn about _unfillable squares',
             None,
             'Warn about squares made unfillable by a move',
             self.impossible_implication_cb),
            ('Tracker','tracks','_Track additions',
             '<Control>T',
             'Mark new additions in a separate color so you can keep track of them.',
             self.tracker_toggle_cb,False),
            ('ZoomOnResize',None,'_Adjust size of grid when resizing window',
             None,'Automatically change the size of numbers and squares to fit the window.',
             ),
            ('ToggleToolbar',None,'Show _Toolbar',None,None,self.toggle_toolbar_cb,True),
            ('BackgroundGenerator',None,'Generate new puzzles _while you play',
             None,'Generate new puzzles in the background while you play. This will automatically pause when the game goes into the background.',
             self.toggle_generator_cb, True),
            ])
        
        self.edit_actions = gtk.ActionGroup('EditActions')
        self.edit_actions.add_actions(
            [('Edit',None,'_Edit'),
             ('Undo',gtk.STOCK_UNDO,'_Undo','<Control>z','Undo last action'),
             ('Redo',gtk.STOCK_REDO,'_Redo','<Control>y','Redo last action'),
             ('Clear',gtk.STOCK_CLEAR,'_Clear','<Control>b',"Clear entries you've filled in",self.clear_cb),
             # Trackers...
             ('Tracker%s',None,'No Tracker','<Control>0',None,lambda *args: self.set_tracker(-1)),
             ('Generator',None,'_Generate new puzzles',None,'Generate new puzzles.',
              self.generate_puzzle_gui,),
             ])
        self.edit_actions.add_actions(
            [('Tracker%s'%n,None,'Tracker _%s'%n,'<Control>%s'%n,None,lambda *args: self.set_tracker(n-1)) for
             n in range(1,9)])
        self.uimanager.insert_action_group(self.main_actions,0)
        self.uimanager.insert_action_group(self.edit_actions,0)
        self.uimanager.add_ui_from_string(self.ui)

        # Set up our UNDO stuff
        undo_widg = self.edit_actions.get_action('Undo')
        redo_widg = self.edit_actions.get_action('Redo')
        self.history = Undo.UndoHistoryList(undo_widg,redo_widg)
        for e in self.gsd.__entries__.values():
            Undo.UndoableEntry(e,self.history)
        # add the accelerator group to our toplevel window
        self.w.add_accel_group(self.uimanager.get_accel_group())
        mb = self.uimanager.get_widget('/MenuBar')
        mb.show()
        self.vb.pack_start(mb,False)
        self.tb = self.uimanager.get_widget('/Toolbar')
        #self.tb.show()
        self.vb.pack_start(self.tb,False)
        self.main_area = gtk.HBox()
        #align = gtk.Alignment()
        #align.add(self.main_area)
        #align.set_padding(18,12,0,18)
        self.vb.pack_start(self.main_area,True,padding=18)
        self.main_area.pack_start(self.gsd,True,padding=18)
        self.hint_label = gtk.Label()
        self.hint_label.show()
        align = gtk.Alignment()
        align.set_padding(18,12,12,18)
        align.add(self.hint_label)
        align.show()
        self.vb.add(align)
        self.main_actions.set_visible(True)
        self.game_box = gtk.VBox()
        self.main_area.show()
        self.vb.show()
        # Set up area for by-hand editing...
        self.by_hand_label = gtk.Label()
        self.by_hand_label.set_alignment(0,0)
        self.by_hand_label.set_markup('<i>%s</i>'%_('Entering custom grid...'))
        self.game_box.pack_start(self.by_hand_label,False,)#padding=12)        
        self.by_hand_buttonbox = gtk.HButtonBox()
        self.by_hand_buttonbox.set_spacing(12)
        self.by_hand_save_button = gtk.Button('_Play game')
        self.by_hand_save_button.connect('clicked',self.save_handmade_grid)
        self.by_hand_cancel_button = gtk.Button(stock=gtk.STOCK_CANCEL)
        self.by_hand_cancel_button.connect('clicked',self.cancel_handmade_grid)
        self.by_hand_buttonbox.add(self.by_hand_cancel_button)
        self.by_hand_buttonbox.add(self.by_hand_save_button)
        self.game_box.pack_start(self.by_hand_buttonbox,False,padding=18)
        self.game_box.show()
        self.by_hand_widgets = [self.by_hand_label,self.by_hand_buttonbox]
        #self.main_area.add(galign)
        #self.main_area.add(self.game_box)
        #galign = gtk.Alignment()
        #galign.add(self.game_box)
        #galign.set_padding(18,12,12,18)
        self.main_area.pack_start(self.game_box,True,padding=12)
        #self.main_area.pack_start(galign,True,padding=12)
        # Set up trackers
        self.trackers = {}
        self.setup_tracker_interface()
        #self.game_box.pack_start(self.add_tracker_button,False)
        self.w.add(self.vb)
        self.worker_connections=[]
        mb.show()

        # sync up toggles with gconf values...
        map(lambda tpl: self.gconf_wrap_toggle(*tpl),
            [('always_show_hints',
              self.main_actions.get_action('AlwaysShowPossible')),
             ('show_impossible_implications',
              self.main_actions.get_action('ShowImpossibleImplications')),
             ('zoom_on_resize',
              self.main_actions.get_action('ZoomOnResize')),
             ('generate_puzzles_in_background',
              self.main_actions.get_action('BackgroundGenerator')),
             ('show_toolbar',
              self.main_actions.get_action('ToggleToolbar')),
             ('show_tracker',
              self.main_actions.get_action('Tracker')),
             ])
        
        # set font-size to user-set value...
        self.zoom = self.gconf['font_zoom']
        if self.zoom:
            self.gsd.change_font_size(multiplier=self.zoom)
        else:
            self.zoom = 1
        self.timer.start_timing()

        # setup sudoku maker...
        self.sudoku_maker = sudoku_maker.SudokuMaker()
        self.sudoku_tracker = sudoku_maker.SudokuTracker(self.sudoku_maker)

        if not self.sudoku_tracker.playing:
            self.main_actions.get_action('Open').set_sensitive(False)
        else:
            self.main_actions.get_action('Open').set_sensitive(True)

        if not self.sudoku_tracker.finished:
            self.main_actions.get_action('HighScores').set_sensitive(False)
        # auto-load
        try:
            game = self.gconf['current_game']                
        except:
            self.gconf['current_game']=""
            game = ""
        if game:
            try:
                self.sudoku_tracker.open_game(self, game)
            except:
                #print 'We appear to have lost ',game
                try:
                    self.gsd.load_game(game)
                except:
                    puz,d=self.sudoku_tracker.get_new_puzzle(self.gconf['difficulty'])
        else:
            # select an easy puzzle...
            puz,d=self.sudoku_tracker.get_new_puzzle(self.gconf['difficulty'])
            print 'Default to ',puz
            self.gsd.change_grid(puz,
                                 9)
        # generate puzzles while our use is working...
        if self.gconf['generate_puzzles_in_background']:
            gobject.timeout_add(1000,lambda *args: self.start_worker_thread() and True)
        self.gsd.show()
        self.w.show()
        # widgets we want hidden...
        # self.tracker_ui.hide()
        # for widg in self.by_hand_widgets: widg.hide()
        # Set up auto-resizing of font
        self.just_resized=False        
        self.resizing = False
        rect = self.w.window.get_frame_extents()
        self.cur_size = (rect.width,rect.height)
        self.w.connect('size-allocate',self.allocate_cb)

    def start_worker_thread (self, *args):
        n_new_puzzles = len(self.sudoku_tracker.list_new_puzzles())
        if n_new_puzzles < self.gconf['minimum_number_of_new_puzzles']:
            self.worker = threading.Thread(target=lambda *args: self.sudoku_maker.work(limit=5))
            self.worker_connections = [
                self.timer.connect('timing-started',self.sudoku_maker.resume),
                self.timer.connect('timing-stopped',self.sudoku_maker.pause)
                ]
            self.worker.start()
        else:
            print 'We already have ',n_new_puzzles,'!'

    def stop_worker_thread (self, *args):
        if hasattr(self,'worker'):
            self.sudoku_maker.stop()
            for c in self.worker_connections:
                self.timer.disconnect(c)

    def you_win_callback (self,grid):
        self.won = True
        print 'you_win_callback!'
        self.gconf['difficulty']=self.gconf['difficulty']+0.1
        self.timer.finish_timing()
        self.sudoku_tracker.finish_game(self)
        #time_string = "%s (%s active)"%(self.timer.total_time_string(),
        #                                self.timer.active_time_string()
        #                                )
        #sublabel = _("You completed the puzzle in %s")%time_string
        #sublabel += "\n"
        #sublabel += ngettext("You got %s hint","You got %s hints",self.gsd.hints)%self.gsd.hints
        #sublabel += "\n"
        #if self.gsd.impossible_hints:
        #    sublabel += ngettext("You had %s impossibility pointed out.",
        #                         "You had %s impossibilities pointed out.",
        #                         self.gsd.impossible_hints)%self.gsd.impossible_hints
        #if self.gsd.auto_fills:
        #    sublabel += ngettext("You used the auto-fill %s time",
        #                         "You used the auto-fill %s times",
        #                         self.gsd.auto_fills)%self.gsd.auto_fills
        #dialog_extras.show_message("You win!",label="You win!",
        #                           icon=os.path.join(IMAGE_DIR,'winner2.png'),
        #                           sublabel=sublabel
        #                           )
        hs = game_selector.HighScores(self.sudoku_tracker)
        hs.highlight_newest=True
        hs.run_dialog()
        self.main_actions.get_action('HighScores').set_sensitive(True)
        self.gsd.blank_grid()
        self.stop_game()

    def allocate_cb (self, window, rectangle):
        #print 'previous size: ',self.cur_size
        #print 'configure event: ',rect,rect.width, rect.height
        if self.gconf['zoom_on_resize'] and not self.just_resized:
            rect = self.w.window.get_frame_extents()
            #print self.cur_size,'->',rect.width,rect.height
            if rect.width/self.cur_size[0] < rect.height/self.cur_size[1]:
                ratio = float(rect.width) / self.cur_size[0]
            else:
                ratio = float(rect.height) / self.cur_size[1]
            if ratio!=1:
                self.cur_size = (rect.width, rect.height)
                print 'changing font size ->',ratio
                self.gsd.change_font_size(multiplier=ratio)
            self.just_resized=True
            gobject.timeout_add(200,lambda *args: setattr(self,'just_resized',False))

            
    def initialize_prefs (self):
        for k,v in self.initial_prefs.items():
            try:
                self.gconf[k]
            except:
                self.gconf[k]=v

    def new_cb (self,*args):        
        gs = game_selector.NewGameSelector(self.sudoku_tracker)
        gs.difficulty = self.gconf['difficulty']
        ret =  gs.run_dialog()
        if ret:
            puz,d = ret
            self.gconf['difficulty']=d.value
            self.stop_game()
            self.gsd.change_grid(puz,9)

    def stop_game (self):
        if self.gsd.grid and self.gsd.grid.is_changed():
            self.sudoku_tracker.save_game(self)
            self.main_actions.get_action('Open').set_sensitive(True)
        self.tracker_ui.reset()
        self.timer.reset_timer()
        self.timer.start_timing()
        self.won = False

    def quit_cb (self, *args):
        #if AUTO_SAVE and not self.won: self.gconf['current_game']=self.save_game()
        if self.won:
            self.gconf['current_game']=''
        if not self.won:
            if not self.gsd.grid:
                self.gconf['current_game']=''
            elif self.gsd.grid.is_changed():
                print 'Saving game!'
                self.gconf['current_game']=self.sudoku_tracker.save_game(self)
            else:
                self.gconf['current_game']=self.gsd.grid.to_string()
        self.w.hide()
        self.stop_worker_thread()
        self.sudoku_tracker.save()
        gtk.main_quit()

    def enter_game_by_hand (self, *args):
        self.stop_game()
        self.gsd.change_grid(sudoku.InteractiveSudoku(),9)
        for w in self.by_hand_widgets: w.show_all()
        
    def save_handmade_grid (self, *args):
        for w in self.by_hand_widgets: w.hide()
        # this should make our active grid into our virgin grid
        self.won = False
        self.gsd.change_grid(self.gsd.grid,9)
        self.sudoku_maker.names[self.gsd.grid.to_string()]=self.sudoku_maker.get_puzzle_name('Custom Puzzle')

    def cancel_handmade_grid (self, *args):
        for w in self.by_hand_widgets: w.hide()

    def open_game (self, *args):
        #game_file = dialog_extras.getFileOpen(_("Load saved game"),
        #                        default_file=os.path.join(DATA_DIR,'games/')
        #                        )        
        #saver.unpickle_game(self, game_file)
        #ifi = file(game_file,'r')
        #self.gsd.load_game(ifi.read())
        #ifi.close()
        puzzl=game_selector.OldGameSelector(self.sudoku_tracker).run_dialog()
        if puzzl:
            self.stop_game()
            saver.open_game(self,puzzl)

    def save_game (self, *args):
        save_to_dir=os.path.join(DATA_DIR,'games/')
        if not os.path.exists(save_to_dir):
            os.makedirs(save_to_dir)
        game_number = 1
        while os.path.exists(
            os.path.join(save_to_dir,"game%s"%game_number)
            ):
            game_number+=1
        game_loc = os.path.join(save_to_dir,
                             "game%s"%game_number)
        saver.pickle_game(self, game_loc)
        return game_loc
    
    def zoom_in_cb (self,*args):
        self.just_resized=True
        gobject.timeout_add(200,lambda *args: setattr(self,'just_resized',False))
        self.gsd.change_font_size(multiplier=1.1)
        self.zoom = self.zoom * 1.1        

    def zoom_out_cb (self,*args):
        self.just_resized=True
        gobject.timeout_add(100,lambda *args: setattr(self,'just_resized',False))
        self.gsd.change_font_size(multiplier=0.9)
        self.zoom = self.zoom * 0.9

    def clear_cb (self,*args):        
        clearer=Undo.UndoableObject(
            lambda *args: self.cleared.append(self.gsd.reset_grid()), #action
            lambda *args: [self.gsd.add(*entry) for entry in self.cleared.pop()], #inverse
            self.history #history
            )
        clearer.perform()

    def show_hint_cb (self, *args):
        print 'show_hint_cb'
        self.gsd.show_hint(self.hint_label)

    def auto_hint_cb (self, action):
        if action.get_active(): self.gsd.label = self.hint_label
        else: self.gsd.label = None

    def impossible_implication_cb (self, action):
        if action.get_active():
            self.gsd.show_impossible_implications = True
        else:
            self.gsd.show_impossible_implications = False

    def auto_fill_cb (self, *args):
        if not hasattr(self,'autofilled'): self.autofilled=[]
        if not hasattr(self,'autofiller'):
            self.autofiller = Undo.UndoableObject(
                lambda *args: self.autofilled.append(self.gsd.auto_fill()),
                lambda *args: [self.gsd.remove(entry[0],entry[1],do_removal=True) for entry in self.autofilled.pop()],
                self.history
                )
        self.autofiller.perform()
        print 'AUTOFILLED',self.autofilled[-1]

    def setup_tracker_interface (self):
        self.tracker_ui = TrackerBox(self)
        self.tracker_ui.show_all()
        self.tracker_ui.hide()
        self.game_box.add(self.tracker_ui)

    def set_tracker (self, n):
        #print 'Set tracker ',n
        if self.gsd.trackers.has_key(n):
            self.tracker_ui.select_tracker(n)
            e = self.gsd.get_focused_entry()
            if e:
                if n==-1:
                    for tid in self.gsd.trackers_for_point(e.x,e.y):
                        self.gsd.remove_tracker(e.x,e.y,tid)
                else:
                    self.gsd.add_tracker(e.x,e.y,n)
        else:
            print 'No tracker ',n,'yet'
        
    def tracker_toggle_cb (self, widg):
        if widg.get_active():
            #if len(self.tracker_ui.tracker_model)<=1:
            #    self.tracker_ui.add_tracker()
            self.tracker_ui.show_all()
        else:
            self.tracker_ui.hide()

    def toggle_toolbar_cb (self, widg):
        if widg.get_active(): self.tb.show()
        else: self.tb.hide()

    def show_info_cb (self, *args):
        puzzle = self.gsd.grid.virgin.to_string()
        diff = self.sudoku_tracker.get_difficulty(puzzle)
        information = _("Calculated difficulty: ")
        information += diff.value_string()
        information += " (%1.2f)"%diff.value
        information += "\n"
        information += _("Number of moves instantly fillable by elimination: ")
        information += str(int(diff.instant_elimination_fillable))
        information += "\n"
        information += _("Number of moves instantly fillable by filling: ")
        information += str(int(diff.instant_fill_fillable))
        information += "\n"
        information += _("Number of guesses required to solve: ")
        information += str(len(diff.guesses))
        if not self.sudoku_tracker.sudoku_maker.names.has_key(puzzle):
            self.sudoku_tracker.sudoku_maker.names[puzzle]=self.sudoku_tracker.sudoku_maker.get_puzzle_name(
                'Puzzle')
        name = self.sudoku_tracker.sudoku_maker.names[puzzle]
        dialog_extras.show_message(parent=self.w,
                                   title=_("Puzzle Information"),
                                   label=_("Statistics for %s")%name,
                                   sublabel=information)
        

    def toggle_generator_cb (self, toggle):
        if toggle.get_active():
            self.start_worker_thread()
        else:
            self.stop_worker_thread()

    def show_high_scores_cb (self, *args):
        hs=game_selector.HighScores(self.sudoku_tracker)
        replay_game = hs.run_dialog()
        if replay_game:
            self.stop_game()
            self.gsd.change_grid(replay_game,9)

    def show_about (self, *args):
        about = gnome.ui.About(
            APPNAME,#appname
            VERSION,#version
            COPYRIGHT,#copyright
            DESCRIPTION,#description
            AUTHORS,#authors
            None,#comments
            None,#translator
            gtk.gdk.pixbuf_new_from_file(os.path.join(IMAGE_DIR,'sudoku.svg'))#logo
            )
        try:
            about.set_website('http://gnome-sudoku.sourceforge.net')
        except AttributeError: pass
        about.show()

    def show_faq (self, *args):
        dialog_extras.show_faq(faq_file=os.path.join(BASE_DIR,'FAQ'))

    def print_game (self, *args):
        printing.print_sudokus([self.gsd])

    def print_multiple_games (self, *args):
        gp=game_selector.GamePrinter(self.sudoku_tracker, self.gconf)
        gp.run_dialog()

    def generate_puzzle_gui (self, *args):
        sudoku_generator_gui.GameGenerator(self,self.gconf)

class TrackerBox (gtk.VBox):

    def __init__ (self, main_ui):
        
        gtk.VBox.__init__(self)
        self.glade = gtk.glade.XML(os.path.join(GLADE_DIR,'tracker.glade'))
        self.main_ui = main_ui
        self.vb = self.glade.get_widget('vbox1')
        #print 'widget ',self.vb
        self.vb.unparent()
        self.add(self.vb)
        self.setup_actions()
        self.setup_tree()
        self.show_all()

    def reset (self):
        
        for tree in self.tracker_model:
            if tree[0]>-1:
                self.tracker_model.remove(tree.iter)

    def setup_tree (self):
        self.tracker_tree = self.glade.get_widget('treeview1')
        self.tracker_model = gtk.ListStore(int,gtk.gdk.Pixbuf,str)
        self.tracker_tree.set_model(self.tracker_model)
        col1 = gtk.TreeViewColumn("",gtk.CellRendererPixbuf(),pixbuf=1)
        col2 = gtk.TreeViewColumn("",gtk.CellRendererText(),text=2)
        self.tracker_tree.append_column(col2)
        self.tracker_tree.append_column(col1)
        # Our initial row...
        self.tracker_model.append([-1,None,'No Tracker'])
        self.tracker_tree.get_selection().connect('changed',self.selection_changed_cb)

    def setup_actions (self):
        self.tracker_actions = gtk.ActionGroup('tracker_actions')        
        self.tracker_actions.add_actions(
            [('Clear',
              gtk.STOCK_CLEAR,
              _('_Clear Tracker'),
              None,_('Clear all moves tracked by selected tracker.'),
              self.clear_cb
              ),
             ('Keep',None,
              _('_Clear Others'),
              None,
              _('Clear all moves not tracked by selected tracker.'),
              self.keep_cb),
             ]
            )
        for action,widget_name in [('Clear','ClearTrackerButton'),
                                   ('Keep','KeepTrackerButton'),
                                   ]:
            a=self.tracker_actions.get_action(action)
            a.connect_proxy(self.glade.get_widget(widget_name))
        self.glade.get_widget('AddTrackerButton').connect('clicked',
                                                          self.add_tracker)

    def add_tracker (self,*args):
        #print 'Adding tracker!'
        tracker_id = self.main_ui.gsd.create_tracker()
        #print 'tracker_id = ',tracker_id
        pb=image_extras.pixbuf_transform_color(
            STOCK_PIXBUFS['tracks'],
            '#000000',
            self.main_ui.gsd.get_tracker_color(tracker_id),
            )
        # select our new tracker
        self.tracker_tree.get_selection().select_iter(
            self.tracker_model.append([tracker_id,
                                  pb,
                                  "Tracker %s"%(tracker_id+1)]
                                  )
            )
        
    def select_tracker (self, tracker_id):
        for row in self.tracker_model:
            if row[0]==tracker_id:
                self.tracker_tree.get_selection().select_iter(row.iter)

    def selection_changed_cb (self, selection):
        mod,itr = selection.get_selected()
        if itr: selected_tracker_id = mod.get_value(itr,0)
        else: selected_tracker_id=-1
        # This should be cheap since we don't expect many trackers...
        # We cycle through each row and toggle it off if it's not
        # selected; on if it is selected
        for row in self.tracker_model:
            tid = row[0]
            if tid != -1: # -1 == no tracker
                self.main_ui.gsd.toggle_tracker(tid,tid==selected_tracker_id)
        self.tracker_actions.set_sensitive(selected_tracker_id != -1)

    def clear_cb (self, action):
        mod,itr=self.tracker_tree.get_selection().get_selected()
        selected_tracker_id=mod.get_value(itr,0)
        self.tracker_delete_tracks(selected_tracker_id)

    def keep_cb (self, action):
        mod,itr=self.tracker_tree.get_selection().get_selected()
        selected_tracker_id=mod.get_value(itr,0)
        self.tracker_keep_tracks(selected_tracker_id)

    def tracker_delete_tracks (self, tracker_id):
        clearer=Undo.UndoableObject(
            lambda *args: self.main_ui.cleared.append(self.main_ui.gsd.delete_by_tracker(tracker_id)),
            lambda *args: [self.main_ui.gsd.add(*entry) for entry in self.main_ui.cleared.pop()],
            self.main_ui.history)
        clearer.perform()

    def tracker_keep_tracks (self, tracker_id):
        clearer=Undo.UndoableObject(
            lambda *args: self.main_ui.cleared.append(self.main_ui.gsd.delete_except_for_tracker(tracker_id)),
            lambda *args: [self.main_ui.gsd.add(*entry) for entry in self.main_ui.cleared.pop()],
            self.main_ui.history)
        clearer.perform()


class GamesTracker (sudoku_maker.SudokuTracker):
    def __init__ (self, sudoku_maker):
        SudokuTracker.__init__(self, sudoku_maker)

    def build_model (self):
        # puzzle / difficulty / % completed / game started / game finished
        self.model = gtk.TreeModel(str, str )
        

def start_game ():
    u = UI()
    gobject.threads_init()
    try:
        gtk.main()
    except KeyboardInterrupt:
        # properly quit on a keyboard interrupt...
        u.quit_cb()

    
        
        
if __name__ == '__main__':
    start_game()
