/* GnomeICU
 * Copyright (C) 1998-2004 Jeremy Wise, Olivier Crete
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Support for freedesktop.org Notification Area
 */

/*
 * Copyright (c) 2003 Daniel Romberg
 */

#include "common.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "util.h"
#include "icons.h"
#include "tray.h"
#include "eggtrayicon.h"
#include "msg.h"
#include "showlist.h"

#include <gtk/gtk.h>

EggTrayIcon *tray_icon;
GtkWidget *tray_icon_image;
GtkTooltips *tray_icon_tooltip;

static gboolean tray_clicked (GtkWidget *event_box, GdkEventButton *event,
                              gpointer d);
static gboolean tray_menu (GtkWidget *event_box, GdkEventButton *event,
                           gpointer d);
static void tray_destroyed(GtkObject *object, gpointer d);

gboolean
tray_init (void)
{
	GtkWidget *eventbox;

	tray_icon = egg_tray_icon_new ("GnomeICU");
	tray_icon_image = gtk_image_new_from_pixbuf (get_pixbuf_for_status (Current_Status));
	gtk_widget_show (tray_icon_image);

	eventbox = gtk_event_box_new ();
	gtk_widget_show (eventbox);
	gtk_container_add (GTK_CONTAINER (eventbox), tray_icon_image);
	gtk_container_add (GTK_CONTAINER (tray_icon), eventbox);

	g_signal_connect (G_OBJECT (eventbox), "button_press_event",
	                  G_CALLBACK (tray_clicked), NULL );

	g_signal_connect (G_OBJECT(tray_icon), "destroy",
			  G_CALLBACK (tray_destroyed), NULL);

	gtk_widget_show (GTK_WIDGET (tray_icon));

	tray_icon_tooltip = gtk_tooltips_new ();

	return FALSE;
}

void
tray_update (gboolean flash)
{
  GSList *ginfo;
  GSList *contact;
  int num_messages = 0;
  gchar *nextmsg = NULL;
  gint type = 0;
  gchar *tooltips_str;
  gint online_user = 0;

	if (!tray_icon)
	  return;

	contact = Contacts;

	while( contact != NULL )
	{
		guchar len = g_slist_length( kontakt->stored_messages );
		if( len ) {
			if( nextmsg == NULL ) {
				nextmsg = g_strdup_printf( _("Next message from %s"), kontakt->nick );
				type = ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type;
			}
			num_messages += len;
		}
		contact = contact->next;
	}

	if( num_messages ) {
		if( flash )
			gtk_image_set_from_pixbuf (GTK_IMAGE(tray_icon_image),
			                get_pixbuf_for_message( type ));
		else
			gtk_image_set_from_pixbuf (GTK_IMAGE(tray_icon_image),
		       	                icon_blank_pixbuf );
	} else {
		gtk_image_set_from_pixbuf (GTK_IMAGE (tray_icon_image),
					   get_pixbuf_for_status (Current_Status));
	}
	gtk_widget_show (tray_icon_image);

        for (ginfo = Groups; ginfo != NULL; ginfo = ginfo->next)
          online_user += ((GroupInfo *)ginfo->data)->online_user;

	if (nextmsg != NULL)
	  tooltips_str = g_strdup_printf ("%s\n%d %s\n%d %s\n%s",
					  get_status_str (Current_Status),
					  online_user,
					  n_("contact online", 
					     "contacts online", 
					     online_user),
					  num_messages, 
					  n_("new message",
					     "new messages",
					     num_messages),
					  nextmsg );
	else
	  tooltips_str = g_strdup_printf("%s\n%d %s",
					 get_status_str (Current_Status),
					 online_user,
					 n_("contact online", 
					    "contacts online",
					    online_user));


	gtk_tooltips_set_tip (tray_icon_tooltip,
	                      GTK_WIDGET (tray_icon),
	                      tooltips_str,
	                      NULL);
	g_free(tooltips_str);
}

gboolean
tray_clicked (GtkWidget *event_box, GdkEventButton *event, gpointer d)
{
  GSList *contact;
  gboolean pending_msg = FALSE;
  gboolean double_clicked = FALSE;

  /* Right now there is no HIG on how we should handle 'clicking' event
     for the notification.
     
     Current behavior:
      - left click: show/hide GnomeICU window, or open pending event window
      - right click: show the status menu
  */

  if (event->button == 1) {
    /* left click (1) */
    double_clicked == TRUE;
  } else if (event->button == 3) {
    /* right click (3) */
    return tray_menu (event_box, event, d);
  } else
    return FALSE;

  /* only reach here when double click occured */

  for (contact = Contacts; contact != NULL; contact = contact->next) {
    guchar len = g_slist_length (kontakt->stored_messages);

    if (len) {
      pending_msg = TRUE;
      break;
    }
  }

  if (pending_msg) {
    show_contact_message (kontakt);
  } else {
    if (GTK_WIDGET_VISIBLE (MainData->window)) {
      /* window visible, hide it */
      gtk_window_get_position (GTK_WINDOW (MainData->window),
			       &MainData->x, &MainData->y);
      gtk_widget_hide (MainData->window);
      MainData->hidden = TRUE;
    } else {
      /* unhide */
      gtk_window_move (GTK_WINDOW (MainData->window), MainData->x, MainData->y);
      gtk_window_present (GTK_WINDOW(MainData->window));
      MainData->hidden = FALSE;
    }
  }

  return TRUE;
}

gboolean
tray_menu (GtkWidget *widget, GdkEventButton *event, gpointer d)
{
	GtkWidget *status_menu;
	GtkWidget *item, *image;

#ifdef TRACE_FUNCTION
	g_print( "tray_menu\n" );
#endif
	status_menu = gtk_menu_new();

	item = gtk_image_menu_item_new_with_label (_("Online"));
	image = gtk_image_new_from_pixbuf (icon_online_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_online),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Away"));
	image = gtk_image_new_from_pixbuf (icon_away_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_away),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Not Available"));
	image = gtk_image_new_from_pixbuf (icon_na_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_na),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Free for Chat"));
	image = gtk_image_new_from_pixbuf (icon_ffc_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_ffc),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Occupied"));
	image = gtk_image_new_from_pixbuf (icon_occ_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_occ),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Do Not Disturb"));
	image = gtk_image_new_from_pixbuf (icon_dnd_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_dnd),
	                  NULL);

	item = gtk_image_menu_item_new_with_label (_("Invisible"));
	image = gtk_image_new_from_pixbuf (icon_inv_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_invisible),
	                  NULL);

	item = gtk_menu_item_new ();
	gtk_widget_set_sensitive (item, FALSE);
	gtk_container_add (GTK_CONTAINER (status_menu), item);

	item = gtk_image_menu_item_new_with_label (_("Offline"));
	image = gtk_image_new_from_pixbuf (icon_offline_pixbuf);
	gtk_container_add (GTK_CONTAINER (status_menu), item);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (item), image);
	g_signal_connect (G_OBJECT (item), "activate",
	                  G_CALLBACK (icq_set_status_offline),
	                  NULL);

	gtk_widget_show_all (status_menu);

	gtk_menu_popup (GTK_MENU( status_menu), NULL, NULL,
	                NULL, NULL,
	                event->button, event->time);

	return TRUE;
}

void
tray_destroyed(GtkObject *object, gpointer d)
{

  tray_icon = NULL;

  tray_init();
  


  /* Show the main window if we dont have the tray */
  if (!tray_exists ()) {
    if (MainData->hidden)
      MainData->hidden = FALSE;
    
    gtk_window_present (GTK_WINDOW(MainData->window));
  }


}


gboolean
tray_exists (void)
{
  Screen *xscreen = DefaultScreenOfDisplay (gdk_display);
  Atom    selection_atom;
  char   *selection_atom_name;
	
  selection_atom_name = g_strdup_printf ("_NET_SYSTEM_TRAY_S%d",
					 XScreenNumberOfScreen (xscreen));
  selection_atom = XInternAtom (DisplayOfScreen (xscreen), selection_atom_name, False);
  g_free (selection_atom_name);
	
  if (XGetSelectionOwner (DisplayOfScreen (xscreen), selection_atom)) {
    return TRUE;
  } else {
    return FALSE;
  }
}
