/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanliststore.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanliststore:
 * @title:		GnomeScanListStore
 * @short_description:	An autofiled #GtkListStore
 *
 * #GnomeScanListStore do blah.
 */

#ifndef GNOME_SCAN_LIST_STORE_H
#define GNOME_SCAN_LIST_STORE_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnomescan.h>

G_BEGIN_DECLS;

#define	GNOME_TYPE_SCAN_LIST_STORE			(gnome_scan_list_store_get_type ())
#define GNOME_SCAN_LIST_STORE(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_LIST_STORE, GnomeScanListStore))
#define GNOME_SCAN_LIST_STORE_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_LIST_STORE, GnomeScanListStoreClass))
#define GNOME_IS_GNOME_SCAN_LIST_STORE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_LIST_STORE))
#define GNOME_IS_GNOME_SCAN_LIST_STORE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_LIST_STORE))
#define GNOME_SCAN_LIST_STORE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_LIST_STORE, GnomeScanListStoreClass))

typedef struct _GnomeScanListStore			GnomeScanListStore;
typedef struct _GnomeScanListStoreClass		GnomeScanListStoreClass;

struct _GnomeScanListStore {
  GtkListStore		parent;

  /*< public >*/
  GnomeScanContext	*context;
};

struct _GnomeScanListStoreClass {
  GtkListStoreClass	parent;

  /* SIGNALS */
};

enum {
  GNOME_SCAN_LIST_STORE_ERROR_FAILED
};

/* GObject functions */
GType			gnome_scan_list_store_get_type		(void)	G_GNUC_CONST;

/* Methods */

GtkListStore*		gnome_scan_list_store_new 			(GnomeScanContext *context);

GtkWidget*		gnome_scan_list_store_new_tree_view		(GnomeScanContext *context);

GtkWidget*		gnome_scan_list_store_new_combo_box		(GnomeScanContext *context);

G_END_DECLS

#endif
