//  Gnomoradio - gnomoradio/druid.cc
//  Copyright (C) 2004  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "druid.h"
#include "wraporadio/wraporadio.h"

using namespace std;
using namespace Gnomoradio;

Gnomoradio::Druid::Druid ()
	: Gtk::VBox(false, 8),
	  prev(_("Previous")),
	  next(_("Next")),
	  finish(_("Finish"))
{
	Gtk::HBox *hbox = manage(new Gtk::HBox(false, 8));
	hbox->pack_start(prev);
	hbox->pack_start(next);
	hbox->pack_start(finish);
	pack_start(page_bin);
	pack_start(*manage(new Gtk::HSeparator), Gtk::PACK_SHRINK);
	pack_start(*hbox, Gtk::PACK_SHRINK);

	prev.signal_clicked().connect(SigC::slot(*this, &Druid::on_prev));
	next.signal_clicked().connect(SigC::slot(*this, &Druid::on_next));
	finish.signal_clicked().connect(SigC::slot(*this, &Druid::on_finish));
}

Gnomoradio::Druid::~Druid ()
{
	for (list<Gtk::Widget*>::iterator p = page.begin(); p != page.end(); ++p)
		delete *p;
}

void Gnomoradio::Druid::append_page (Gtk::Widget *p)
{
	page.push_back(p);
}

void Gnomoradio::Druid::pages_ready ()
{
	current_page = page.begin();
	update_current_page();
}

void Gnomoradio::Druid::remove_everything_after_current_page ()
{
	for (;;) {
		list<Gtk::Widget*>::iterator p = current_page;
		++p;
		if (p == page.end())
			break;
		delete *p;
		page.erase(p);
	}
}

void Gnomoradio::Druid::set_able_to_move_on (bool t)
{
	list<Gtk::Widget*>::iterator p = current_page;
	++p;
	Gtk::Widget *button = (p == page.end()) ? (&finish) : (&next);
	button->set_sensitive(t);
}

void Gnomoradio::Druid::update_current_page ()
{
	page_bin.remove();
	page_bin.add(**current_page);

	list<Gtk::Widget*>::iterator next_page = current_page;
	++next_page;
	prev.set_sensitive(current_page != page.begin());
	next.set_sensitive(next_page != page.end());
	finish.set_sensitive(next_page == page.end());

	page_bin.show_all();
}

void Gnomoradio::Druid::on_prev ()
{
	--current_page;
	update_current_page();
}

void Gnomoradio::Druid::on_next ()
{
	signal_next(*current_page);
	++current_page;
	update_current_page();
}

void Gnomoradio::Druid::on_finish ()
{
	signal_finished();
	get_parent_window()->hide();
}
