/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * GnoWavCut -- a GNOME/GTK+ based RIFF PCM Wave file splitter
 * Copyright (C) 2000 Yoichi Imai <yoichi@silver-forest.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __MAIN_H__
#define __MAIN_H__

#ifndef FORMAT_PCM
#define FORMAT_PCM 0x0001
#endif
#define WAVE_HEADER_SIZE 44

typedef struct _WaveInfo {
	char id_riff[4];
	guint32 riff_size;
	char type_riff[4];
	char id_fmt[4];
	int fmt_size;
	short int format_tag;
	short int channels;
	int samples_per_sec;
	int size_per_sec;
	short int size_per_sample;
	short int bits_per_sample;
	char id_data[4];
	guint32 data_size;
} WaveInfo;

typedef struct _Buttons {
	GtkWidget *b_mini_rew_long;
	GtkWidget *b_mini_rew;
	GtkWidget *b_mini_insert;
	GtkWidget *label_mini;
	GtkWidget *b_mini_play;
	GtkWidget *b_mini_ff;
	GtkWidget *b_mini_ff_long;
	
	GtkWidget *button_rew;
	GtkWidget *button_stop;
	GtkWidget *button_pause;
	GtkWidget *button_play;
	GtkWidget *button_ff;
	
} Buttons;

typedef struct _GnoWavCut {
	GtkWidget *app;
	GtkWidget *appbar;
	
	GtkWidget *entry_file;
	GtkObject *volume_adj;
	GtkWidget *progress;
	GtkWidget *label_middle;
	GtkWidget *label_end;
	GtkWidget *entry_rate;
	GtkWidget *entry_bit;
	GtkWidget *entry_channel;
	
	GtkWidget *hscale;
	GtkObject *hadj;
	
	GtkWidget *entry_base;
	GtkWidget *fentry_dir;
	
	GtkWidget *entry_start;
	GtkWidget *entry_end;
	
	GtkWidget *clist;
	GtkWidget *label_mini;
	
	gchar *file_name;
	int dsp_fd;
	int wave_fd;
	int input_tag;
	
	gboolean hscale_can_move;
	gboolean now_playing;
	gboolean now_pause;
	gboolean now_mini_playing;
	
	int mini_play_size;
	int mini_old_point;
	
	Buttons *buttons;
	
	WaveInfo *wave_info;
} GnoWavCut;

/* #include <pthread.h> */
#include <errno.h>
#endif /* __MAIN_H__ */
