#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# $Id: $

from Base import *

# =============================================================================
# Exceptions
# =============================================================================

class ParameterNotFoundError (ClassRepositoryError):
  def __init__ (self, procedure, parameter):
    msg = u_("Procedure '%(procedure)s' has no parameter '%(parameter)s'") % \
            {"procedure": procedure,
             "parameter": parameter}
    ClassRepositoryError.__init__ (self, msg)


# =============================================================================
# Dictionary with all Parameters of a given procedure
# =============================================================================

class ParameterDict (BaseDictionary):

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------

  def __init__ (self, session, aProc, predefs = None):
    BaseDictionary.__init__ (self, session, 'gnue_parameter')

    self.__proc = aProc


  # ---------------------------------------------------------------------------
  # Create a new instance of a dictionary item
  # ---------------------------------------------------------------------------

  def _getNewItem (self, aObject):
    return Parameter (self._session, aObject, 
                      {"gnue_id": aObject.objectId})


  # ---------------------------------------------------------------------------
  # A reload returns only the parameters of the procedure 
  # ---------------------------------------------------------------------------

  def _getReloadCondition (self):
    return [["eq", ""], ["field", "gnue_procedure"], 
            ["const", self.__proc.gnue_id]]


  # ---------------------------------------------------------------------------
  # Get a condition to match a single parameter
  # ---------------------------------------------------------------------------

  def _getSingleCondition (self, key):
    res = self._getReloadCondition ()
    res.extend ([["eq", ""], ["field", "gnue_name"], ["const", key]])
    return res


  # ---------------------------------------------------------------------------
  # Get a list of columns which should be prepared on a find ()
  # ---------------------------------------------------------------------------

  def _getColumns (self):
    return [u"gnue_procedure", u"gnue_name", u"gnue_type", u"gnue_length",
            u"gnue_scale"]


  # ---------------------------------------------------------------------------
  # Create a key-not-found exception
  # ---------------------------------------------------------------------------

  def _itemNotFoundError (self, key):
    return ParameterNotFoundError (self.__proc.fullName, key)



# =============================================================================
# A parameter of a procedure
# =============================================================================

class Parameter (BaseObject):

  def __init__ (self, session, aObject, pDefs = None):
    BaseObject.__init__ (self, session, 'gnue_parameter', aObject, pDefs)
    self.fullName = self.gnue_name
    self.dbType   = self.gnue_type
