# GNU Enterprise Application Server - Testing unit 
#
# Copyright 2003-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: dtest.py 5257 2004-03-08 10:06:17Z johannes $
#

from gnue.appserver import classrep
from gnue.appserver.test import testApp

from Definition import *

if __name__ == '__main__':
  app = testApp ()
  sm = app.getSessionManager ()

  print "Requesting class 'gnue_property'\n"
  klass = sm.classes ["gnue_property"]

  print "\n"

  print "Requesting class 'address_person'\n"

# -------------
  klass = sm.classes ["address_person"]

  print "Name = %s, Comment = %s, Fullname = %s\n" % (klass.gnue_name, 
                    klass.gnue_comment, klass.fullName)
  print "Number of properties in class: %d" % len (klass.properties)
  print "Properties:"


  for p in klass.properties.keys ():
    pObj = klass.properties [p]
    print "Property %s: %s (%s)" % (pObj.gnue_name, pObj.gnue_type, 
        pObj.gnue_comment)
  print "End of properties"

  klass = sm.classes ["gnue_module"]
  print "Number of properties in %s: %d" % (klass.fullName, 
                      len (klass.properties))

# print sm.Classes.keys ()

# -----------------

  print "Now it should come faster (cached):\n"

  klass = sm.classes ["address_person"]

  print "Name = %s, Comment = %s, Fullname = %s\n" % (klass.gnue_name, 
                    klass.gnue_comment, klass.fullName)
  print "Number of properties in class: %d" % len (klass.properties)


  for p in klass.properties.keys ():
    pObj = klass.properties [p]
    print "Property %s: %s (%s)" % (pObj.gnue_name, pObj.gnue_type, 
         pObj.gnue_comment)

# ---- gnue_*

  print "Fetching gnue_class :)"
  gclass = sm.classes ["gnue_class"]
  print "Name = %s (full:%s) Comment = %s" % \
         (gclass.gnue_name, gclass.fullName, gclass.gnue_comment)

  print "Number of properties: %d" % len (gclass.properties)

