# GNU Enterprise Application Server - List Object
#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: geasConfiguration.py 5260 2004-03-08 13:38:06Z reinhard $

from gnue.common.formatting import GTypecast


ConfigOptions = (

  { 'Name'       : 'database',
    'Type'       : 'Setting',
    'Comment'    : _('Name of the database connection appserver is using'),
    'Description': _('Name of the database connection appserver is using'),
    'Typecast'   : GTypecast.text,
    'Default'    : 'gnue' },

  { 'Name'       : 'rpctype',
    'Type'       : 'Setting',
    'Comment'    : _('RPC Interface Type appserver is providing'),
    'Description': _('RPC Interface Type appserver is providing'),
    'Typecast'   : GTypecast.text,
    'Default'    : 'xmlrpc' },

  { 'Name'       : 'rpcport',
    'Type'       : 'Setting',
    'Comment'    : _('Port (if needed) for RPC Interface'),
    'Description': _('Port (if needed) for RPC Interface'),
    'Typecast'   : GTypecast.whole,
    'Default'    : '8765' },

  { 'Name'       : 'allowed_hosts',
    'Type'       : 'Setting',
    'Comment'    : _('Hosts which are allowed to access appserver'),
    'Description': _('Hosts which are allowed to access appserver'),
    'Typecast'   : GTypecast.text,
    'Default'    : '' },

  { 'Name'       : 'httpdir',
    'Type'       : 'Setting',
    'Comment'    : _('Directory for webfrontend http documents'),
    'Description': _('Directory for webfrontend http documents'),
    'Typecast'   : GTypecast.text,
    'Default'    : "/this_dir_shouldn't exist." }, # default should be overridden
)
