# GNU Enterprise Application Server - Language interface: list of objects
#
# Copyright 2003-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: ObjectList.py 5329 2004-03-16 14:54:04Z johannes $

from types import SliceType
from Object import Object

CACHE_STEP = 10

# ===========================================================================
# Class: ObjectList
# ===========================================================================
class ObjectList:

  # -------------------------------------------------------------------------
  # Constructor
  # -------------------------------------------------------------------------
  def __init__ (self, session, classname, cond, sort, properties):
    self.classname   = classname
    self.conditions  = cond
    self.sortOrder   = sort
    self.properties  = properties

    self.__session   = session
    self.__list      = []

    self.__buildList ()


  # -------------------------------------------------------------------------
  # Return the number of elements in this sequence
  # -------------------------------------------------------------------------
  def __len__ (self):
    return self.__length

  # -------------------------------------------------------------------------
  # Return a slice or a specific element of this sequence
  # -------------------------------------------------------------------------
  def __getitem__ (self, index):
    try:
      if type (index) == SliceType:
        return self.__list [index.start:index.stop]
      else:
        return self.__list [index]

    except:
      # try to populate the sequence with missing entries
      if self.__populateList ():

        # if successful try to return entry/entries again
        return self.__getitem__ (index)
      
      else:
        raise IndexError
      

  # -------------------------------------------------------------------------
  # Create an initial sequence
  # -------------------------------------------------------------------------
  def __buildList (self):
    sm  = self.__session.getSessionManager ()
    sid = self.__session.getSessionId ()

    self.__list_id = sm.request (sid, self.classname, self.conditions, 
                                      self.sortOrder, self.properties)
    self.__list = []
    self.__populateList ()

      
  # -------------------------------------------------------------------------
  # Populate Cache
  # -------------------------------------------------------------------------
  def __populateList (self):
    sm  = self.__session.getSessionManager ()
    sid = self.__session.getSessionId ()

    rset = sm.fetch (sid, self.__list_id, len (self.__list), CACHE_STEP, 0)
    for row in rset:
#     obj = Object (self.__session, self.classname, row [0])
      # FIXME: The above line should work as soon as RPC is unicode safe
      obj = Object (self.__session, self.classname, unicode (row [0]))
      self.__list.append (obj)

    # fix for gnue-common 0.5.1 release (will be removed for later releases 
    # of gnue-common)
    self.__length = len (self.__list)

    # return number of updated rows
    return len (rset)
    
