# GNU Enterprise Application Server - RPC client
#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: testRPC.py 5257 2004-03-08 10:06:17Z johannes $

from gnue.common.rpc import GComm
import test

# =============================================================================
# RPC test application
# =============================================================================

class testRpcApp (test.testApp):
  # standart settings
  type   = "xmlrpc"
  params = {"host": "localhost",
            "port": 8765,
            "transport": "http" }

  def setConnection(self,type,params):
    self.type=type
    self.params=params

  # ---------------------------------------------------------------------------
  # Request a session manager object
  # ---------------------------------------------------------------------------

  def getSessionManager (self):
    print "Opening RPC connection ..."
    server = GComm.attach (self.type, self.params)

    print "Setup an link to the session manager"
    sm = server.request ("Session")

    return sm

# =============================================================================
# Let it rock
# =============================================================================

if __name__ == "__main__":
  import sys
  app=testRpcApp()

  for i in sys.argv:
    if i in ('pyro','--pyro','--rpc-type=pyro'):
      app.setConnection('pyro',{})
  
  app.run()
  print "Thank you for playing!"
