#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# db2/Connection.py
#
# DESCRIPTION:
# Driver to provide access to data stored in a DB2 database
#
# NOTES:
#

__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

import string
import sys

from string import lower
from gnue.common.apps import GDebug
from gnue.common.datasources import GDataObjects
from gnue.common.datasources import GConnections
from gnue.common.datasources.drivers import DBSIG2

try:
  import DB2
except ImportError:
  raise GConnections.DependencyError, ('db2', None)

from gnue.common.datasources.drivers.db2.Schema.Discovery.Introspection import Introspection

class Connection(DBSIG2.DataObject):
  _driver = DB2
  _DatabaseError = "Database Error"
  defaultBehavior = Introspection
  supportedDataObjects = {
    'object': DBSIG2.DataObject_Object,
    'sql':    DBSIG2.DataObject_SQL
  }


  def connect(self, connectData={}):
    GDebug.printMesg(9,"DB2 database driver initializing")
    try:
      self.native = DB2.connect(uid=connectData['_username'],
                   pwd=connectData['_password'],
                   dsn=connectData['service'])
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

