#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GDebug.py
#
# DESCRIPTION:
# Intelligently handles traces and exception handling for Client Apps
#
# NOTES:
#
# HISTORY:
#

import string
import sys
from traceback import *
import __builtin__

_fh = sys.__stderr__
_conttest = 0
_DEBUG_LEVEL = 0
_DEBUGGER = None

class _stderrcatcher:
    def write(self, str):
        global _fh, _conttest
        for ch in str:
            if (_conttest == 0):
                _fh.write("DB000: ")
                _conttest = 1
            if ( ch != '\n'):
                _fh.write(ch)
            else:
                _fh.write('\n')
                _conttest = 0

    def writelines(self, list):
        for line in list:
            self.write(str)

def setDebugger(debugger):
    global _DEBUGGER
    _DEBUGGER = debugger

def setDebug (level, file=None):
  global _DEBUG_LEVEL, printMesg
  _DEBUG_LEVEL = int(level)

  if _DEBUG_LEVEL > 0:
    printMesg = _printMesg
  if (file):
    fh = open( file, 'w' )
    catchStderr( fh )
  else:
    catchStderr( sys.__stderr__ )
  __builtin__.__dict__['gDebug'] = printMesg


def catchStderr(fh):
    global _fh
    _fh = fh
    sys.stderr = _stderrcatcher()


def handleException(exc_info):
    #
    # Not used at present
    #
    type, exception, traceback = exc_info
    if (isinstance(exception, GETrace) ):
        printMesg( exception.level, exception.message)
    elif (not isinstance(exception, SystemExit)):
        strings = format_exception(type, exception, traceback)
        text = string.join(strings, '')
        printMesg(0, text)

#
# We use _noPrintMesg and _printMesg assignment to printMesg
# to speed things up when debug mode is not being used.  It's
# assigned in setDebug()
#
def _noPrintMesg(level, message, dropToDebugger=0):
  pass

def _printMesg(level, message, dropToDebugger=0):
    if ( level <= _DEBUG_LEVEL ):
      global _fh, _DEBUGGER
      if type(message)==type(u''):
          message=message.encode('utf-8')
      caller = extract_stack()[-2]
      try:
        if caller[0][-3:] == '.py':
          file = "[%s:%s] " % (string.split(caller[0][:-3],'/')[-1], caller[1])
        else:
          file = "[%s:%s] " % (string.split(caller[0],'/')[-1], caller[1])
      except:
        file = ""

      lines = string.split("%s" % message, '\n')
      for line in lines:
         _fh.write("DB%03d: %s%s\n" % (level, file, line))

      if dropToDebugger and _DEBUGGER:
        _DEBUGGER.set_trace()

printMesg = _noPrintMesg

__builtin__.__dict__['gDebug'] = printMesg

class GETrace(Exception):
    #
    #Exception class representing a debug message
    #not yet used for anything and probably won't be :)
    #
    def __init__(self, level=0, message="Trace Message"):
        Exception.__init__(self)
        self.level = level
        self.message = message












