#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# ComboBox.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from Menu import Menu
from Button import Button
from Control import Control
from TextBox import TextBox

class ComboBox(TextBox):
  def __init__(self,Parent,BoxName, Y, X, W, editable=0,**properties):
    TextBox.__init__(self, Parent, BoxName, Y, X, W-4)
    self.PARENT = Parent
    self.Y = Y
    self.X = X
    self.W = W - 4
    self.H = 1
    self.EDITABLE = editable

    menuName = (W-5) * ' '
    self._menu = Menu(Parent,'cbm',Y,X+1,menuName)
    self._button = Button(Parent,'cbbutt',Y,X+W-4,3,chr(tiDAW))
    self._button.SetMethod("CLICK", self._Show)
    self._menu.CANGETFOCUS = 0
    self._menu.SetMethod("CHOSEN",self._chosen)
    self._menu.maxLengthFixed = 1
    self._menu.maxLength = W - 4
    self._chosen = None
    self.VALUES = []

    Parent.AddControl(self._button)
##    Parent.AddControl(self._menu)

#  def Paint(self,v1,v2,v3):
#
#    return
#    Screen = self.PARENT.Screen()
#    Screen.AutoRefresh = 0
#    self.SetColor(1)
#    X = self._ABSX
#    Y = self._ABSY
#    W = self.W
##    Screen.PrintAt(Y,X,chr(tiVLINE))
##    Screen.PrintAt(Y,X+W-1,chr(tiVLINE))
##    Screen.PrintAt(Y+1,X, chr(tiLLC) + (W-2) * chr(tiHLINE) + chr(tiLRC))
#    Screen.AutoRefresh = 1

  def _Show(self,v1,v2,v3):
    self._menu.ShowOff(None,None,None)

  def _chosen(self,menu,id,text):
    self._chosen = id
    self._menu.ChangeTitle(text)
    chosen = self.GetMethod("CHOSEN")
    if chosen!=None:
      chosen(self,id,text)

  def AddItem(self,id,text):
    self._menu.AddItem(id,text)
    self.VALUES.append((id, text))

  def Clear(self):
    self._menu.Clear()
    self.VALUES = []

#  def SetValue(self, value):
#    gDebug(0,'WARNING: SetValue called on a combo box... not yet implemented')

#  def GetValue(self):
#    gDebug(0,'WARNING: GetValue called on a combo box... not yet implemented')

