#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# MenuItem.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from FocusedLabel import FocusedLabel

class MenuItem(FocusedLabel):
  def __init__(self,Parent,MenuName,Y,X,DisplayName = "", itemDescription="",
         statusbarlink=None, **properties):
    FocusedLabel.__init__(self,Parent,MenuName,Y,X,DisplayName, **properties)
    self.TITLE = DisplayName
    self.DESCRIPTION = itemDescription
    self.STATUSBARLINK = statusbarlink
    self.SetColor('MENUBAR','MENUBAR_FOCUS')

  def Run(self,v1,v2,v3):
    Container = self.PARENT.Screen()
    if v1 :
      self.ExecMethod("CLICK", self, None, None)
      return 1
    while 1:
      ch = Container.GetChar()
      if self.PARENT.BreakOrder(ch) :
        return
      global BACKWARDS
      if ch in (Container.TokRightArrow, Container.TokLeftArrow):
        BACKWARDS=0
        if ch == Container.TokLeftArrow:
          BACKWARDS=1
        parent = self.PARENT
        parent.breakUp = 1
        return 1
      elif ch in  (Container.TokDownArrow,  Container.TokNextField):
        BACKWARDS=0
        return 0
      elif ch in (Container.TokUpArrow,):
        BACKWARDS=1
        return 0
      elif ch == Container.TokActivate:
        self.ExecMethod("CLICK",self,None,None)
        return 1
      else:
        self.ExecMethod("SYSGOTFOCUS",None,None,None)

#  def Paint(self, HasFocus, v2, v3):
#    Container = self.PARENT.Screen()
#    if self.active:
#      if HasFocus :
#        color = self.FOCUSCOLOR
#        if self.STATUSBARLINK and self.STATUSBARLINK.STATUSBAR:
#          self.STATUSBARLINK.STATUSBAR.SetText(self.STATUSBARLINK.STATUSBAR_INDEX, self.DESCRIPTION)
#      else:
#        color = self.COLOR
#    else:
#      color = self.COLOR
#    Y = self._ABSY
#    X = self._ABSX
#    caption = self.CAPTION
#    Container.PrintAt(Y,X,caption, color)


