#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# MsgBoxOK.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from Button import Button
from Label import Label
from Dialog import Dialog

class MsgBoxOK(Dialog):
  """
    A sample 'standard' OK dialog box for short messages.
  """
  def __init__(self, Parent, Message, **properties):
    SIOInstance = Parent.Screen()
    sMCOL = SIOInstance.MAXCOL
    sMROW = SIOInstance.MAXROW
    MsgLen = len(Message)

    DialogWidth = MsgLen + 4
    DialogHeight = 6

    # adjust dialog, if need be, to hold OK btn comfortably
    if DialogWidth < 6:  
      DialogWidth = 10

    r1 = (sMROW - DialogHeight) / 2 
    r2 = r1 + DialogHeight
  
    c1 = (sMCOL - DialogWidth) / 2 
    c2 = c1 + DialogWidth

    Dialog.__init__(self, Parent, r1, c1, r2, c2, **properties)

    tCmd = Button(self, "TheBtn", 5, (DialogWidth - 6) / 2, 6, "OK")
    tCmd.EXITFORM = 1
    self.AddDialogControl(tCmd)
    self.AddDialogControl(Label(self, "TheMsg", 1, 2, Message))

  def Show(self):
    self.Screen().LoLight()
    t = self.RunDialog()
    return t
  

