#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# Progress.py
#
# DESCRIPTION:
#
# NOTES:
#



#
# TODO: Paint still needs some refinement possibly.  Specifically some sort of
# TODO: flags for 'REFRESH' method calls.  Seems to work OK though.
#

import curses

from constants import *
from Control import Control

class Progress(Control):
  """ a simple progress bar
  """
  def __init__(self, Parent, ProgressName, Y, X, W, Max, **properties):
    Control.__init__(self, Parent, ProgressName, **properties)
    self.PARENT = Parent
    self.X = X
    self.Y = Y
    self.W = W
    self.H = 1
    self.MAX = Max
    self.VALUE = 0
    self.CANGETFOCUS = 0
    self.SetMethod("SYSPAINT", self.Paint)
    self.SetMethod("PAINT", self.Paint)
    self.SetMethod("REFRESH", self.Paint)
    self.SetColor(3)
    self.PRIOR_COLOR = 3
    # working area is the prescribed with - 4 for effect
    self.WorkingArea = float(self.W- 4)

  def Paint(self, ActionHilighted=None, v2=None, v3=None):
    "Paint the progrss bar on the screen"
    Screen = self.PARENT.SCREEN
    # set the lolight
    self.LoLight()
    # PERCENT used space.
    UsedSpace = float(self.VALUE) / \
      float(self.MAX)
    # Space actually marked so far:
    MarkedSpace = int((UsedSpace * self.WorkingArea))
    # if amount marked up is less than the working area
    if MarkedSpace <= self.WorkingArea:
      Screen.AutoRefresh = 0
      Screen.PrintAt(self._ABSY, self._ABSX, "[ ")
      Screen.PrintAt(self._ABSY,
        self._ABSX+ self.W- 2, " ]")
      for i in range(0, MarkedSpace):
        Screen.PutAt(self._ABSY,
          self._ABSX+ 2 + i, ' ', curses.A_STANDOUT)
      Screen.AutoRefresh = 1
      Screen.Refresh()

  def Init(self, Max):
    "Initialize the progress bar"
    self.pbClear()  # previous usages will leave the area tainted.
    if self.active:
      self.MAX = Max
      self.VALUE = 0
      self.Paint(0, None,None)
#      self.ExecMethod("REFRESH",None,None,None)
  
  def Step(self):
    if self.active:
      now = self.VALUE
      now += 1
      self.VALUE = now
      self.Paint(0,0,0)
#      self.ExecMethod("REFRESH",None,None,None)

  def DeActivate(self,state):
     self.pbClear()
     Control.DeActivate(self,state)

  def pbClear(self):
    "Clear the progress bar of any progress marks"
    # fetch up the screen
    Screen = self.PARENT.SCREEN
    Screen.AutoRefresh = 0
    # set the color to be consistent with initial state
    self.LoLight()
    Screen.PrintAt(self.Y, self.X, "[ ")
    Screen.PrintAt(self.Y, 
      self.X+ self.W- 2, " ]")
    for i in range(0, self.WorkingArea):
      Screen.PutAt(self.Y, 
        self.X+ 2 + i, ' ', curses.A_NORMAL)
    Screen.AutoRefresh = 1
    Screen.Refresh()

