#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# RadioGroup.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from RadioButton import RadioButton
from Control import Control

class RadioGroup(Control):
  """
  """
  def __init__(self, Root, GroupName, Y, X, W,**properties):
    Control.__init__(self,Root,GroupName,**properties)
    self.Y = Y
    self.X = X
    self.W = W 
    self.H = 0 
    self.Parent = Root
    self.Name = GroupName
    self.SetMethod("SYSPAINT",self.Paint)
    self.CANGETFOCUS = 0
    self.buttons = []
    self.activeItem = None
    self._paint = 1
   
  def Paint(self,v1,v2,v3):
     for i in self.buttons:
       i.Paint(None,None,None)
     self.PARENT.Screen().Refresh()

  def AddItem(self,itemId,Caption,X=-1,Y=-1,W=-1):
    posX = X
    posY = Y
    posW = W

    if posW == -1:
      posW = self.W
    if posX == -1:
      posX = self.X
    if posY == -1:
      posY = self.Y+ len(self.buttons) #self.H

    if len(Caption) > posW-3:
      cutoff = len(Caption) - (posW-3 )
      Caption = Caption[:-cutoff]
    button = RadioButton(self.Parent,str(itemId), \
               posY, \
               posX, Caption, itemId)
    button.ACTIVE = 0
    self.Parent.AddControl(button)
    button.SetMethod("CLICK",self._ToggleItem)
    self.buttons.append(button)
    self.H = self.H+ 1

  def AddButton(self, button):
    if string.find(str(button.__class__), '.RadioButton') != -1:
      self.buttons.append(button)

  def GetActiveItem(self):
    if self.activeItem == None:
      return None
    return self.activeItem.ID

  def _ToggleItem(self,item,v2,v3):
    if self.activeItem != None:
      self.activeItem.ACTIVE = 0
      self.activeItem.Paint(None,None,None)
    self.activeItem = item
    item.ACTIVE = 1
    item.Paint(1,None,None)
    self.Parent.Screen().Refresh()


