#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
"""
Information on this driver
"""

#
# Notes on this driver
#
name = _("GNUe AppServer Driver")
url = "http://www.gnuenterprise.org/tools/appserver/"
doc = """
Description
-----------
Python driver GNUe Application Server.

Support
-------
POSIX Support: YES

Win32 Support: YES

Platforms Tested:

  - Linux/Unix (Debian, RedHat, SuSe, etc)
  - Windows NT/XP/2000

Connection Properties
---------------------
* host       -- This is the hostname/ip address of the host running AppServer (required)
* port       -- The port that AppServer is running on (required)
* timeout    -- Command timeout in seconds (optional)
* transport  -- Transport used for network connections (http, https) (required)
* rpctype    -- RPC driver used for network communication (xmlrpc, soap, etc.)
  See GNUe Common's RPC documentation for a list of all RPC types. (required)

Examples
--------
  [appserver]
  comment = Connection to the GNUe Application Server
  provider = appserver
  rpctype = xmlrpc
  host = localhost
  port = 8765
  transport = http


Notes
-----
1. GNUe AppServer works natively in utf-8, so encoding= is not a valid property.
"""
