#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# dbf/DBdriver.py
#
# DESCRIPTION:
# Virtual database driver for loading data from a DBF file
#
# NOTES:
# Used whenever a data has to be imported from dbase III+
#

__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

from gnue.common.datasources.GDataObjects import Error
from gnue.common.datasources.drivers import Base
from gnue.common.datasources import GConnections

try:
  import dbf
except ImportError:
  raise GConnections.DependencyError, ('dbf', None)

class Connection(Base.Connection):
  supportedDataObjects = {'object': DataObject,
                           'static': DataObject} # TODO: Why static?!?
  _DatabaseError = Error


  # We don't do connections (we are connectionless)
  def connect(self, connectData={}):
    try:
      GDebug.printMesg(3,'Open file: %s' % (connectData['directory']+connectData['dbname']))
      self._dataConnection = dbf.dbf(connectData['directory']+\
                                     connectData['dbname'])
    except IOError:
      tmsg = _('DBF file not found.')
      raise self._DatabaseError, tmsg
    except TypeError:
      tmsg = _('Wrong file format.')
      raise self._DatabaseError, tmsg

    # build field list
    self._fieldReferences=[]
    for f in self._dataConnection.fields:
      self._fieldReferences.append(string.lower(f[0]))

