#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# mysql/DBdriver.py
#
# DESCRIPTION:
# Driver to provide access to data vi MySQL
#
# NOTES:
# Supports transactions if the MySQL server is compiled w/transaction support
# (which it does NOT by default)

__all__ = ['Connection']

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

import string
import sys
from gnue.common.datasources import GDataObjects, GConditions, GConnections
from gnue.common.apps import GDebug

try:
  import MySQLdb
except ImportError:
  raise GConnections.DependencyError ('mysql-python',
                                'http://sourceforge.net/projects/mysql-python')

from gnue.common.datasources.drivers import DBSIG2
from DataObject import *
from gnue.common.datasources.drivers.mysql.Schema.Discovery.Introspection import Introspection


######################################################################
#
#  GConnection object for PostgreSQL-based drivers
#
class Connection(DBSIG2.Connection):

  _driver = MySQLdb
  defaultBehavior = Introspection
  _DatabaseError = MySQLdb.DatabaseError
  supportedDataObjects = {
    'object': DataObject_Object,
    'sql':    DataObject_SQL
  }

  def connect(self, connectData={}):
    GDebug.printMesg(1,"Mysql database driver initializing")

    # 1. just allow string type username/password 2. None -> ''
    user   = str(connectData['_username'] or '')
    passwd = str(connectData['_password'] or '')

    try:
      self.native = MySQLdb.connect(user=user,
                   passwd=passwd,
                   host=connectData['host'],
                   db=connectData['dbname'])

    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    self._beginTransaction()


  def _beginTransaction(self):
    try:
      self.native.begin()
    except:
      pass


  #########
  #
  # Extensions to the basic GConnection object
  #

  # Return the current date, according to database
  def getTimeStamp(self):
    return self.sql1 ("select current_timestamp")

  # Return a sequence number from sequence 'name'
  #def getSequence(self, name):
  #  raise "Not supported"
