#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Oracle/Base/Connection.py
#
# DESCRIPTION:
# Driver to provide access to data via Computronix's Oracle/Python Driver
# Requires cx_Oracle 2.2+ (http://www.computronix.com/utilities/)
#
# NOTES:
#
#   Supported attributes (via connections.conf or <database> tag)
#
#     service=    This is the Oracle TNS name for your connection  (required)
#

__all__ = ['Connection']

import sys, string
from gnue.common.datasources import GDataObjects, GConditions
from gnue.common.apps import GDebug
from gnue.common.datasources.drivers import DBSIG2
from gnue.common.datasources.drivers.oracle.Schema.Discovery.Introspection import Introspection
from DataObject import *


#
#  Extensions to Trigger Namespaces
#
class Connection(DBSIG2.Connection):

  defaultBehavior = Introspection
  supportedDataObjects = {
    'object': DataObject_Object,
    'sql':    DataObject_SQL
  }

  _dateTimeFormat = "'%Y-%m-%d %H:%M:%S'"

  #
  # Connect to database
  def connect(self, connectData={}):
    GDebug.printMesg(1,"Oracle database driver initializing")

    if not hasattr(self,'_DatabaseError'):
      self._DatabaseError = self._driver.DatabaseError

    try:
      self.native = self._driver.connect("%s/%s@%s" \
                % (connectData['_username'], \
                   connectData['_password'], \
                   connectData['service']))
    except self._DatabaseError, value:
      raise GDataObjects.LoginError, value

    if connectData.has_key('datetimeformat'):
      self._dateTimeFormat = "'%s'" % connectData['datetimeformat']


  #
  #  Extensions
  #

  # Return the current date, according to database
  def getTimeStamp(self):
    return self.__singleQuery("select sysdate from dual")

  # Return a sequence number from sequence 'name'
  def getSequence(self, name):
    return self.__singleQuery("select %s.nextval from dual" % name)

  # Used internally
  def __singleQuery(self, statement):
    cursor = self.native.cursor()
    try:
      cursor.execute(statement)
      rv = cursor.fetchone()
      cursor.close()
    except mesg:
      GDebug.printMesg(1,"**** Unable to execute extension query")
      GDebug.printMesg(1,"**** %s" % mesg)
      cursor.close()
      return None

    try:
      return rv[0]
    except:
      return None




