#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# config/ResultSet.py
#
# DESCRIPTION:
# Implementation of dbdriver for use with configuration files
#
# NOTES and TODO:
#
# @see Connection.py
#

from gnue.common.datasources.drivers.Base.ResultSet import ResultSet
from RecordSet import Configfile_RecordSet
from gnue.common.apps import GDebug

#
# Configfile_ResultSet
#
class Configfile_ResultSet(ResultSet): 
  def __init__(self, dataObject, cursor=None, \
        defaultValues={}, masterRecordSet=None): 
    ResultSet.__init__(self, dataObject, cursor, defaultValues, masterRecordSet)
    self._recordSetClass = Configfile_RecordSet
    
    GDebug.printMesg(5, 'ResultSet created')


  def _loadNextRecord(self):
    retval=0
    # all records has to be loaded in cache during resultset initialisation
    if self._cursor:
   
      # load all records at once  
      for dict in self._cursor:
            
        record=self._recordSetClass(parent=self,initialData=dict)
        self._cachedRecords.append (record)

        # increase record count by one
        self._recordCount=self._recordCount+1

        retval=1
        
      self._cursor=[] # after adding the values, delete them from cursor
      
    # if no record returned return a zero
    return retval
    
  # Post changes to the database
  # similar function like in GDataObjects, just with an missing line
  def post(self, foreign_keys={}):
    # post our changes

    recordPosition = 0
    while recordPosition < len(self._cachedRecords):
      record = self._cachedRecords[recordPosition]

      delete = record._emptyFlag or record._deleteFlag
      if not delete:
        # Flip the flag for 'default' values to true so that hidden
        # default fields are included in insert statements
        if record.isPending():
          for field in self._dataObject._defaultValues.keys():
            record._modifiedFlags[field] = 1

        for field in foreign_keys.keys():
          record._fields[field] = foreign_keys[field]
          # Some DBs will throw an exception if you update a Primary Key
          # (even if you are updating to the same value)
          if record._insertFlag:
            record._modifiedFlags[field] = 1

        recordPosition += 1
      else:
        # Adjust the current record if a preceding record
        # or the current record is deleted
        if recordPosition <= self._currentRecord:
          self._currentRecord -= 1
        self._cachedRecords.pop(recordPosition)
        self._recordCount -= 1
        
      record._updateFlag = 1
      record.post()

    # Move to record 0 if all preceding records were deleted
    # (or set to -1 if all records were deleted)
    if self._currentRecord < 0:
      if len(self._cachedRecords):
        self._currentRecord = 0
      else:
        self._currentRecord = -1

